/*
 * Decompiled with CFR 0.152.
 */
package plfx.showcase.navigation;

import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.GridPane;
import plfx.element.ButtonListener;
import plfx.element.SimpleSButton;
import plfx.model.action.ActionNotifier;
import plfx.navigation.GuiNavigation;
import plfx.screen.pay.ButtonActionListener;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.ButtonInit;

public class ShowcaseNavigation3x
implements GuiNavigation {
    private static final int ROW_COUNT = 4;
    @FXML
    private GridPane navigationRoot;
    @FXML
    private GridPane labelsGrid;

    public void init(Map<String, ButtonInit> navigations, ActionNotifier notifier) throws InitException {
        this.navigationRoot.getChildren().clear();
        if (navigations == null || navigations.isEmpty()) {
            this.navigationRoot.add((Node)this.labelsGrid, 0, 0, 1, 4);
        } else if (this.navigationRoot != null && this.labelsGrid != null && notifier != null) {
            int i = 0;
            for (Map.Entry<String, ButtonInit> navi : this.getPrepearedNaviList(navigations)) {
                Button button = new Button();
                button.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
                SimpleSButton sbutton = new SimpleSButton(button);
                sbutton.setText(navi.getValue().getName());
                if (navi.getValue().isEnable()) {
                    button.getStyleClass().add((Object)"nbutton");
                    sbutton.setListener((ButtonListener)new ButtonActionListener(navi.getKey(), notifier));
                } else {
                    button.getStyleClass().add((Object)"nbutton-disable-click");
                }
                this.navigationRoot.add((Node)button, 0, i);
                ++i;
            }
            this.navigationRoot.add((Node)this.labelsGrid, 0, i, 1, 4 - i);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    public String toString() {
        return "ShowcaseNavigation3x";
    }

    private List<Map.Entry<String, ButtonInit>> getPrepearedNaviList(Map<String, ButtonInit> navigations) {
        LinkedList<Map.Entry<String, ButtonInit>> res = new LinkedList<Map.Entry<String, ButtonInit>>(navigations.entrySet());
        Iterator i = res.iterator();
        while (i.hasNext()) {
            if (!((ButtonInit)((Map.Entry)i.next()).getValue()).isCurrent()) continue;
            i.remove();
        }
        ListIterator li = res.listIterator();
        int cnt = 0;
        while (li.hasPrevious()) {
            li.previous();
            if (++cnt < 4) continue;
            li.remove();
        }
        return res;
    }
}

