/*
 * Decompiled with CFR 0.152.
 */
package plfx.showcase.keyboard.letter;

import java.net.URL;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.Pane;
import plfx.input.keyboard.KeyboardListener;
import plfx.input.keyboard.KeyboardMessageTemplate;
import plfx.input.keyboard.letter.Layout;
import plfx.input.keyboard.letter.LayoutFilter;
import plfx.input.keyboard.letter.LetterKeyboard;
import plfx.msg.MessageTemplate;
import plfx.msg.screen.ScreenProcessor;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardCase;
import ru.softlogic.input.model.field.text.KeyboardType;

public class ShowcaseLetterKeyboard
implements LetterKeyboard {
    private static final String FX_ID_SYMB_PREFIX = "symb_";
    private static final String FX_ID_DGTL_PREFIX = "dgtl_";
    private static final String STYLE_ACTIVE = "caps-active";
    @FXML
    private Pane keyboardPane;
    @FXML
    private Pane keyboardPaneNoSymb;
    @FXML
    private Pane keyboardPaneSymb;
    @FXML
    private Pane keyboardPaneDgtl;
    @FXML
    private Button set1Button;
    @FXML
    private Button set2Button;
    @FXML
    private Button set3Button;
    @FXML
    private Button set4Button;
    @FXML
    private Button setSymb;
    @FXML
    private Button setLang;
    @FXML
    private Button capsButton;
    @FXML
    private Button clearButton;
    @FXML
    private Button clearLastButton;
    @FXML
    private Button enterButton;
    @FXML
    private Button spaceButton;
    @FXML
    private Button symbSet1Button;
    @FXML
    private Button symbSet2Button;
    @FXML
    private Button symbSet3Button;
    @FXML
    private Button symbSet4Button;
    @FXML
    private Button symbSetSymb;
    @FXML
    private Button symbSetLang;
    @FXML
    private Button symbCapsButton;
    @FXML
    private Button symbClearButton;
    @FXML
    private Button symbClearLastButton;
    @FXML
    private Button symbEnterButton;
    @FXML
    private Button symbSpaceButton;
    @FXML
    private Button dgtlClearLastButton;
    @FXML
    private Button dgtlEnterButton;
    private List<Button> digitButtons;
    private List<Button> symbDigitButtons;
    private List<Button> dgtlDigitButtons;
    private List<Button> letterButtons;
    private List<Button> symbLetterButtons;
    private List<Button> dgtlLetterButtons;
    private Map<String, Layout> layouts;
    private List<String> keyboardLayoutNames;
    private Keyboard keyboard;
    private String currentSetName;
    private String lastSetName;
    private KeyboardCase currentCase;
    private KeyboardListener listener;
    private Map<String, Layout> langs;
    private List<Layout> availableLangs;
    private boolean symbPressed;
    private String lastStyle;
    private int n;
    private String lastName;

    public void initialize(URL location, ResourceBundle resources) {
        Node p;
        int i;
        this.digitButtons = new LinkedList<Button>();
        for (i = 0; i < 10 && (p = this.keyboardPane.lookup("#d" + i)) != null && p instanceof Button; ++i) {
            this.digitButtons.add((Button)p);
        }
        this.letterButtons = new LinkedList<Button>();
        for (i = 0; i < 50 && (p = this.keyboardPane.lookup("#let" + i)) != null && p instanceof Button; ++i) {
            this.letterButtons.add((Button)p);
        }
        this.symbDigitButtons = new LinkedList<Button>();
        for (i = 0; i < 10 && (p = this.keyboardPane.lookup("#symb_d" + i)) != null && p instanceof Button; ++i) {
            this.symbDigitButtons.add((Button)p);
        }
        this.symbLetterButtons = new LinkedList<Button>();
        for (i = 0; i < 50 && (p = this.keyboardPane.lookup("#symb_let" + i)) != null && p instanceof Button; ++i) {
            this.symbLetterButtons.add((Button)p);
        }
        this.dgtlDigitButtons = new LinkedList<Button>();
        for (i = 0; i < 10 && (p = this.keyboardPane.lookup("#dgtl_d" + i)) != null && p instanceof Button; ++i) {
            this.dgtlDigitButtons.add((Button)p);
        }
        this.dgtlLetterButtons = new LinkedList<Button>();
        for (i = 0; i < 50 && (p = this.keyboardPane.lookup("#dgtl_let" + i)) != null && p instanceof Button; ++i) {
            this.dgtlLetterButtons.add((Button)p);
        }
        CapsActionListener cal = new CapsActionListener();
        Optional.ofNullable(this.capsButton).ifPresent(b -> b.setOnAction((EventHandler)cal));
        Optional.ofNullable(this.symbCapsButton).ifPresent(b -> b.setOnAction((EventHandler)cal));
        Optional.ofNullable(this.setSymb).ifPresent(b -> {
            b.setOnAction((EventHandler)new SetSymbActionListener());
            b.setDisable(true);
        });
        Optional.ofNullable(this.symbSetSymb).ifPresent(b -> {
            b.setOnAction((EventHandler)new SetSymbActionListener());
            b.setDisable(true);
        });
        Optional.ofNullable(this.set1Button).ifPresent(b -> {
            SetActionListener sal = new SetActionListener("set1", "true".equals(b.getProperties().get((Object)"golast")));
            b.setOnAction((EventHandler)sal);
            Optional.ofNullable(this.symbSet1Button).ifPresent(symbB -> symbB.setOnAction((EventHandler)sal));
        });
        Optional.ofNullable(this.set2Button).ifPresent(b -> {
            SetActionListener sal = new SetActionListener("set2", "true".equals(b.getProperties().get((Object)"golast")));
            b.setOnAction((EventHandler)sal);
            Optional.ofNullable(this.symbSet2Button).ifPresent(symbB -> symbB.setOnAction((EventHandler)sal));
        });
        Optional.ofNullable(this.set3Button).ifPresent(b -> {
            SetActionListener sal = new SetActionListener("set3", "true".equals(b.getProperties().get((Object)"golast")));
            b.setOnAction((EventHandler)sal);
            Optional.ofNullable(this.symbSet3Button).ifPresent(symbB -> symbB.setOnAction((EventHandler)sal));
        });
        Optional.ofNullable(this.set4Button).ifPresent(b -> {
            SetActionListener sal = new SetActionListener("set4", "true".equals(b.getProperties().get((Object)"golast")));
            b.setOnAction((EventHandler)sal);
            Optional.ofNullable(this.symbSet4Button).ifPresent(symbB -> symbB.setOnAction((EventHandler)sal));
        });
        Optional.ofNullable(this.setLang).ifPresent(b -> {
            b.setOnAction((EventHandler)new SetLangActionListener());
            b.setDisable(true);
        });
        Optional.ofNullable(this.symbSetLang).ifPresent(b -> {
            b.setOnAction((EventHandler)new SetLangActionListener());
            b.setDisable(true);
        });
        LocalActionListener lal = new LocalActionListener();
        Optional.ofNullable(this.spaceButton).ifPresent(b -> b.setOnAction((EventHandler)lal));
        Optional.ofNullable(this.clearButton).ifPresent(b -> b.setOnAction((EventHandler)lal));
        Optional.ofNullable(this.enterButton).ifPresent(b -> b.setOnAction((EventHandler)lal));
        Optional.ofNullable(this.clearLastButton).ifPresent(b -> b.setOnAction((EventHandler)lal));
        Optional.ofNullable(this.symbSpaceButton).ifPresent(b -> b.setOnAction((EventHandler)lal));
        Optional.ofNullable(this.symbClearButton).ifPresent(b -> b.setOnAction((EventHandler)lal));
        Optional.ofNullable(this.symbEnterButton).ifPresent(b -> b.setOnAction((EventHandler)lal));
        Optional.ofNullable(this.symbClearLastButton).ifPresent(b -> b.setOnAction((EventHandler)lal));
        Optional.ofNullable(this.dgtlEnterButton).ifPresent(b -> b.setOnAction((EventHandler)lal));
        Optional.ofNullable(this.dgtlClearLastButton).ifPresent(b -> b.setOnAction((EventHandler)lal));
        this.letterButtons.forEach(b -> b.setOnAction((EventHandler)lal));
        this.digitButtons.forEach(b -> b.setOnAction((EventHandler)lal));
        this.symbLetterButtons.forEach(b -> b.setOnAction((EventHandler)lal));
        this.symbDigitButtons.forEach(b -> b.setOnAction((EventHandler)lal));
        this.dgtlLetterButtons.forEach(b -> b.setOnAction((EventHandler)lal));
        this.dgtlDigitButtons.forEach(b -> b.setOnAction((EventHandler)lal));
    }

    public void setLayouts(Map<String, Layout> layouts) {
        if (layouts == null) {
            throw new NullPointerException("List<Layout>");
        }
        if (layouts.size() < 1) {
            throw new NullPointerException("Layouts size is wrong: " + layouts.size());
        }
        this.layouts = layouts;
        this.availableLangs = new LinkedList<Layout>();
        this.langs = new LinkedHashMap<String, Layout>();
        layouts.values().stream().filter(l -> l.getCode().length() == 2).forEach(l -> this.langs.put(l.getCode(), (Layout)l));
    }

    public void init(Keyboard keyboard) {
        if (this.keyboard == keyboard) {
            return;
        }
        this.keyboard = keyboard;
        Set availableLayouts = this.layouts.values().stream().map(l -> l.getCode()).collect(Collectors.toSet());
        String replaceRules = this.layouts.get("set1").getProperties().getProperty("set1.replace.rules");
        this.keyboardLayoutNames = LayoutFilter.getAvailableLayouts((List)keyboard.getLayoutNames(), availableLayouts, (String)replaceRules);
        boolean enable = keyboard.getType() != KeyboardType.Letter;
        this.digitButtons.stream().filter(b -> b != null).forEach(b -> b.setDisable(!enable));
        this.symbDigitButtons.stream().filter(b -> b != null).forEach(b -> b.setDisable(!enable));
        Optional.ofNullable(this.clearButton).ifPresent(b -> {
            if (keyboard.getExtraCharacter() != null) {
                b.setText("" + keyboard.getExtraCharacter());
            } else if (b.getText() == null || b.getText().isEmpty()) {
                b.setText("X");
            }
        });
        Optional.ofNullable(this.symbClearButton).ifPresent(b -> {
            if (keyboard.getExtraCharacter() != null) {
                b.setText("" + keyboard.getExtraCharacter());
            } else if (b.getText() == null || b.getText().isEmpty()) {
                b.setText("X");
            }
        });
        this.setAccessible();
        this.currentSetName = null;
        this.lastName = null;
        this.symbPressed = false;
        if (this.keyboardLayoutNames != null && !this.keyboardLayoutNames.isEmpty()) {
            String setName;
            this.currentSetName = this.keyboardLayoutNames.get(0);
            String ls = this.lastStyle;
            if (this.setLang != null) {
                this.n = 0;
                if (!"symb".equals(this.currentSetName)) {
                    this.symbPressed = false;
                    this.setLang.getStyleClass().remove((Object)ls);
                    this.lastStyle = "lang-" + this.currentSetName;
                    this.setLang.getStyleClass().add((Object)this.lastStyle);
                } else {
                    this.symbPressed = true;
                    this.setLang.getStyleClass().remove((Object)ls);
                    if (this.keyboardLayoutNames.size() > 1) {
                        setName = this.keyboardLayoutNames.get(1);
                        this.lastStyle = "lang-" + setName;
                        this.setLang.getStyleClass().add((Object)this.lastStyle);
                    } else {
                        this.lastStyle = null;
                    }
                }
            }
            if (this.symbSetLang != null) {
                this.n = 0;
                if (!"symb".equals(this.currentSetName)) {
                    this.symbPressed = false;
                    this.symbSetLang.getStyleClass().remove((Object)ls);
                    this.lastStyle = "lang-" + this.currentSetName;
                    this.symbSetLang.getStyleClass().add((Object)this.lastStyle);
                } else {
                    this.symbPressed = true;
                    this.symbSetLang.getStyleClass().remove((Object)ls);
                    if (this.keyboardLayoutNames.size() > 1) {
                        setName = this.keyboardLayoutNames.get(1);
                        this.lastStyle = "lang-" + setName;
                        this.symbSetLang.getStyleClass().add((Object)this.lastStyle);
                    } else {
                        this.lastStyle = null;
                    }
                }
            }
        }
        this.currentCase = keyboard.getDefaultCase();
        this.refreshSet();
    }

    public void setKeyboardListener(KeyboardListener listener) {
        this.listener = listener;
    }

    private void refreshSet() {
        Button btn2;
        String currentSet = this.layouts.size() < 2 ? this.layouts.get("set1").getData() : this.layouts.get("set2").getData();
        for (Layout l : this.layouts.values()) {
            if (!l.getCode().equals(this.currentSetName)) continue;
            currentSet = l.getData();
            break;
        }
        if (this.currentCase == KeyboardCase.Lower) {
            this.capsButton.getStyleClass().removeAll((Object[])new String[]{STYLE_ACTIVE});
            this.symbCapsButton.getStyleClass().removeAll((Object[])new String[]{STYLE_ACTIVE});
        } else {
            this.capsButton.getStyleClass().add((Object)STYLE_ACTIVE);
            this.symbCapsButton.getStyleClass().add((Object)STYLE_ACTIVE);
        }
        this.keyboardPaneDgtl.setVisible(false);
        this.keyboardPaneSymb.setVisible(this.symbPressed);
        this.keyboardPaneNoSymb.setVisible(!this.symbPressed);
        if (this.symbPressed) {
            if (currentSet != null && this.keyboard.getType() != KeyboardType.Digital) {
                for (int i = 0; i < this.symbLetterButtons.size(); ++i) {
                    btn2 = this.symbLetterButtons.get(i);
                    if (i < currentSet.length() && ' ' != currentSet.charAt(i)) {
                        if (this.currentCase == KeyboardCase.Lower) {
                            btn2.setText(Character.toString(Character.toLowerCase(currentSet.charAt(i))));
                        } else {
                            btn2.setText(Character.toString(Character.toUpperCase(currentSet.charAt(i))));
                        }
                        btn2.setDisable(false);
                        continue;
                    }
                    btn2.setText("");
                    btn2.setDisable(true);
                }
            } else {
                this.symbLetterButtons.stream().forEach(btn -> {
                    btn.setText("");
                    btn.setDisable(true);
                });
            }
        } else if (currentSet != null && this.keyboard.getType() != KeyboardType.Digital) {
            this.keyboardPaneDgtl.setVisible(false);
            for (int i = 0; i < this.letterButtons.size(); ++i) {
                btn2 = this.letterButtons.get(i);
                if (i < currentSet.length() && ' ' != currentSet.charAt(i)) {
                    if (this.currentCase == KeyboardCase.Lower) {
                        btn2.setText(Character.toString(Character.toLowerCase(currentSet.charAt(i))));
                    } else {
                        btn2.setText(Character.toString(Character.toUpperCase(currentSet.charAt(i))));
                    }
                    btn2.setDisable(false);
                    continue;
                }
                btn2.setText("");
                btn2.setDisable(true);
            }
        } else {
            this.letterButtons.stream().forEach(btn -> {
                btn.setText("");
                btn.setDisable(true);
            });
            this.keyboardPaneSymb.setVisible(false);
            this.keyboardPaneNoSymb.setVisible(false);
            this.keyboardPaneDgtl.setVisible(true);
        }
        this.refreshFunc();
    }

    private void refreshFunc() {
        Layout currLayout = null;
        for (Layout l2 : this.layouts.values()) {
            if (!l2.getCode().equals(this.currentSetName)) continue;
            currLayout = l2;
            break;
        }
        String setName = this.getSetByCode(this.currentSetName);
        String setNameSymb = this.getSetByCode(this.currentSetName);
        Optional.ofNullable(currLayout).ifPresent(l -> {
            String tpl = l.getProperties().getProperty((setNameSymb == null ? setName : setNameSymb) + ".key.lang.text", "");
            KeyboardMessageTemplate kmt = new KeyboardMessageTemplate(tpl);
            ScreenProcessor.process((String)"skin", (MessageTemplate)kmt);
            if (kmt.getValue() != null && !kmt.getValue().isEmpty()) {
                if (this.setLang != null) {
                    this.setLang.setText(kmt.getValue());
                }
                if (this.symbSetLang != null) {
                    this.symbSetLang.setText(kmt.getValue());
                }
            }
            tpl = l.getProperties().getProperty(setName + ".key.space.text", "");
            kmt = new KeyboardMessageTemplate(tpl);
            ScreenProcessor.process((String)"skin", (MessageTemplate)kmt);
            if (kmt.getValue() != null && !kmt.getValue().isEmpty()) {
                if (this.spaceButton != null) {
                    this.spaceButton.setText(kmt.getValue());
                }
                if (this.symbSpaceButton != null) {
                    this.symbSpaceButton.setText(kmt.getValue());
                }
            }
            tpl = l.getProperties().getProperty(setName + ".key.symb.text", "");
            kmt = new KeyboardMessageTemplate(tpl);
            ScreenProcessor.process((String)"skin", (MessageTemplate)kmt);
            if (kmt.getValue() != null && !kmt.getValue().isEmpty()) {
                if (this.setSymb != null) {
                    this.setSymb.setText(kmt.getValue());
                }
                if (this.symbSetSymb != null) {
                    this.symbSetSymb.setText(kmt.getValue());
                }
            }
        });
    }

    private void setAccessible() {
        Optional.ofNullable(this.capsButton).ifPresent(b -> b.setDisable(this.keyboard.getType() == KeyboardType.Digital || !this.keyboard.isAllowChangeCase()));
        Optional.ofNullable(this.spaceButton).ifPresent(b -> b.setDisable(this.keyboard.getType() == KeyboardType.Digital));
        this.letterButtons.stream().forEach(b -> b.setDisable(this.keyboard.getType() == KeyboardType.Digital));
        Optional.ofNullable(this.symbCapsButton).ifPresent(b -> b.setDisable(this.keyboard.getType() == KeyboardType.Digital || !this.keyboard.isAllowChangeCase()));
        Optional.ofNullable(this.symbSpaceButton).ifPresent(b -> b.setDisable(this.keyboard.getType() == KeyboardType.Digital));
        this.symbLetterButtons.stream().forEach(b -> b.setDisable(this.keyboard.getType() == KeyboardType.Digital));
        this.availableLangs.clear();
        if (this.keyboardLayoutNames != null && this.keyboardLayoutNames.size() > 1) {
            Optional.ofNullable(this.set1Button).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains(this.layouts.get("set1").getCode())));
            Optional.ofNullable(this.set2Button).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains(this.layouts.get("set2").getCode())));
            Optional.ofNullable(this.set3Button).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains(this.layouts.get("set3").getCode())));
            Optional.ofNullable(this.set4Button).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains(this.layouts.get("set4").getCode())));
            Optional.ofNullable(this.setSymb).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains("symb")));
            Optional.ofNullable(this.symbSet1Button).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains(this.layouts.get("set1").getCode())));
            Optional.ofNullable(this.symbSet2Button).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains(this.layouts.get("set2").getCode())));
            Optional.ofNullable(this.symbSet3Button).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains(this.layouts.get("set3").getCode())));
            Optional.ofNullable(this.symbSet4Button).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains(this.layouts.get("set4").getCode())));
            Optional.ofNullable(this.symbSetSymb).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains("symb")));
            Optional.ofNullable(this.setLang).ifPresent(b -> {
                this.keyboardLayoutNames.stream().filter(name -> !"symb".equals(name)).forEach(name -> this.availableLangs.add(this.langs.get(name)));
                b.setDisable(this.availableLangs.isEmpty());
            });
            Optional.ofNullable(this.symbSetLang).ifPresent(b -> {
                this.keyboardLayoutNames.stream().filter(name -> !"symb".equals(name)).forEach(name -> this.availableLangs.add(this.langs.get(name)));
                b.setDisable(this.availableLangs.isEmpty());
            });
        } else {
            Optional.ofNullable(this.set1Button).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.set2Button).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.set3Button).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.set4Button).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.setSymb).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.setLang).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.symbSet1Button).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.symbSet2Button).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.symbSet3Button).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.symbSet4Button).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.symbSetSymb).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.symbSetLang).ifPresent(b -> b.setDisable(true));
        }
    }

    private String getSetByCode(String code) {
        if (code == null) {
            return null;
        }
        String result = null;
        for (Map.Entry<String, Layout> e : this.layouts.entrySet()) {
            if (!code.equals(e.getValue().getCode()) || this.langs.get(code) == null && !"symb".equals(code)) continue;
            result = e.getKey();
            break;
        }
        return result;
    }

    private class SetLangActionListener
    implements EventHandler<ActionEvent> {
        private SetLangActionListener() {
        }

        public void handle(ActionEvent event) {
            if (ShowcaseLetterKeyboard.this.symbPressed) {
                ShowcaseLetterKeyboard.this.currentSetName = ((Layout)ShowcaseLetterKeyboard.this.availableLangs.get(ShowcaseLetterKeyboard.this.n)).getCode();
                ShowcaseLetterKeyboard.this.symbPressed = false;
                ShowcaseLetterKeyboard.this.refreshSet();
            } else {
                ShowcaseLetterKeyboard.this.n = (ShowcaseLetterKeyboard.this.n + 1) % ShowcaseLetterKeyboard.this.availableLangs.size();
                ShowcaseLetterKeyboard.this.currentSetName = ((Layout)ShowcaseLetterKeyboard.this.availableLangs.get(ShowcaseLetterKeyboard.this.n)).getCode();
                ShowcaseLetterKeyboard.this.setLang.getStyleClass().remove((Object)ShowcaseLetterKeyboard.this.lastStyle);
                ShowcaseLetterKeyboard.this.setLang.getStyleClass().add((Object)("lang-" + ShowcaseLetterKeyboard.this.currentSetName));
                ShowcaseLetterKeyboard.this.symbSetLang.getStyleClass().remove((Object)ShowcaseLetterKeyboard.this.lastStyle);
                ShowcaseLetterKeyboard.this.symbSetLang.getStyleClass().add((Object)("lang-" + ShowcaseLetterKeyboard.this.currentSetName));
                ShowcaseLetterKeyboard.this.lastStyle = "lang-" + ShowcaseLetterKeyboard.this.currentSetName;
                ShowcaseLetterKeyboard.this.refreshSet();
            }
        }
    }

    private class SetSymbActionListener
    implements EventHandler<ActionEvent> {
        private SetSymbActionListener() {
        }

        public void handle(ActionEvent event) {
            if (ShowcaseLetterKeyboard.this.lastName == null && "symb".equals(ShowcaseLetterKeyboard.this.currentSetName)) {
                if (ShowcaseLetterKeyboard.this.availableLangs.size() > ShowcaseLetterKeyboard.this.n) {
                    ShowcaseLetterKeyboard.this.lastName = ((Layout)ShowcaseLetterKeyboard.this.availableLangs.get(ShowcaseLetterKeyboard.this.n)).getCode();
                } else {
                    return;
                }
            }
            if (ShowcaseLetterKeyboard.this.symbPressed) {
                ShowcaseLetterKeyboard.this.currentSetName = ShowcaseLetterKeyboard.this.lastName;
                ShowcaseLetterKeyboard.this.symbPressed = false;
                ShowcaseLetterKeyboard.this.refreshSet();
            } else {
                ShowcaseLetterKeyboard.this.lastName = ShowcaseLetterKeyboard.this.currentSetName;
                ShowcaseLetterKeyboard.this.currentSetName = "symb";
                ShowcaseLetterKeyboard.this.symbPressed = true;
                ShowcaseLetterKeyboard.this.refreshSet();
            }
        }
    }

    private class LocalActionListener
    implements EventHandler<ActionEvent> {
        private LocalActionListener() {
        }

        public void handle(ActionEvent e) {
            if (ShowcaseLetterKeyboard.this.listener != null) {
                if (e.getSource() == ShowcaseLetterKeyboard.this.spaceButton || e.getSource() == ShowcaseLetterKeyboard.this.symbSpaceButton) {
                    ShowcaseLetterKeyboard.this.listener.onKeyPress(' ');
                } else if (e.getSource() == ShowcaseLetterKeyboard.this.clearButton || e.getSource() == ShowcaseLetterKeyboard.this.symbClearButton) {
                    if (ShowcaseLetterKeyboard.this.keyboard != null && ShowcaseLetterKeyboard.this.keyboard.getExtraCharacter() != null) {
                        ShowcaseLetterKeyboard.this.listener.onKeyPress(ShowcaseLetterKeyboard.this.keyboard.getExtraCharacter().charValue());
                    } else {
                        ShowcaseLetterKeyboard.this.listener.onClear();
                    }
                } else if (e.getSource() == ShowcaseLetterKeyboard.this.clearLastButton || e.getSource() == ShowcaseLetterKeyboard.this.symbClearLastButton || e.getSource() == ShowcaseLetterKeyboard.this.dgtlClearLastButton) {
                    ShowcaseLetterKeyboard.this.listener.onClearLast();
                } else if (e.getSource() == ShowcaseLetterKeyboard.this.enterButton || e.getSource() == ShowcaseLetterKeyboard.this.symbEnterButton || e.getSource() == ShowcaseLetterKeyboard.this.dgtlEnterButton) {
                    ShowcaseLetterKeyboard.this.listener.onEnter();
                } else {
                    Button b = (Button)e.getSource();
                    if (b.getText() != null && !b.getText().isEmpty()) {
                        char ch = b.getText().charAt(0);
                        ShowcaseLetterKeyboard.this.listener.onKeyPress(ch);
                    }
                }
            }
        }
    }

    private class SetActionListener
    implements EventHandler<ActionEvent> {
        private String setName;
        private boolean goLastSet = true;

        public SetActionListener(String setName, boolean goLastSet) {
            this.setName = setName;
            this.goLastSet = goLastSet;
        }

        public void handle(ActionEvent e) {
            if (this.goLastSet && ShowcaseLetterKeyboard.this.currentSetName.equals(((Layout)ShowcaseLetterKeyboard.this.layouts.get(this.setName)).getCode()) && ShowcaseLetterKeyboard.this.lastSetName != null) {
                ShowcaseLetterKeyboard.this.currentSetName = ShowcaseLetterKeyboard.this.lastSetName;
                ShowcaseLetterKeyboard.this.lastSetName = null;
                ShowcaseLetterKeyboard.this.refreshSet();
            } else if (!ShowcaseLetterKeyboard.this.currentSetName.equals(((Layout)ShowcaseLetterKeyboard.this.layouts.get(this.setName)).getCode())) {
                ShowcaseLetterKeyboard.this.lastSetName = ShowcaseLetterKeyboard.this.currentSetName;
                ShowcaseLetterKeyboard.this.currentSetName = ((Layout)ShowcaseLetterKeyboard.this.layouts.get(this.setName)).getCode();
                ShowcaseLetterKeyboard.this.refreshSet();
            }
        }
    }

    private class CapsActionListener
    implements EventHandler<ActionEvent> {
        private CapsActionListener() {
        }

        public void handle(ActionEvent e) {
            if (ShowcaseLetterKeyboard.this.currentCase == KeyboardCase.Lower) {
                ShowcaseLetterKeyboard.this.currentCase = KeyboardCase.Upper;
            } else {
                ShowcaseLetterKeyboard.this.currentCase = KeyboardCase.Lower;
            }
            ShowcaseLetterKeyboard.this.refreshSet();
        }
    }
}

