/*
 * Decompiled with CFR 0.152.
 */
package plfx.showcase.keyboard.letter;

import java.net.URL;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.Pane;
import plfx.input.keyboard.KeyboardListener;
import plfx.input.keyboard.letter.Layout;
import plfx.input.keyboard.letter.LayoutFilter;
import plfx.input.keyboard.letter.LetterKeyboard;
import plfx.showcase.screen.input.group.SelectableKeyboardListener;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardCase;
import ru.softlogic.input.model.field.text.KeyboardType;

public class ShowcaseChcopyLetterKeyboard
implements LetterKeyboard {
    private static final String CLEAR_LAST_ID = "clearLastButton";
    @FXML
    private Pane keyboardPane;
    @FXML
    private Button set1Button;
    @FXML
    private Button set2Button;
    @FXML
    private Button set3Button;
    @FXML
    private Button set4Button;
    @FXML
    private Button setSymb;
    @FXML
    private Button setLang;
    @FXML
    private Button capsButton;
    @FXML
    private Button clearButton;
    @FXML
    private Button enterButton;
    @FXML
    private Button spaceButton;
    private List<Button> digitButtons;
    private List<Button> letterButtons;
    private List<Button> clearLastButtons;
    private Map<String, Layout> layouts;
    private List<String> keyboardLayoutNames;
    private Keyboard keyboard;
    private String currentSetName;
    private String lastSetName;
    private KeyboardCase currentCase;
    private KeyboardListener listener;
    private SelectableKeyboardListener selectablelistener;
    private Map<String, Layout> langs;
    private List<Layout> availableLangs;
    private boolean symbPressed;
    private String lastStyle;
    private int n;

    public void initialize(URL location, ResourceBundle resources) {
        Node p;
        int i;
        this.digitButtons = new LinkedList<Button>();
        for (i = 0; i < 10 && (p = this.keyboardPane.lookup("#d" + i)) != null && p instanceof Button; ++i) {
            this.digitButtons.add((Button)p);
        }
        this.letterButtons = new LinkedList<Button>();
        for (i = 0; i < 50 && (p = this.keyboardPane.lookup("#let" + i)) != null && p instanceof Button; ++i) {
            this.letterButtons.add((Button)p);
        }
        this.clearLastButtons = new LinkedList<Button>();
        for (i = 0; i < 6 && (p = this.keyboardPane.lookup("#clearLastButton" + i)) != null && p instanceof Button; ++i) {
            this.clearLastButtons.add((Button)p);
        }
        Optional.ofNullable(this.capsButton).ifPresent(b -> b.setOnAction((EventHandler)new CapsActionListener()));
        Optional.ofNullable(this.setSymb).ifPresent(b -> b.setOnAction((EventHandler)new SetSymbActionListener()));
        Optional.ofNullable(this.set1Button).ifPresent(b -> b.setOnAction((EventHandler)new SetActionListener("set1", "true".equals(b.getProperties().get((Object)"golast")))));
        Optional.ofNullable(this.set2Button).ifPresent(b -> b.setOnAction((EventHandler)new SetActionListener("set2", "true".equals(b.getProperties().get((Object)"golast")))));
        Optional.ofNullable(this.set3Button).ifPresent(b -> b.setOnAction((EventHandler)new SetActionListener("set3", "true".equals(b.getProperties().get((Object)"golast")))));
        Optional.ofNullable(this.set4Button).ifPresent(b -> b.setOnAction((EventHandler)new SetActionListener("set4", "true".equals(b.getProperties().get((Object)"golast")))));
        Optional.ofNullable(this.setLang).ifPresent(b -> {
            b.setOnAction((EventHandler)new SetLangActionListener());
            b.setDisable(true);
        });
        LocalActionListener lal = new LocalActionListener();
        Optional.ofNullable(this.spaceButton).ifPresent(b -> b.setOnAction((EventHandler)lal));
        Optional.ofNullable(this.clearButton).ifPresent(b -> b.setOnAction((EventHandler)lal));
        this.digitButtons.forEach(b -> b.setOnAction((EventHandler)lal));
        this.letterButtons.forEach(b -> b.setOnAction((EventHandler)lal));
        this.clearLastButtons.forEach(b -> b.setOnAction((EventHandler)lal));
    }

    public void setLayouts(Map<String, Layout> layouts) {
        if (layouts == null) {
            throw new NullPointerException("List<Layout>");
        }
        if (layouts.size() < 1) {
            throw new NullPointerException("Layouts size is wrong: " + layouts.size());
        }
        this.layouts = layouts;
        this.availableLangs = new LinkedList<Layout>();
        this.langs = new LinkedHashMap<String, Layout>();
        layouts.values().stream().filter(l -> l.getCode().length() == 2).forEach(l -> this.langs.put(l.getCode(), (Layout)l));
    }

    public void init(Keyboard keyboard) {
        this.keyboard = keyboard;
        Set availableLayouts = this.layouts.values().stream().map(l -> l.getCode()).collect(Collectors.toSet());
        String replaceRules = this.layouts.get("set1").getProperties().getProperty("set1.replace.rules");
        this.keyboardLayoutNames = LayoutFilter.getAvailableLayouts((List)keyboard.getLayoutNames(), availableLayouts, (String)replaceRules);
        boolean enable = keyboard.getType() != KeyboardType.Letter;
        this.digitButtons.stream().filter(b -> b != null).forEach(b -> b.setDisable(!enable));
        if (this.clearButton != null) {
            if (keyboard.getExtraCharacter() != null) {
                this.clearButton.setText("" + keyboard.getExtraCharacter());
            } else {
                this.clearButton.setText("X");
            }
        }
        this.setAccessible();
        this.currentSetName = null;
        this.symbPressed = false;
        if (!this.keyboardLayoutNames.isEmpty()) {
            this.currentSetName = this.keyboardLayoutNames.get(0);
            if (this.setLang != null) {
                this.n = 0;
                if (!"symb".equals(this.currentSetName)) {
                    this.symbPressed = false;
                    this.setLang.getStyleClass().remove((Object)this.lastStyle);
                    this.lastStyle = "lang-" + this.currentSetName;
                    this.setLang.getStyleClass().add((Object)this.lastStyle);
                } else {
                    this.symbPressed = true;
                    this.setLang.getStyleClass().remove((Object)this.lastStyle);
                    if (!this.availableLangs.isEmpty()) {
                        this.lastStyle = "lang-" + this.availableLangs.get(0).getCode();
                        this.setLang.getStyleClass().add((Object)this.lastStyle);
                    } else {
                        this.lastStyle = null;
                    }
                }
            }
        }
        this.currentCase = keyboard.getDefaultCase();
        this.refreshSet();
    }

    public void setKeyboardListener(KeyboardListener listener) {
        this.listener = listener;
        this.selectablelistener = listener instanceof SelectableKeyboardListener ? (SelectableKeyboardListener)listener : null;
    }

    private void refreshSet() {
        String currentSet = this.layouts.size() < 2 ? this.layouts.get("set1").getData() : this.layouts.get("set2").getData();
        for (Layout l : this.layouts.values()) {
            if (!l.getCode().equals(this.currentSetName)) continue;
            currentSet = l.getData();
            break;
        }
        if (currentSet != null && this.keyboard.getType() != KeyboardType.Digital) {
            for (int i = 0; i < this.letterButtons.size(); ++i) {
                Button btn2 = this.letterButtons.get(i);
                if (i < currentSet.length()) {
                    if (this.currentCase == KeyboardCase.Lower) {
                        btn2.setText(Character.toString(Character.toLowerCase(currentSet.charAt(i))));
                    } else {
                        btn2.setText(Character.toString(Character.toUpperCase(currentSet.charAt(i))));
                    }
                    btn2.setDisable(false);
                    continue;
                }
                btn2.setText("");
                btn2.setDisable(true);
            }
        } else {
            this.letterButtons.stream().forEach(btn -> {
                btn.setText("");
                btn.setDisable(true);
            });
        }
    }

    private void setAccessible() {
        Optional.ofNullable(this.capsButton).ifPresent(b -> b.setDisable(this.keyboard.getType() == KeyboardType.Digital || !this.keyboard.isAllowChangeCase()));
        Optional.ofNullable(this.spaceButton).ifPresent(b -> b.setDisable(this.keyboard.getType() == KeyboardType.Digital));
        this.letterButtons.stream().forEach(b -> b.setDisable(this.keyboard.getType() == KeyboardType.Digital));
        this.availableLangs.clear();
        if (this.keyboardLayoutNames != null && this.keyboardLayoutNames.size() > 1) {
            Optional.ofNullable(this.set1Button).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains(this.layouts.get("set1").getCode())));
            Optional.ofNullable(this.set2Button).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains(this.layouts.get("set2").getCode())));
            Optional.ofNullable(this.set3Button).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains(this.layouts.get("set3").getCode())));
            Optional.ofNullable(this.set4Button).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains(this.layouts.get("set4").getCode())));
            Optional.ofNullable(this.setSymb).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains("symb")));
            Optional.ofNullable(this.setLang).ifPresent(b -> {
                this.keyboardLayoutNames.stream().filter(name -> !"symb".equals(name)).forEach(name -> this.availableLangs.add(this.langs.get(name)));
                b.setDisable(this.availableLangs.isEmpty());
            });
        } else {
            Optional.ofNullable(this.set1Button).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.set2Button).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.set3Button).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.set4Button).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.setSymb).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.setLang).ifPresent(b -> b.setDisable(true));
        }
    }

    private class SetLangActionListener
    implements EventHandler<ActionEvent> {
        private SetLangActionListener() {
        }

        public void handle(ActionEvent event) {
            if (ShowcaseChcopyLetterKeyboard.this.symbPressed) {
                ShowcaseChcopyLetterKeyboard.this.currentSetName = ((Layout)ShowcaseChcopyLetterKeyboard.this.availableLangs.get(ShowcaseChcopyLetterKeyboard.this.n)).getCode();
                ShowcaseChcopyLetterKeyboard.this.symbPressed = false;
                ShowcaseChcopyLetterKeyboard.this.refreshSet();
            } else {
                ShowcaseChcopyLetterKeyboard.this.n = (ShowcaseChcopyLetterKeyboard.this.n + 1) % ShowcaseChcopyLetterKeyboard.this.availableLangs.size();
                ShowcaseChcopyLetterKeyboard.this.currentSetName = ((Layout)ShowcaseChcopyLetterKeyboard.this.availableLangs.get(ShowcaseChcopyLetterKeyboard.this.n)).getCode();
                ShowcaseChcopyLetterKeyboard.this.setLang.getStyleClass().remove((Object)ShowcaseChcopyLetterKeyboard.this.lastStyle);
                ShowcaseChcopyLetterKeyboard.this.setLang.getStyleClass().add((Object)("lang-" + ShowcaseChcopyLetterKeyboard.this.currentSetName));
                ShowcaseChcopyLetterKeyboard.this.lastStyle = "lang-" + ShowcaseChcopyLetterKeyboard.this.currentSetName;
                ShowcaseChcopyLetterKeyboard.this.refreshSet();
            }
        }
    }

    private class SetSymbActionListener
    implements EventHandler<ActionEvent> {
        private String lastName;

        private SetSymbActionListener() {
        }

        public void handle(ActionEvent event) {
            if (this.lastName == null && "symb".equals(ShowcaseChcopyLetterKeyboard.this.currentSetName)) {
                if (!ShowcaseChcopyLetterKeyboard.this.availableLangs.isEmpty()) {
                    this.lastName = ((Layout)ShowcaseChcopyLetterKeyboard.this.availableLangs.get(0)).getCode();
                } else {
                    return;
                }
            }
            if (ShowcaseChcopyLetterKeyboard.this.symbPressed) {
                ShowcaseChcopyLetterKeyboard.this.currentSetName = this.lastName;
                ShowcaseChcopyLetterKeyboard.this.symbPressed = false;
                this.lastName = null;
                ShowcaseChcopyLetterKeyboard.this.refreshSet();
            } else {
                this.lastName = ShowcaseChcopyLetterKeyboard.this.currentSetName;
                ShowcaseChcopyLetterKeyboard.this.currentSetName = "symb";
                ShowcaseChcopyLetterKeyboard.this.symbPressed = true;
                ShowcaseChcopyLetterKeyboard.this.refreshSet();
            }
        }
    }

    private class LocalActionListener
    implements EventHandler<ActionEvent> {
        private LocalActionListener() {
        }

        public void handle(ActionEvent e) {
            if (ShowcaseChcopyLetterKeyboard.this.listener != null) {
                if (e.getSource() == ShowcaseChcopyLetterKeyboard.this.spaceButton) {
                    ShowcaseChcopyLetterKeyboard.this.listener.onKeyPress(' ');
                } else if (e.getSource() == ShowcaseChcopyLetterKeyboard.this.clearButton) {
                    if (ShowcaseChcopyLetterKeyboard.this.keyboard != null && ShowcaseChcopyLetterKeyboard.this.keyboard.getExtraCharacter() != null) {
                        ShowcaseChcopyLetterKeyboard.this.listener.onKeyPress(ShowcaseChcopyLetterKeyboard.this.keyboard.getExtraCharacter().charValue());
                    } else {
                        ShowcaseChcopyLetterKeyboard.this.listener.onClear();
                    }
                } else if (ShowcaseChcopyLetterKeyboard.this.clearLastButtons.contains(e.getSource())) {
                    if (ShowcaseChcopyLetterKeyboard.this.selectablelistener != null) {
                        ShowcaseChcopyLetterKeyboard.this.selectablelistener.selectComponnent(ShowcaseChcopyLetterKeyboard.this.clearLastButtons.indexOf(e.getSource()));
                    }
                    ShowcaseChcopyLetterKeyboard.this.listener.onClearLast();
                } else if (e.getSource() == ShowcaseChcopyLetterKeyboard.this.enterButton) {
                    ShowcaseChcopyLetterKeyboard.this.listener.onEnter();
                } else {
                    Button b = (Button)e.getSource();
                    if (b.getText() != null && !b.getText().isEmpty()) {
                        char ch = b.getText().charAt(0);
                        ShowcaseChcopyLetterKeyboard.this.listener.onKeyPress(ch);
                    }
                }
            }
        }
    }

    private class SetActionListener
    implements EventHandler<ActionEvent> {
        private String setName;
        private boolean goLastSet = true;

        public SetActionListener(String setName, boolean goLastSet) {
            this.setName = setName;
            this.goLastSet = goLastSet;
        }

        public void handle(ActionEvent e) {
            if (this.goLastSet && ShowcaseChcopyLetterKeyboard.this.currentSetName.equals(((Layout)ShowcaseChcopyLetterKeyboard.this.layouts.get(this.setName)).getCode()) && ShowcaseChcopyLetterKeyboard.this.lastSetName != null) {
                ShowcaseChcopyLetterKeyboard.this.currentSetName = ShowcaseChcopyLetterKeyboard.this.lastSetName;
                ShowcaseChcopyLetterKeyboard.this.lastSetName = null;
                ShowcaseChcopyLetterKeyboard.this.refreshSet();
            } else if (!ShowcaseChcopyLetterKeyboard.this.currentSetName.equals(((Layout)ShowcaseChcopyLetterKeyboard.this.layouts.get(this.setName)).getCode())) {
                ShowcaseChcopyLetterKeyboard.this.lastSetName = ShowcaseChcopyLetterKeyboard.this.currentSetName;
                ShowcaseChcopyLetterKeyboard.this.currentSetName = ((Layout)ShowcaseChcopyLetterKeyboard.this.layouts.get(this.setName)).getCode();
                ShowcaseChcopyLetterKeyboard.this.refreshSet();
            }
        }
    }

    private class CapsActionListener
    implements EventHandler<ActionEvent> {
        private CapsActionListener() {
        }

        public void handle(ActionEvent e) {
            if (ShowcaseChcopyLetterKeyboard.this.currentCase == KeyboardCase.Lower) {
                ShowcaseChcopyLetterKeyboard.this.currentCase = KeyboardCase.Upper;
            } else {
                ShowcaseChcopyLetterKeyboard.this.currentCase = KeyboardCase.Lower;
            }
            ShowcaseChcopyLetterKeyboard.this.refreshSet();
        }
    }
}

