/*
 * Decompiled with CFR 0.152.
 */
package plfx.showcase.input.keyboard.digital;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import plfx.element.SButton;
import plfx.input.keyboard.KeyboardListener;
import plfx.input.keyboard.digital.DigitalKeyboard;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardType;

public class ShowcaseDigitalKeyboard
implements DigitalKeyboard {
    private static final int ZERO_COLUMN = 0;
    private static final int ZERO_ROW = 6;
    private static final int ZERO_COLUMN_SPAN_STD = 5;
    private static final int ZERO_COLUMN_SPAN_EXTRA = 3;
    private Keyboard keyboard;
    private Optional<KeyboardListener> listener;
    private Optional<SButton> extraButtonX;
    private Optional<SButton> extraButtonC;
    @FXML
    private Pane keyboardPane;
    @FXML
    private GridPane digits;
    @FXML
    private Button clearButton;
    @FXML
    private Button extraCharacter;
    @FXML
    private Button clearLastButton;
    private List<Button> digitButtons;
    private Button zeroButton;

    public void initialize(URL location, ResourceBundle resources) {
        Node p;
        this.listener = Optional.empty();
        this.extraButtonX = Optional.empty();
        this.extraButtonC = Optional.empty();
        this.digitButtons = new LinkedList<Button>();
        for (int i = 0; i < 10 && (p = this.keyboardPane.lookup("#d" + i)) != null && p instanceof Button; ++i) {
            if (((Button)p).getText().charAt(0) == '0') {
                this.zeroButton = (Button)p;
            }
            this.digitButtons.add((Button)p);
        }
        this.digitButtons.stream().forEach(b -> b.setOnAction(e -> this.listener.ifPresent(l -> {
            Button digit = (Button)e.getSource();
            l.onKeyPress(digit.getText().charAt(0));
        })));
        Optional.ofNullable(this.clearLastButton).ifPresent(button -> button.setOnAction(event -> this.listener.ifPresent(l -> l.onClearLast())));
        this.extraButtonC.ifPresent(button -> button.setListener(() -> this.listener.ifPresent(l -> l.onClearLast())));
        Optional.ofNullable(this.clearButton).ifPresent(button -> button.setOnAction(event -> this.listener.ifPresent(l -> {
            if (this.keyboard != null && this.keyboard.getExtraCharacter() != null) {
                l.onKeyPress(this.keyboard.getExtraCharacter().charValue());
            } else {
                l.onClear();
            }
        })));
        Optional.ofNullable(this.extraCharacter).ifPresent(button -> button.setOnAction(event -> this.listener.ifPresent(l -> {
            if (this.keyboard != null && this.keyboard.getExtraCharacter() != null) {
                l.onKeyPress(this.keyboard.getExtraCharacter().charValue());
            }
        })));
        this.extraButtonX.ifPresent(button -> button.setListener(() -> this.listener.ifPresent(l -> {
            if (this.keyboard != null && this.keyboard.getExtraCharacter() != null) {
                l.onKeyPress(this.keyboard.getExtraCharacter().charValue());
            } else {
                l.onClear();
            }
        })));
    }

    public void init(Keyboard keyboard) {
        this.keyboard = keyboard;
        boolean enable = keyboard.getType() != KeyboardType.Letter;
        this.digitButtons.forEach(b -> b.setDisable(!enable));
        Optional.ofNullable(this.clearButton).ifPresent(b -> {
            if (keyboard.getExtraCharacter() != null) {
                b.setText("" + keyboard.getExtraCharacter());
            } else if (b.getText() == null || b.getText().isEmpty() || !"C".equalsIgnoreCase(b.getText())) {
                b.setText("X");
            }
        });
        if (this.extraCharacter != null) {
            if (keyboard.getExtraCharacter() != null) {
                this.digits.getChildren().remove((Object)this.zeroButton);
                this.digits.add((Node)this.zeroButton, 0, 6, 3, 1);
                this.extraCharacter.setText("" + keyboard.getExtraCharacter());
                this.extraCharacter.setDisable(false);
                this.extraCharacter.setVisible(true);
            } else {
                this.digits.getChildren().remove((Object)this.zeroButton);
                this.digits.add((Node)this.zeroButton, 0, 6, 5, 1);
                this.extraCharacter.setText(null);
                this.extraCharacter.setDisable(true);
                this.extraCharacter.setVisible(false);
            }
        }
    }

    public void setExtraButtonX(SButton extraButtonX) {
        this.extraButtonX = Optional.ofNullable(extraButtonX);
    }

    public void setExtraButtonC(SButton extraButtonC) {
        this.extraButtonC = Optional.ofNullable(extraButtonC);
    }

    public void setKeyboardListener(KeyboardListener listener) {
        this.listener = Optional.ofNullable(listener);
    }
}

