/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.utils;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import ru.softlogic.config.add.Proxy;
import ru.softlogic.config.add.ServerProfile;
import ru.softlogic.srv.connector.ConnConfiguration;
import ru.softlogic.srv.connector.ProxyConfiguration;

public class NetworkUtils {
    private NetworkUtils() {
    }

    public static ProxyConfiguration convertProxy(Proxy p) {
        ProxyConfiguration proxy = new ProxyConfiguration();
        if (p != null) {
            proxy.setUseProxy(p.isUse());
            proxy.setProxyHost(p.getHost());
            proxy.setProxyPort(String.valueOf(p.getPort()));
            proxy.setAuthProxy(p.isAuth());
            proxy.setProxyUser(p.getUsername());
            proxy.setProxyPassword(p.getPassword());
        }
        return proxy;
    }

    public static ConnConfiguration getConnConfiguration(ServerProfile sp, File keyDir) throws IOException {
        String keyName = NetworkUtils.buildTerminalKeyName(sp.getHost(), sp.getHttpsPort(), sp.getPointId());
        String privateKey = NetworkUtils.getPrivateKey(keyDir, keyName);
        String publicKey = NetworkUtils.getPublicKey(keyDir, keyName);
        return new ConnConfiguration(sp.getHost(), sp.getHttpPort(), sp.getHttpsPort(), privateKey, publicKey, sp.getTimeout());
    }

    public static String buildTerminalKeyName(String host, int port, int point) {
        return "ws_" + host + "_" + port + "_" + point;
    }

    public static String getPrivateKey(File keyPath, String name) throws IOException {
        return FileUtils.readFileToString((File)new File(keyPath, name + "_private.key"));
    }

    public static String getPublicKey(File keyPath, String name) throws IOException {
        return FileUtils.readFileToString((File)new File(keyPath, name + "_public.key"));
    }
}

