/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.queue.utils;

import java.io.Serializable;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignedObject;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import org.apache.log4j.Logger;

public class QueueUtils {
    private static final String ALG = "DSA";

    public static SignedObject signQueue(Serializable queue, KeyStore keystore, Logger log) {
        try {
            Signature signature = Signature.getInstance(ALG);
            KeyPair keyPair = QueueUtils.getKeyPair(keystore, "softlogic", "softlogic_keys");
            PrivateKey privateKey = keyPair.getPrivate();
            return new SignedObject(queue, privateKey, signature);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean verifyQueue(SignedObject queue, KeyStore keystore, Logger log) {
        try {
            Signature sig = Signature.getInstance(ALG);
            KeyPair keyPair = QueueUtils.getKeyPair(keystore, "softlogic", "softlogic_keys");
            PublicKey publicKey = keyPair.getPublic();
            return queue.verify(publicKey, sig);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static KeyPair getKeyPair(KeyStore keystore, String alias, String password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        PrivateKey key = (PrivateKey)keystore.getKey(alias, password.toCharArray());
        Certificate cert = keystore.getCertificate(alias);
        PublicKey publicKey = cert.getPublicKey();
        return new KeyPair(publicKey, key);
    }
}

