/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.queue;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import ru.softlogic.reference.adv.AdvStatistic;
import ru.softlogic.srv.api.card.SaleConfirm;
import ru.softlogic.srv.api.cbc.CbcStatus;
import ru.softlogic.srv.api.command.CommandResult;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.modem.ModemState;
import ru.softlogic.srv.api.network.NetworkStatistics;
import ru.softlogic.srv.api.oth.Demand;
import ru.softlogic.srv.api.oth.JammInfo;
import ru.softlogic.srv.cash.Statistics;
import ru.softlogic.srv.connector.ws.stub.CashTransfer;

public class QueueData1
implements Serializable {
    static final long serialVersionUID = -4094143859376574009L;
    private List<Event> events;
    private List<Statistics> statistics;
    private List<SaleConfirm> saleConfirms;
    private List<CommandResult> commandResults;
    private List<ModemState> modemStates;
    private List<String> servicesDemande;
    private List<JammInfo> jammInfos;
    private List<NetworkStatistics> networkStatistics;
    private List<CbcStatus> cbcStates;
    private List<Demand> demands;
    private List<AdvStatistic> advStatistics;
    private List<CashTransfer> transfers;

    public List<CommandResult> getCommandResults() {
        if (this.commandResults == null) {
            this.commandResults = new LinkedList<CommandResult>();
        }
        return this.commandResults;
    }

    public List<SaleConfirm> getSaleConfirms() {
        if (this.saleConfirms == null) {
            this.saleConfirms = new LinkedList<SaleConfirm>();
        }
        return this.saleConfirms;
    }

    public List<Event> getEvents() {
        if (this.events == null) {
            this.events = new LinkedList<Event>();
        }
        return this.events;
    }

    public List<ModemState> getModemStates() {
        if (this.modemStates == null) {
            this.modemStates = new LinkedList<ModemState>();
        }
        return this.modemStates;
    }

    public List<String> getServicesDemande() {
        if (this.servicesDemande == null) {
            this.servicesDemande = new LinkedList<String>();
        }
        return this.servicesDemande;
    }

    public List<Statistics> getStatistics() {
        if (this.statistics == null) {
            this.statistics = new LinkedList<Statistics>();
        }
        return this.statistics;
    }

    public List<JammInfo> getJammInfos() {
        if (this.jammInfos == null) {
            this.jammInfos = new LinkedList<JammInfo>();
        }
        return this.jammInfos;
    }

    public List<NetworkStatistics> getNetworkStatistics() {
        if (this.networkStatistics == null) {
            this.networkStatistics = new LinkedList<NetworkStatistics>();
        }
        return this.networkStatistics;
    }

    public List<CbcStatus> getCbcStates() {
        if (this.cbcStates == null) {
            this.cbcStates = new LinkedList<CbcStatus>();
        }
        return this.cbcStates;
    }

    public List<Demand> getDemandes() {
        if (this.demands == null) {
            this.demands = new LinkedList<Demand>();
        }
        return this.demands;
    }

    public List<AdvStatistic> getAdvStatistics() {
        if (this.advStatistics == null) {
            this.advStatistics = new LinkedList<AdvStatistic>();
        }
        return this.advStatistics;
    }

    public List<CashTransfer> getTransfers() {
        if (this.transfers == null) {
            this.transfers = new LinkedList<CashTransfer>();
        }
        return this.transfers;
    }

    public int getSize() {
        return this.getEvents().size() + this.getStatistics().size() + this.getSaleConfirms().size() + this.getCommandResults().size() + this.getServicesDemande().size();
    }

    public int getSize(int timeout) {
        int threshold = timeout == 0 ? 120 : Math.min(timeout * 3, 360);
        Date dateThreshold = new Date(System.currentTimeMillis() - (long)threshold * 1000L);
        int count = this.getStatistics().size() + this.getSaleConfirms().size() + this.getCommandResults().size() + this.getServicesDemande().size();
        count = (int)((long)count + this.getEvents().stream().filter(evt -> evt.getDate().before(dateThreshold)).count());
        return count;
    }

    public long getAge() {
        Date min = new Date();
        for (Event e : this.getEvents()) {
            if (e.getDate().compareTo(min) >= 0) continue;
            min = e.getDate();
        }
        for (Statistics st : this.getStatistics()) {
            if (st.getTo().compareTo(min) >= 0) continue;
            min = st.getTo();
        }
        for (SaleConfirm sc : this.getSaleConfirms()) {
            if (sc.getOperation().getDate().compareTo(min) >= 0) continue;
            min = sc.getOperation().getDate();
        }
        return new Date().getTime() - min.getTime();
    }

    public String toString() {
        return "QueueData{events=" + this.events + ",statistics=" + this.statistics + ",saleConfirms=" + this.saleConfirms + ",commandResults=" + this.commandResults + ",modemStates=" + this.modemStates + ",servicesDemande=" + this.servicesDemande + ",jammInfos=" + this.jammInfos + ",networkStatistics=" + this.networkStatistics + ",advStatistics=" + this.advStatistics + '}';
    }
}

