/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.queue;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.SignedObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.adv.AdvStatistic;
import ru.softlogic.srv.api.card.SaleConfirm;
import ru.softlogic.srv.api.cbc.CbcStatus;
import ru.softlogic.srv.api.command.CommandResult;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.iface.NetworkDevice;
import ru.softlogic.srv.api.modem.ModemState;
import ru.softlogic.srv.api.network.NetworkStatistics;
import ru.softlogic.srv.api.oth.Demand;
import ru.softlogic.srv.api.oth.JammInfo;
import ru.softlogic.srv.api.oth.MoneyCollection;
import ru.softlogic.srv.api.oth.SystemInfo;
import ru.softlogic.srv.api.security.EnvRiskFactors;
import ru.softlogic.srv.api.status.DeviceStatus;
import ru.softlogic.srv.api.status.UpdateState;
import ru.softlogic.srv.cash.Statistics;
import ru.softlogic.srv.connector.FinancialObserver;
import ru.softlogic.srv.connector.ws.stub.BoxAmount;
import ru.softlogic.srv.connector.ws.stub.BoxInfo;
import ru.softlogic.srv.connector.ws.stub.BoxStatus;
import ru.softlogic.srv.connector.ws.stub.CashTransfer;
import ru.softlogic.srv.connector.ws.stub.DeviceInfoStub;
import ru.softlogic.srv.queue.DiskErrorListener;
import ru.softlogic.srv.queue.QueueData1;
import ru.softlogic.srv.queue.QueueData2;
import ru.softlogic.srv.queue.QueueStatus;
import ru.softlogic.srv.queue.utils.ObjectReadWriteStream;
import ru.softlogic.srv.queue.utils.QueueUtils;

public class Queue {
    private final Set<FinancialObserver> financialObservers;
    private final DiskErrorListener listener;
    private final KeyStore keyStore;
    private Integer diskSpace;
    private final List<DeviceStatus> deviceStatuses;
    private final List<DeviceInfoStub> deviceInfos;
    private final List<BoxAmount> boxAmounts;
    private final List<UpdateState> updateStates;
    private final List<BoxInfo> boxInfos;
    private final List<BoxStatus> boxStatuses;
    private SystemInfo systemInfo;
    private EnvRiskFactors evnRiskFactors;
    private NetworkDevice[] networkDevices;
    private QueueData1 queueData1;
    private QueueData2 queueData2;
    private Logger log;
    private boolean diskError;
    private ObjectReadWriteStream mainFile1;
    private ObjectReadWriteStream tmpFile1;
    private ObjectReadWriteStream mainFile2;
    private ObjectReadWriteStream tmpFile2;

    public Queue(String fileName, KeyStore key, DiskErrorListener listener) {
        this.listener = listener;
        this.keyStore = key;
        this.log = Logger.getLogger((String)"net");
        this.log.setAdditivity(false);
        this.printFileSize(fileName + "-d.pst");
        this.printFileSize(fileName + "-d.tmp");
        this.printFileSize(fileName + "-f.pst");
        this.printFileSize(fileName + "-f.tmp");
        try {
            this.mainFile1 = new ObjectReadWriteStream(fileName + "-d.pst");
            this.tmpFile1 = new ObjectReadWriteStream(fileName + "-d.tmp");
            this.mainFile2 = new ObjectReadWriteStream(fileName + "-f.pst");
            this.tmpFile2 = new ObjectReadWriteStream(fileName + "-f.tmp");
            this.diskError = false;
        }
        catch (Exception ex) {
            this.log.error((Object)"Error on read data", (Throwable)ex);
            this.diskError = true;
        }
        this.deviceStatuses = new LinkedList<DeviceStatus>();
        this.deviceInfos = new LinkedList<DeviceInfoStub>();
        this.updateStates = new LinkedList<UpdateState>();
        this.boxInfos = new LinkedList<BoxInfo>();
        this.boxAmounts = new LinkedList<BoxAmount>();
        this.boxStatuses = new LinkedList<BoxStatus>();
        this.financialObservers = new HashSet<FinancialObserver>();
        this.readData();
    }

    public boolean addFinancialObserver(FinancialObserver observer) {
        if (observer == null) {
            return false;
        }
        observer.update(this.queueData2.getSize());
        return this.financialObservers.add(observer);
    }

    public boolean removeFinancialObserver(FinancialObserver observer) {
        if (observer == null) {
            return false;
        }
        return this.financialObservers.remove(observer);
    }

    protected void notifyFinQueueSize() {
        for (FinancialObserver observer : this.financialObservers) {
            observer.update(this.queueData2.getSize());
        }
    }

    public synchronized QueueStatus getStatus() {
        long age = Math.max(this.queueData1.getAge(), this.queueData2.getAge());
        return new QueueStatus(age / 60000L, this.queueData1.getSize() + this.queueData2.getSize(), this.queueData2.getSize(), this.diskError);
    }

    public synchronized QueueStatus getStatus(int scanTimeout) {
        long age = Math.max(this.queueData1.getAge(), this.queueData2.getAge());
        return new QueueStatus(age / 60000L, this.queueData1.getSize(scanTimeout) + this.queueData2.getSize(), this.queueData2.getSize(), this.diskError);
    }

    public synchronized boolean putOperation(Operation operation) {
        if (operation != null) {
            this.log.info((Object)("Add operation: " + operation));
            this.queueData2.getFinancialQueue().add((Serializable)operation);
            this.notifyFinQueueSize();
            return this.saveData2();
        }
        return true;
    }

    public synchronized Operation[] getOperations() {
        LinkedList<Operation> op = null;
        if (!this.queueData2.getFinancialQueue().isEmpty()) {
            op = new LinkedList<Operation>();
            for (Serializable obj : this.queueData2.getFinancialQueue()) {
                if (!(obj instanceof Operation) || obj instanceof GroupOperation) break;
                op.add((Operation)obj);
            }
        }
        return op == null || op.isEmpty() ? null : op.toArray(new Operation[op.size()]);
    }

    public synchronized void deleteOperations(Operation[] opers) {
        if (opers != null) {
            boolean removed = false;
            for (Operation op : opers) {
                removed = removed || this.logRes(this.queueData2.getFinancialQueue().remove(op), op);
            }
            if (removed) {
                this.notifyFinQueueSize();
            }
            this.saveData2();
        }
    }

    public synchronized boolean putGroupOperation(GroupOperation operation) {
        if (operation != null) {
            this.log.info((Object)("Add: " + operation));
            this.queueData2.getFinancialQueue().add((Serializable)operation);
            this.notifyFinQueueSize();
            return this.saveData2();
        }
        return true;
    }

    public synchronized GroupOperation[] getGroupOperations() {
        LinkedList<GroupOperation> op = null;
        if (!this.queueData2.getFinancialQueue().isEmpty()) {
            op = new LinkedList<GroupOperation>();
            for (Serializable obj : this.queueData2.getFinancialQueue()) {
                if (!(obj instanceof GroupOperation)) break;
                op.add((GroupOperation)obj);
            }
        }
        return op == null || op.isEmpty() ? null : op.toArray(new GroupOperation[op.size()]);
    }

    public synchronized void deleteGroupOperations(GroupOperation[] opers) {
        if (opers != null) {
            boolean removed = false;
            for (GroupOperation op : opers) {
                removed = removed || this.logRes(this.queueData2.getFinancialQueue().remove(op), op);
            }
            if (removed) {
                this.notifyFinQueueSize();
            }
            this.saveData2();
        }
    }

    public synchronized boolean putDeviceStatus(DeviceStatus deviceStatus) {
        this.log.info((Object)("Try to add " + deviceStatus));
        if (deviceStatus != null) {
            Iterator<DeviceStatus> i = this.deviceStatuses.iterator();
            while (i.hasNext()) {
                DeviceStatus ds = i.next();
                if (!Objects.equals(ds.getDeviceClass(), deviceStatus.getDeviceClass())) continue;
                this.log.info((Object)("Remove not relevant state: " + ds));
                i.remove();
            }
            this.log.info((Object)("New relevant state: " + deviceStatus));
            this.deviceStatuses.add(deviceStatus);
            return true;
        }
        return true;
    }

    public synchronized DeviceStatus[] getDeviceStatuses() {
        if (!this.deviceStatuses.isEmpty()) {
            return this.deviceStatuses.toArray(new DeviceStatus[this.deviceStatuses.size()]);
        }
        return null;
    }

    public synchronized void deleteDeviceStatuses(DeviceStatus[] statuses) {
        if (statuses != null) {
            for (DeviceStatus ds : statuses) {
                this.logRes(this.deviceStatuses.remove(ds), ds);
            }
        }
    }

    public synchronized boolean putBoxInfo(BoxInfo boxInfo) {
        if (boxInfo != null) {
            this.log.info((Object)("Add box info: " + boxInfo));
            this.boxInfos.add(boxInfo);
            return true;
        }
        return true;
    }

    public synchronized BoxInfo[] getBoxInfos() {
        if (!this.boxInfos.isEmpty()) {
            return this.boxInfos.toArray(new BoxInfo[this.boxInfos.size()]);
        }
        return null;
    }

    public synchronized void deleteBoxInfos(BoxInfo[] bss) {
        if (this.boxInfos != null) {
            for (BoxInfo bi : bss) {
                this.logRes(this.boxInfos.remove(bi), bi);
            }
        }
    }

    public synchronized boolean putBoxStatus(BoxStatus boxStatus) {
        if (boxStatus != null) {
            this.log.info((Object)("Add box status: " + boxStatus));
            this.boxStatuses.add(boxStatus);
        }
        return true;
    }

    public synchronized BoxStatus[] getBoxStatuses() {
        if (!this.boxStatuses.isEmpty()) {
            return this.boxStatuses.toArray(new BoxStatus[this.boxStatuses.size()]);
        }
        return null;
    }

    public synchronized void deleteBoxStatuses(BoxStatus[] bss) {
        if (bss != null) {
            for (BoxStatus bs : bss) {
                this.logRes(this.boxStatuses.remove(bs), bs);
            }
        }
    }

    public synchronized boolean putBoxAmounts(BoxAmount boxAmount) {
        if (boxAmount != null) {
            this.log.info((Object)("Add box amount: " + boxAmount));
            this.boxAmounts.add(boxAmount);
            return true;
        }
        return true;
    }

    public synchronized BoxAmount[] getBoxAmounts() {
        if (!this.boxAmounts.isEmpty()) {
            return this.boxAmounts.toArray(new BoxAmount[this.boxAmounts.size()]);
        }
        return null;
    }

    public synchronized void deleteBoxAmounts(BoxAmount[] bas) {
        if (bas != null) {
            for (BoxAmount ba : bas) {
                this.logRes(this.boxAmounts.remove(ba), ba);
            }
        }
    }

    public synchronized boolean putEvent(Event ... events) {
        if (events != null) {
            for (Event event : events) {
                this.log.info((Object)("Add event: " + event));
                if (event.getComment() != null) {
                    event.setComment(event.getComment().replaceAll("\\p{C}", "?"));
                }
                this.queueData1.getEvents().add(event);
            }
            return this.saveData1();
        }
        return true;
    }

    public synchronized Event[] getEvents() {
        if (!this.queueData1.getEvents().isEmpty()) {
            return this.queueData1.getEvents().toArray(new Event[this.queueData1.getEvents().size()]);
        }
        return null;
    }

    public synchronized void deleteEvents(Event[] evts) {
        if (evts != null) {
            for (Event e : evts) {
                this.logRes(this.queueData1.getEvents().remove(e), e);
            }
            this.saveData1();
        }
    }

    public synchronized boolean putMoneyCollection(MoneyCollection mc) {
        if (mc != null) {
            this.log.info((Object)("Add mc: " + mc));
            this.queueData2.getFinancialQueue().add(mc);
            this.notifyFinQueueSize();
            return this.saveData2();
        }
        return true;
    }

    public synchronized MoneyCollection[] getMoneyCollections() {
        LinkedList<MoneyCollection> mcs = null;
        if (!this.queueData2.getFinancialQueue().isEmpty()) {
            mcs = new LinkedList<MoneyCollection>();
            for (Serializable obj : this.queueData2.getFinancialQueue()) {
                if (!(obj instanceof MoneyCollection)) break;
                mcs.add((MoneyCollection)obj);
            }
        }
        return mcs == null || mcs.isEmpty() ? null : mcs.toArray(new MoneyCollection[mcs.size()]);
    }

    public synchronized void deleteMoneyCollections(MoneyCollection[] mcs) {
        if (mcs != null) {
            for (MoneyCollection mc : mcs) {
                if (!this.logRes(this.queueData2.getFinancialQueue().remove(mc), mc)) continue;
                this.notifyFinQueueSize();
            }
            this.saveData2();
        }
    }

    public synchronized boolean putStatistics(Statistics st) {
        if (st != null) {
            this.log.info((Object)("Add: " + st));
            this.queueData1.getStatistics().add(st);
            return this.saveData1();
        }
        return true;
    }

    public synchronized Statistics[] getStatistics() {
        if (!this.queueData1.getStatistics().isEmpty()) {
            return this.queueData1.getStatistics().toArray(new Statistics[this.queueData1.getStatistics().size()]);
        }
        return null;
    }

    public synchronized void deleteStatistics(Statistics[] stats) {
        if (stats != null) {
            for (Statistics s : stats) {
                this.logRes(this.queueData1.getStatistics().remove(s), s);
            }
            this.saveData1();
        }
    }

    public synchronized boolean putSaleConfirm(SaleConfirm sc) {
        if (sc != null) {
            this.log.info((Object)("Add: " + sc));
            this.queueData1.getSaleConfirms().add(sc);
            return this.saveData1();
        }
        return true;
    }

    public synchronized SaleConfirm[] getSaleConfirms() {
        if (!this.queueData1.getSaleConfirms().isEmpty()) {
            return this.queueData1.getSaleConfirms().toArray(new SaleConfirm[this.queueData1.getSaleConfirms().size()]);
        }
        return null;
    }

    public synchronized void deleteSaleConfirms(SaleConfirm[] cnfs) {
        if (cnfs != null) {
            for (SaleConfirm s : cnfs) {
                this.logRes(this.queueData1.getSaleConfirms().remove(s), s);
            }
            this.saveData1();
        }
    }

    public synchronized boolean putDeviceInfo(DeviceInfoStub di) {
        if (di != null) {
            di.setFirmware(di.getFirmware().replaceAll("\\p{C}", "?"));
            di.setFirmware1(di.getFirmware1().replaceAll("\\p{C}", "?"));
            di.setFirmware2(di.getFirmware2().replaceAll("\\p{C}", "?"));
            di.setInfo(di.getInfo().replaceAll("\\p{C}", "?"));
            di.setModel(di.getModel().replaceAll("\\p{C}", "?"));
            di.setSerial(di.getSerial().replaceAll("\\p{C}", "?"));
            this.log.info((Object)("Add: " + di));
            this.deviceInfos.add(di);
        }
        return true;
    }

    public synchronized DeviceInfoStub[] getDeviceInfo() {
        if (!this.deviceInfos.isEmpty()) {
            return this.deviceInfos.toArray(new DeviceInfoStub[this.deviceInfos.size()]);
        }
        return null;
    }

    public synchronized void deleteDeviceInfos(DeviceInfoStub[] devin) {
        if (devin != null) {
            for (DeviceInfoStub d : devin) {
                this.logRes(this.deviceInfos.remove(d), d);
            }
        }
    }

    public synchronized boolean putUpdateState(UpdateState state) {
        if (state != null) {
            this.log.info((Object)("Add update state: " + state));
            this.updateStates.removeIf(t -> t.getType() == state.getType());
            this.updateStates.add(state);
        }
        return true;
    }

    public synchronized UpdateState[] getUpdateStates() {
        if (!this.updateStates.isEmpty()) {
            return this.updateStates.toArray(new UpdateState[this.updateStates.size()]);
        }
        return null;
    }

    public synchronized void deleteUpdateState(UpdateState updateState) {
        if (updateState != null) {
            this.updateStates.remove(updateState);
        }
    }

    public synchronized boolean putModemState(ModemState modemState) {
        if (modemState != null) {
            this.log.info((Object)("Add modem state " + modemState));
            this.queueData1.getModemStates().clear();
            this.queueData1.getModemStates().add(modemState);
            return this.saveData1();
        }
        return true;
    }

    public synchronized ModemState getModemState() {
        if (this.queueData1.getModemStates().isEmpty()) {
            return null;
        }
        return this.queueData1.getModemStates().get(0);
    }

    public synchronized void deleteModemState(ModemState modemState) {
        this.queueData1.getModemStates().remove(modemState);
        this.saveData1();
    }

    public synchronized boolean putNetworkDevices(NetworkDevice[] networkDevices) {
        if (networkDevices != null) {
            this.log.info((Object)"Add network devices");
            this.networkDevices = networkDevices;
        }
        return true;
    }

    public synchronized NetworkDevice[] getNetworkDevices() {
        return this.networkDevices;
    }

    public synchronized void deleteNetworkDevices(NetworkDevice[] networkDevices) {
        if (this.networkDevices == networkDevices) {
            this.networkDevices = null;
        }
    }

    public synchronized boolean putCommandResult(CommandResult cr) {
        if (cr != null) {
            String comment;
            String string = comment = cr.getComment() != null ? cr.getComment().replaceAll("\\p{C}", "?") : "";
            if (comment.length() > 250) {
                comment = comment.substring(0, 249);
            }
            cr.setComment(comment);
            this.log.info((Object)("Add cmd res: " + cr));
            this.queueData1.getCommandResults().add(cr);
            return this.saveData1();
        }
        return true;
    }

    public synchronized CommandResult[] getCommandResults() {
        if (!this.queueData1.getCommandResults().isEmpty()) {
            return this.queueData1.getCommandResults().toArray(new CommandResult[this.queueData1.getCommandResults().size()]);
        }
        return null;
    }

    public synchronized void deleteCommandResults(CommandResult[] commandResults) {
        if (commandResults != null) {
            for (CommandResult cr : commandResults) {
                this.logRes(this.queueData1.getCommandResults().remove(cr), cr);
            }
            this.saveData1();
        }
    }

    public void setDiskSpace(Integer space) {
        this.diskSpace = space;
    }

    public Integer getDiskSpace() {
        return this.diskSpace;
    }

    public synchronized boolean putJamm(JammInfo jammInfo) {
        if (jammInfo != null) {
            this.log.info((Object)("Add: " + jammInfo));
            this.queueData1.getJammInfos().add(jammInfo);
            return this.saveData1();
        }
        return true;
    }

    public synchronized JammInfo[] getJamms() {
        if (!this.queueData1.getJammInfos().isEmpty()) {
            return this.queueData1.getJammInfos().toArray(new JammInfo[this.queueData1.getJammInfos().size()]);
        }
        return null;
    }

    public synchronized void deleteJamm(JammInfo[] jammInfos) {
        if (jammInfos != null) {
            for (JammInfo jammInfo : jammInfos) {
                this.logRes(this.queueData1.getJammInfos().remove(jammInfo), jammInfo);
            }
            this.saveData1();
        }
    }

    public synchronized boolean putNetworkStatistics(NetworkStatistics ns) {
        if (ns != null) {
            this.log.info((Object)("Add net stat: " + ns));
            this.queueData1.getNetworkStatistics().add(ns);
            return this.saveData1();
        }
        return true;
    }

    public synchronized NetworkStatistics[] getNetworkStatistics() {
        if (!this.queueData1.getNetworkStatistics().isEmpty()) {
            return this.queueData1.getNetworkStatistics().toArray(new NetworkStatistics[this.queueData1.getNetworkStatistics().size()]);
        }
        return null;
    }

    public synchronized void deleteNetworkStatistics(NetworkStatistics[] networkStatistics) {
        if (networkStatistics != null) {
            for (NetworkStatistics ns : networkStatistics) {
                this.logRes(this.queueData1.getNetworkStatistics().remove(ns), ns);
            }
            this.saveData1();
        }
    }

    public synchronized boolean putCbcStatus(CbcStatus cbcStatus) {
        if (cbcStatus != null) {
            this.log.info((Object)("Add: " + cbcStatus));
            this.queueData1.getCbcStates().add(cbcStatus);
            return this.saveData1();
        }
        return true;
    }

    public synchronized CbcStatus[] getCbcStates() {
        if (!this.queueData1.getCbcStates().isEmpty()) {
            return this.queueData1.getCbcStates().toArray(new CbcStatus[this.queueData1.getCbcStates().size()]);
        }
        return null;
    }

    public synchronized void deleteCbcStates(CbcStatus[] cbcStates) {
        if (cbcStates != null) {
            for (CbcStatus csr : cbcStates) {
                this.logRes(this.queueData1.getCbcStates().remove(csr), csr);
            }
            this.saveData1();
        }
    }

    public synchronized boolean putDemand(Demand demand) {
        if (demand != null) {
            this.log.info((Object)("Add demand " + demand));
            this.queueData1.getDemandes().add(demand);
            return this.saveData1();
        }
        return true;
    }

    public synchronized Demand[] getDemands() {
        if (!this.queueData1.getDemandes().isEmpty()) {
            return this.queueData1.getDemandes().toArray(new Demand[this.queueData1.getDemandes().size()]);
        }
        return null;
    }

    public synchronized void deleteDemand(Demand[] demands) {
        if (demands != null) {
            for (Demand csr : demands) {
                this.logRes(this.queueData1.getDemandes().remove(csr), csr);
            }
            this.saveData1();
        }
    }

    public synchronized boolean putTransfers(List<CashTransfer> transfers) {
        if (transfers != null) {
            this.log.info((Object)("Add transfers: " + transfers));
            this.queueData1.getTransfers().addAll(transfers);
            this.notifyFinQueueSize();
            return this.saveData2();
        }
        return true;
    }

    public synchronized List<CashTransfer> getCashTransfers() {
        if (!this.queueData1.getTransfers().isEmpty()) {
            return Collections.unmodifiableList(this.queueData1.getTransfers());
        }
        return null;
    }

    public synchronized void deleteCashTransfers(List<CashTransfer> transfers) {
        if (transfers != null) {
            for (CashTransfer ct : transfers) {
                this.logRes(this.queueData1.getTransfers().remove(ct), ct);
            }
            this.saveData1();
        }
    }

    public synchronized boolean putAdvStatistics(List<AdvStatistic> as) {
        if (as != null) {
            this.log.info((Object)("Add adv stat: " + as));
            this.queueData1.getAdvStatistics().addAll(as);
            return this.saveData1();
        }
        return true;
    }

    public synchronized AdvStatistic[] getAdvStatistics() {
        if (!this.queueData1.getAdvStatistics().isEmpty()) {
            return this.queueData1.getAdvStatistics().toArray(new AdvStatistic[this.queueData1.getAdvStatistics().size()]);
        }
        return null;
    }

    public synchronized void deleteAdvStatistics(AdvStatistic[] advStatistics) {
        if (advStatistics != null) {
            for (AdvStatistic as : advStatistics) {
                this.logRes(this.queueData1.getAdvStatistics().remove(as), as);
            }
            this.saveData1();
        }
    }

    public synchronized SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    public synchronized void setSystemInfo(SystemInfo systemInfo) {
        this.log.info((Object)("Set sysinfo: " + systemInfo));
        this.systemInfo = systemInfo;
    }

    public synchronized void setEvnRiskFactors(EnvRiskFactors evnRiskFactors) {
        this.log.info((Object)("Set risk factors: " + evnRiskFactors));
        this.evnRiskFactors = evnRiskFactors;
    }

    public synchronized EnvRiskFactors getEvnRiskFactors() {
        return this.evnRiskFactors;
    }

    private void readData() {
        this.log.info((Object)"Read generic queue");
        try {
            this.log.info((Object)"Read main store");
            this.queueData1 = (QueueData1)this.mainFile1.readObject();
            if (this.queueData1 != null) {
                this.log.info((Object)"Success");
            } else {
                this.log.info((Object)"Store have no data");
            }
        }
        catch (Exception ex) {
            this.log.info((Object)("Error on read main store: " + ex.getMessage()));
        }
        if (this.queueData1 == null) {
            try {
                this.log.info((Object)"Read secondary store");
                this.queueData1 = (QueueData1)this.tmpFile1.readObject();
                if (this.queueData1 != null) {
                    this.log.info((Object)"Success");
                } else {
                    this.log.info((Object)"Store have no data");
                }
            }
            catch (Exception ex) {
                this.log.info((Object)("Error on read secondary store: " + ex.getMessage()));
            }
        }
        if (this.queueData1 == null) {
            this.queueData1 = new QueueData1();
        } else {
            this.log.info((Object)"===========================================================");
            this.log.info((Object)("Store contains: " + this.queueData1));
            this.log.info((Object)"===========================================================");
        }
        this.log.info((Object)"Read financial queue");
        try {
            this.log.info((Object)"Read main store");
            this.queueData2 = this.readQueue2FromFile(this.mainFile2);
        }
        catch (Exception ex) {
            this.log.info((Object)("Error on read main store: " + ex.getMessage()));
        }
        if (this.queueData2 == null) {
            try {
                this.log.info((Object)"Read secondary store");
                this.queueData2 = this.readQueue2FromFile(this.tmpFile2);
            }
            catch (Exception ex) {
                this.log.info((Object)("Error on read secondary store: " + ex.getMessage()));
            }
        }
        if (this.queueData2 == null) {
            this.queueData2 = new QueueData2();
        } else {
            this.log.info((Object)"===========================================================");
            this.log.info((Object)("Store contains: " + this.queueData2.getSize()));
            this.log.info((Object)"===========================================================");
        }
    }

    private QueueData2 readQueue2FromFile(ObjectReadWriteStream orwStream) throws IOException, ClassNotFoundException {
        QueueData2 queue = null;
        Object readObject = orwStream.readObject();
        if (readObject instanceof QueueData2) {
            queue = (QueueData2)readObject;
        } else if (readObject instanceof SignedObject) {
            SignedObject signed = (SignedObject)readObject;
            queue = (QueueData2)signed.getObject();
            if (!QueueUtils.verifyQueue(signed, this.keyStore, this.log)) {
                for (Serializable obj : queue.getFinancialQueue()) {
                    if (!(obj instanceof Operation)) continue;
                    Operation op = (Operation)obj;
                    int flag = op.getFlags();
                    op.setFlags(flag | 0x40);
                }
            }
        }
        return queue;
    }

    private boolean saveData1() {
        try {
            this.log.info((Object)"Save reserve data");
            this.tmpFile1.writeObject(this.queueData1);
            this.log.info((Object)"Save main data");
            this.mainFile1.writeObject(this.queueData1);
        }
        catch (Exception ex) {
            this.diskError = true;
            if (this.listener != null) {
                this.listener.onDiskError();
            }
            this.log.error((Object)"Error on save data", (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean saveData2() {
        try {
            SignedObject sign = QueueUtils.signQueue(this.queueData2, this.keyStore, this.log);
            this.log.info((Object)"Save reserve data");
            if (sign != null) {
                this.tmpFile2.writeObject(sign);
            } else {
                this.tmpFile2.writeObject(this.queueData2);
            }
            this.log.info((Object)"Save main data");
            if (sign != null) {
                this.mainFile2.writeObject(sign);
            } else {
                this.mainFile2.writeObject(this.queueData2);
            }
        }
        catch (Exception ex) {
            this.diskError = true;
            if (this.listener != null) {
                this.listener.onDiskError();
            }
            this.log.error((Object)"Error on save data", (Throwable)ex);
            return false;
        }
        return true;
    }

    public void close() {
        if (this.mainFile1 != null) {
            try {
                this.mainFile1.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.tmpFile1 != null) {
            try {
                this.tmpFile1.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.mainFile2 != null) {
            try {
                this.mainFile2.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.tmpFile2 != null) {
            try {
                this.tmpFile2.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void printFileSize(String name) {
        File f = new File(name);
        if (f.canRead()) {
            this.log.info((Object)(f.getAbsolutePath() + ", size=" + f.length()));
        } else {
            this.log.info((Object)(f.getAbsolutePath() + ", n/a"));
        }
    }

    public void onFraudDetect() {
        for (Serializable obj : this.queueData2.getFinancialQueue()) {
            if (!(obj instanceof Operation) || obj instanceof GroupOperation) continue;
            Operation op = (Operation)obj;
            int opFlag = op.getFlags() | 0x40;
            op.setFlags(opFlag);
        }
    }

    private boolean logRes(boolean res, Object data) {
        if (res) {
            this.log.info((Object)("Remove from queue " + data));
        } else {
            this.log.error((Object)("Error on remove " + data));
        }
        return res;
    }
}

