/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.connector.ws.security;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import ru.softlogic.srv.connector.ws.security.BasicSecurityException;

public class SignatureAuth {
    public static final String defaultSignMethod = "SHA1withRSA";
    private Logger logger = Logger.getLogger(SignatureAuth.class);
    private PrivateKey privKey;
    private PublicKey pubKey;
    private String signMethod = "SHA1withRSA";

    public SignatureAuth(String priv, String pub) throws BasicSecurityException {
        try {
            this.privKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(Base64.decodeBase64((byte[])priv.getBytes("utf-8"))));
            this.pubKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64.decodeBase64((byte[])pub.getBytes("utf-8"))));
        }
        catch (InvalidKeySpecException ex) {
            this.logger.error((Object)ex.getMessage());
            throw new BasicSecurityException(ex);
        }
        catch (Exception ex) {
            this.logger.error((Object)ex.getMessage());
            throw new BasicSecurityException(ex);
        }
    }

    public SignatureAuth(String privKey, String pubKey, String signMethod) throws BasicSecurityException {
        this(privKey, pubKey);
        this.signMethod = signMethod;
    }

    public boolean verifySignature(String message, String sign) throws SignatureException {
        try {
            Signature signature = Signature.getInstance(this.signMethod);
            signature.initVerify(this.pubKey);
            signature.update(message.getBytes("utf-8"));
            return signature.verify(Base64.decodeBase64((byte[])sign.getBytes("utf-8")));
        }
        catch (UnsupportedEncodingException ex) {
            this.logger.error((Object)ex.getMessage());
            throw new SignatureException(ex);
        }
        catch (InvalidKeyException ex) {
            this.logger.error((Object)ex.getMessage());
            throw new SignatureException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            this.logger.error((Object)ex.getMessage());
            throw new SignatureException(ex);
        }
    }

    public String signMessage(String message) throws SignatureException {
        try {
            Signature signature = Signature.getInstance(this.signMethod);
            signature.initSign(this.privKey);
            signature.update(message.getBytes("utf-8"));
            String sign = new String(Base64.encodeBase64((byte[])signature.sign()), "utf-8");
            return sign;
        }
        catch (UnsupportedEncodingException ex) {
            this.logger.error((Object)ex.getMessage());
            throw new SignatureException(ex);
        }
        catch (InvalidKeyException ex) {
            this.logger.error((Object)ex.getMessage());
            throw new SignatureException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            this.logger.error((Object)ex.getMessage());
            throw new SignatureException(ex);
        }
    }
}

