/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.connector.ws;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.cash.unit.CashUnitGroup;
import ru.softlogic.cash.unit.CashUnitProfile;
import ru.softlogic.reference.exchange.ExchangeCurrencies;
import ru.softlogic.reference.exchange.ExchangeDirection;
import ru.softlogic.reference.exchange.ExchangeProfile;
import ru.softlogic.reference.exchange.ExchangeRange;
import ru.softlogic.reference.exchange.ExchangeRule;
import ru.softlogic.reference.exchange.ExchangeSumInRule;
import ru.softlogic.reference.exchange.ExchangeSumOutRule;
import ru.softlogic.reference.fraud.FraudControlRule;
import ru.softlogic.reference.geo.GeographicArea;
import ru.softlogic.reference.hdw.BoxDescription;
import ru.softlogic.reference.hdw.CashUnitSelection;
import ru.softlogic.reference.hdw.DispenseProfile;
import ru.softlogic.reference.hdw.PayoutProfile;
import ru.softlogic.srv.connector.ws.ExchangeDirectionComparator;
import ru.softlogic.srv.connector.ws.stub.CashUnitGroupStub;
import ru.softlogic.srv.connector.ws.stub.CashUnitProfileStub;
import ru.softlogic.srv.connector.ws.stub.CashUnitSelectionStub;
import ru.softlogic.srv.connector.ws.stub.CashUnitStub;
import ru.softlogic.srv.connector.ws.stub.DispenseProfileStub;
import ru.softlogic.srv.connector.ws.stub.FraudControlRuleStub;
import ru.softlogic.srv.connector.ws.stub.GeographicAreaStub;
import ru.softlogic.srv.connector.ws.stub.PayoutProfileStub;
import ru.softlogic.srv.connector.ws.stub.exchange.ExchangeCurrenciesStub;
import ru.softlogic.srv.connector.ws.stub.exchange.ExchangeDirectionStub;
import ru.softlogic.srv.connector.ws.stub.exchange.ExchangeProfileStub;
import ru.softlogic.srv.connector.ws.stub.exchange.ExchangeRangeStub;
import ru.softlogic.srv.connector.ws.stub.exchange.ExchangeRateInRule;
import ru.softlogic.srv.connector.ws.stub.exchange.ExchangeRateOutRule;
import ru.softlogic.srv.connector.ws.stub.exchange.ExchangeRuleStub;

public class WSHelper {
    private WSHelper() {
    }

    public static CashUnitProfile convert(CashUnitProfileStub src) {
        if (src == null) {
            return null;
        }
        CashUnitProfile res = new CashUnitProfile();
        res.setCurrency(src.getCurrency());
        res.setFlags(src.getFlags());
        res.setId(src.getId());
        res.setName(src.getName());
        if (src.getCashUnitGroups() != null) {
            CashUnitGroupStub[] grps = src.getCashUnitGroups();
            CashUnitGroup[] grp = new CashUnitGroup[src.getCashUnitGroups().length];
            for (int i = 0; i < grps.length; ++i) {
                grp[i] = WSHelper.convert(grps[i]);
            }
            res.setCashUnitGroups(grp);
        }
        return res;
    }

    public static CashUnit convert(CashUnitStub src) {
        if (src == null) {
            return null;
        }
        return new CashUnit(src.getId(), src.getNominal(), src.getType());
    }

    public static CashUnitGroup convert(CashUnitGroupStub src) {
        if (src == null) {
            return null;
        }
        CashUnitGroup res = new CashUnitGroup();
        res.setCashUnit(WSHelper.convert(src.getCashUnit()));
        res.setEnable(src.isEnable());
        res.setSecure(src.isSecure());
        res.setEndTime(src.getEndTime());
        res.setStartTime(src.getStartTime());
        return res;
    }

    public static PayoutProfile convert(PayoutProfileStub stub) {
        if (stub == null) {
            return null;
        }
        HashMap<CashUnit, Integer> result = new HashMap<CashUnit, Integer>();
        Map<CashUnitStub, Integer> counts = stub.getCounts();
        if (counts != null) {
            for (Map.Entry<CashUnitStub, Integer> entry : counts.entrySet()) {
                result.put(WSHelper.convert(entry.getKey()), entry.getValue());
            }
        }
        return new PayoutProfile(result);
    }

    public static List<FraudControlRule> creatFCRS(List<FraudControlRuleStub> src) {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ArrayList<FraudControlRule> res = new ArrayList<FraudControlRule>();
        for (FraudControlRuleStub fcrs : src) {
            FraudControlRule fcr = new FraudControlRule();
            fcr.setHardwareDetection(fcrs.isHardwareDetection());
            fcr.setHeuristicAnalysis(fcrs.isHeuristicAnalysis());
            fcr.setIdService(fcrs.getIdService());
            fcr.setMinNominalNote(fcrs.getMinNominalNote());
            fcr.setOptionalSuccess(fcrs.isOptionalSuccess());
            fcr.setRejectKol(fcrs.getRejectKol());
            fcr.setSendTimeout(fcrs.getSendTimeout());
            fcr.setTimeout(fcrs.getTimeout());
            res.add(fcr);
        }
        return res;
    }

    public static List<GeographicArea> creatGA(List<GeographicAreaStub> src) {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ArrayList<GeographicArea> res = new ArrayList<GeographicArea>();
        for (GeographicAreaStub gas : src) {
            GeographicArea ga = new GeographicArea();
            ga.setId(gas.getId());
            ga.setName(gas.getName());
            ga.setShortName(gas.getShortName());
            ga.setIcon(gas.getIcon());
            ga.setCountries(gas.getCountries());
            ga.setLocales(gas.getLocales());
            res.add(ga);
        }
        return res;
    }

    public static ExchangeProfile convert(ExchangeProfileStub stub) {
        if (stub == null) {
            return null;
        }
        LinkedList<ExchangeDirection> directions = new LinkedList<ExchangeDirection>();
        if (stub.getDirections() != null) {
            for (ExchangeDirectionStub direction : stub.getDirections()) {
                directions.add(WSHelper.convert(direction));
            }
        }
        Collections.sort(directions, new ExchangeDirectionComparator());
        return new ExchangeProfile(stub.getId().intValue(), stub.getName(), stub.isShowGreeting(), stub.isShowDenominationConfirm(), stub.isAutoPayout(), stub.isRequestRates(), directions);
    }

    public static ExchangeDirection convert(ExchangeDirectionStub stub) {
        if (stub == null) {
            return null;
        }
        LinkedList<ExchangeRange> rangeRates = new LinkedList<ExchangeRange>();
        String currencyFrom = stub.getCurrencies().getCurrencyFrom();
        String currencyTo = stub.getCurrencies().getCurrencyTo();
        if (stub.getRanges() != null) {
            for (ExchangeRangeStub range : stub.getRanges()) {
                rangeRates.add(WSHelper.convertExchangeRange(range, currencyFrom, currencyTo));
            }
        }
        return new ExchangeDirection(stub.getId(), WSHelper.convert(stub.getCurrencies()), WSHelper.convert(stub.getCashUnitProfile()), stub.isEnable(), stub.getSortOrder(), stub.getHandlerType(), rangeRates, WSHelper.convertIn(stub.getRateInRules()), WSHelper.convertOut(stub.getRateOutRules()), stub.getFlags(), stub.getCommission(), stub.getMinSum(), stub.getMaxSum(), stub.getChangeCurrency());
    }

    private static List<ExchangeSumInRule> convertIn(List<ExchangeRateInRule> rules) {
        if (rules == null || rules.isEmpty()) {
            return new LinkedList<ExchangeSumInRule>();
        }
        LinkedList<ExchangeSumInRule> result = new LinkedList<ExchangeSumInRule>();
        for (ExchangeRateInRule er : rules) {
            result.add(new ExchangeSumInRule(er.getId(), er.isEnable(), er.isHot(), er.getCashUnitProfile(), er.getAcceptedSum(), er.getAcceptedMaxSum(), er.getPayoutAccuracy(), er.getRoundType()));
        }
        return result;
    }

    private static List<ExchangeSumOutRule> convertOut(List<ExchangeRateOutRule> rules) {
        if (rules == null || rules.isEmpty()) {
            return new LinkedList<ExchangeSumOutRule>();
        }
        LinkedList<ExchangeSumOutRule> result = new LinkedList<ExchangeSumOutRule>();
        for (ExchangeRateOutRule er : rules) {
            result.add(new ExchangeSumOutRule(er.getId(), er.isEnable(), er.isHot(), er.getCashUnitProfile(), er.getSumInputExcess(), er.getSumPayout(), er.getRoundType()));
        }
        return result;
    }

    private static ExchangeCurrencies convert(ExchangeCurrenciesStub stub) {
        if (stub == null) {
            return null;
        }
        return new ExchangeCurrencies(Integer.valueOf(stub.getId()), stub.getCurrencyFrom(), stub.getCurrencyTo(), stub.getIdService(), stub.getIdCommissionProfile(), stub.isEnable());
    }

    private static ExchangeRange convertExchangeRange(ExchangeRangeStub stub, String currencyFrom, String currencyTo) {
        if (stub == null) {
            return null;
        }
        TreeSet<ExchangeRule> rules = new TreeSet<ExchangeRule>();
        if (stub.getRules() != null) {
            for (ExchangeRuleStub rule : stub.getRules()) {
                rules.add(WSHelper.convertExchangeRule(rule, currencyFrom, currencyTo));
            }
        }
        return new ExchangeRange(stub.getFrom(), stub.getTo(), rules, stub.isEnable());
    }

    private static ExchangeRule convertExchangeRule(ExchangeRuleStub stub, String currencyFrom, String currencyTo) {
        if (stub == null) {
            return null;
        }
        return new ExchangeRule(Integer.valueOf(stub.getId()), stub.getAcceptedSum(), stub.getAcceptedMaxSum(), stub.getPrefDispensedSum(), Integer.valueOf(stub.getMinDispensedSum()), Integer.valueOf(stub.getMaxDispensedSum()), WSHelper.convert(stub.getCashUnitProfile()), stub.isEnable(), stub.isHot());
    }

    public static DispenseProfile convert(DispenseProfileStub stub) {
        if (stub == null) {
            return null;
        }
        HashMap<BoxDescription, CashUnitSelection> result = new HashMap<BoxDescription, CashUnitSelection>();
        Map<BoxDescription, CashUnitSelectionStub> denominationSelector = stub.getDenominationSelector();
        if (denominationSelector != null) {
            for (Map.Entry<BoxDescription, CashUnitSelectionStub> entry : denominationSelector.entrySet()) {
                result.put(entry.getKey(), WSHelper.convert(entry.getValue()));
            }
        }
        return new DispenseProfile(stub.getDispAlgorithm(), stub.getPayoutProfile(), result);
    }

    public static CashUnitSelection convert(CashUnitSelectionStub stub) {
        if (stub == null) {
            return null;
        }
        HashSet<CashUnit> result = new HashSet<CashUnit>();
        Set<CashUnitStub> denominationSelector = stub.getDenominationSet();
        if (denominationSelector != null) {
            for (CashUnitStub cashUnit : denominationSelector) {
                result.add(WSHelper.convert(cashUnit));
            }
        }
        return new CashUnitSelection(Math.max(0, stub.getDefaultCount()), result);
    }
}

