/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.connector.ws;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import ru.softlogic.cash.Sum;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.srv.DataItem;
import ru.softlogic.srv.api.card.CardCover;
import ru.softlogic.srv.api.card.CardOperation;
import ru.softlogic.srv.api.cbc.ActivationResult;
import ru.softlogic.srv.api.cbc.ActivationResultType;
import ru.softlogic.srv.api.operation.ProcessingResult;
import ru.softlogic.srv.api.operation.ProcessingResultType;
import ru.softlogic.srv.connector.ConnConfiguration;
import ru.softlogic.srv.connector.ConnectorConfigurationException;
import ru.softlogic.srv.connector.ConnectorException;
import ru.softlogic.srv.connector.Producer;
import ru.softlogic.srv.connector.ProxyConfiguration;
import ru.softlogic.srv.connector.StateWatcher;
import ru.softlogic.srv.connector.ws.WSConnector;

public class WSConnectorStub
extends WSConnector {
    private final Logger log = Logger.getLogger((String)"net");
    private final File response = new File("./test/");

    public WSConnectorStub(ConnConfiguration conf, ProxyConfiguration proxy, long hdwId, int point, StateWatcher stateWatcher, Producer<String> swVersionProducer) throws ConnectorConfigurationException {
        super(conf, proxy, hdwId, point, stateWatcher, swVersionProducer);
    }

    @Override
    public boolean processGroup(GroupOperation[] operations) throws ConnectorException {
        return true;
    }

    @Override
    public CardOperation processCard(Operation payment, CardCover cardCover) throws ConnectorException {
        return null;
    }

    @Override
    public ActivationResult acivateCashBackCard(String pin, Sum sum, Sum maxSum, int activationNumber) throws ConnectorException {
        return new ActivationResult(ActivationResultType.ErrPermit, 0, null);
    }

    @Override
    public ProcessingResult process(Operation operation) throws ConnectorException {
        ProcessingResult pr = this._process(operation);
        if (pr.getType() == ProcessingResultType.Ok) {
            this.log.info((Object)"Send to server");
            super.process(new Operation[]{operation});
        }
        return pr;
    }

    public ProcessingResult _process(Operation operation) throws ConnectorException {
        File src = new File(this.response, operation.getService().getId() + "_resp.xml");
        if (!src.exists()) {
            throw new ConnectorException("File does not exist: " + src.getAbsolutePath());
        }
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(src);
            Element root = doc.getDocumentElement();
            for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof Element) || !"case".equals(child.getNodeName())) continue;
                Element c = (Element)child;
                String attr = c.getAttribute("attr");
                String value = c.getAttribute("value");
                if (operation.getForm().get(attr) == null || !((String)operation.getForm().get(attr)).equals(value)) continue;
                String timeoutstr = c.getAttribute("timeout");
                int timeout = 0;
                if (!timeoutstr.isEmpty()) {
                    timeout = Integer.parseInt(timeoutstr);
                }
                for (Node ch = child.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
                    if (!(ch instanceof Element) || !"ProcessingResult".equals(ch.getNodeName())) continue;
                    return this.getProcessingResult((Element)ch, timeout);
                }
            }
            return new ProcessingResult(ProcessingResultType.Error);
        }
        catch (IOException | NumberFormatException | ParserConfigurationException | SAXException | ConnectorException ex) {
            throw new ConnectorException(ex);
        }
    }

    private ProcessingResult getProcessingResult(Element root, int timeout) throws ConnectorException {
        try {
            Thread.sleep((long)timeout * 1000L);
            ProcessingResultType type = null;
            DataItem[] dataItems = null;
            if ("ok".equalsIgnoreCase(root.getAttribute("type"))) {
                type = ProcessingResultType.Ok;
            } else if ("error".equalsIgnoreCase(root.getAttribute("type"))) {
                type = ProcessingResultType.Error;
            } else {
                throw new ConnectorException("Generate exception from response type");
            }
            LinkedList<Element> data = new LinkedList<Element>();
            for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof Element) || !"DataItem".equals(child.getNodeName())) continue;
                data.add((Element)child);
            }
            if (!data.isEmpty()) {
                dataItems = new DataItem[data.size()];
                for (int i = 0; i < data.size(); ++i) {
                    String key = ((Element)data.get(i)).getAttribute("key");
                    String val = ((Element)data.get(i)).getAttribute("val");
                    dataItems[i] = new DataItem(key, val);
                }
            }
            return new ProcessingResult(type, dataItems);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new ConnectorException(ex);
        }
    }
}

