/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.connector.ws;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import ru.softlogic.cash.BoxId;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.input.model.FeeSum;
import ru.softlogic.input.model.NestedData;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.advanced.actions.request.Response;
import ru.softlogic.operation.ChildOperation;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.operation.OperationState;
import ru.softlogic.reference.References;
import ru.softlogic.reference.adv.AdvStatistic;
import ru.softlogic.reference.adv.AdvStatisticRequest;
import ru.softlogic.reference.exchange.CashBoxContent;
import ru.softlogic.reference.menu.Menu;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuKey;
import ru.softlogic.reference.menu.MenuKeyLang;
import ru.softlogic.reference.point.PointOptions;
import ru.softlogic.reference.point.TransportType;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.srv.api.card.CardCover;
import ru.softlogic.srv.api.card.CardOperation;
import ru.softlogic.srv.api.card.SaleConfirm;
import ru.softlogic.srv.api.cbc.ActivationResult;
import ru.softlogic.srv.api.cbc.CbcStatus;
import ru.softlogic.srv.api.command.CommandResult;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.iface.NetworkDevice;
import ru.softlogic.srv.api.modem.ModemState;
import ru.softlogic.srv.api.network.NetworkStatistics;
import ru.softlogic.srv.api.network.NetworkStatisticsRequest;
import ru.softlogic.srv.api.operation.ProcessingResult;
import ru.softlogic.srv.api.oth.Demand;
import ru.softlogic.srv.api.oth.FindOperationResult;
import ru.softlogic.srv.api.oth.JammInfo;
import ru.softlogic.srv.api.oth.MoneyCollection;
import ru.softlogic.srv.api.oth.SystemInfo;
import ru.softlogic.srv.api.refs.SrvReferences;
import ru.softlogic.srv.api.request.RequestResult;
import ru.softlogic.srv.api.security.EnvRiskFactors;
import ru.softlogic.srv.api.status.DeviceStatus;
import ru.softlogic.srv.api.verify.VerifyResult;
import ru.softlogic.srv.cash.Statistics;
import ru.softlogic.srv.connector.ConnConfiguration;
import ru.softlogic.srv.connector.ConnectorConfigurationException;
import ru.softlogic.srv.connector.ConnectorException;
import ru.softlogic.srv.connector.Producer;
import ru.softlogic.srv.connector.ProxyConfiguration;
import ru.softlogic.srv.connector.ServerAddress;
import ru.softlogic.srv.connector.ServerInterface;
import ru.softlogic.srv.connector.StateWatcher;
import ru.softlogic.srv.connector.selector.AddressSelector;
import ru.softlogic.srv.connector.ws.BusinessService;
import ru.softlogic.srv.connector.ws.BusinessServiceService;
import ru.softlogic.srv.connector.ws.WSHelper;
import ru.softlogic.srv.connector.ws.security.BasicSecurityException;
import ru.softlogic.srv.connector.ws.security.SSLSocketFactory;
import ru.softlogic.srv.connector.ws.security.SecurityHandler;
import ru.softlogic.srv.connector.ws.security.SignatureAuth;
import ru.softlogic.srv.connector.ws.stub.ActivationRequest;
import ru.softlogic.srv.connector.ws.stub.BonusRequest;
import ru.softlogic.srv.connector.ws.stub.BonusResult;
import ru.softlogic.srv.connector.ws.stub.BoxAmount;
import ru.softlogic.srv.connector.ws.stub.BoxAmountRequest;
import ru.softlogic.srv.connector.ws.stub.BoxInfo;
import ru.softlogic.srv.connector.ws.stub.BoxInfoRequest;
import ru.softlogic.srv.connector.ws.stub.BoxStatus;
import ru.softlogic.srv.connector.ws.stub.BoxStatusRequest;
import ru.softlogic.srv.connector.ws.stub.CardGoodsResponse;
import ru.softlogic.srv.connector.ws.stub.CardRequest;
import ru.softlogic.srv.connector.ws.stub.CashBackCardStub;
import ru.softlogic.srv.connector.ws.stub.CashBoxContentStub;
import ru.softlogic.srv.connector.ws.stub.CashBoxStub;
import ru.softlogic.srv.connector.ws.stub.CashTransfer;
import ru.softlogic.srv.connector.ws.stub.CashTransferRequest;
import ru.softlogic.srv.connector.ws.stub.CashUnitStub;
import ru.softlogic.srv.connector.ws.stub.CbcStatusRequest;
import ru.softlogic.srv.connector.ws.stub.CheckCopyRequest;
import ru.softlogic.srv.connector.ws.stub.ChildOperationStub;
import ru.softlogic.srv.connector.ws.stub.ClientPaymentRequest;
import ru.softlogic.srv.connector.ws.stub.CommandResultRequest;
import ru.softlogic.srv.connector.ws.stub.DemandRequest;
import ru.softlogic.srv.connector.ws.stub.DeviceInfoRequest;
import ru.softlogic.srv.connector.ws.stub.DeviceInfoStub;
import ru.softlogic.srv.connector.ws.stub.DeviceStatusRequest;
import ru.softlogic.srv.connector.ws.stub.EventRequest;
import ru.softlogic.srv.connector.ws.stub.FindOperationRequest;
import ru.softlogic.srv.connector.ws.stub.GroupOperationRequest;
import ru.softlogic.srv.connector.ws.stub.GroupOperationStub;
import ru.softlogic.srv.connector.ws.stub.JammRequest;
import ru.softlogic.srv.connector.ws.stub.KeeperStub;
import ru.softlogic.srv.connector.ws.stub.MenuItemStub;
import ru.softlogic.srv.connector.ws.stub.MenuKeyLangStub;
import ru.softlogic.srv.connector.ws.stub.MenuStub;
import ru.softlogic.srv.connector.ws.stub.MoneyCollectionRequest;
import ru.softlogic.srv.connector.ws.stub.MoneyCollectionResponse;
import ru.softlogic.srv.connector.ws.stub.MoneyCollectionStub;
import ru.softlogic.srv.connector.ws.stub.NetworkDeviceRequest;
import ru.softlogic.srv.connector.ws.stub.OperationCopy;
import ru.softlogic.srv.connector.ws.stub.OperationCopyResult;
import ru.softlogic.srv.connector.ws.stub.OperationRequest;
import ru.softlogic.srv.connector.ws.stub.OperationResult;
import ru.softlogic.srv.connector.ws.stub.OperationStub;
import ru.softlogic.srv.connector.ws.stub.PackageHeader;
import ru.softlogic.srv.connector.ws.stub.PointOptionsStub;
import ru.softlogic.srv.connector.ws.stub.ReferencesStub;
import ru.softlogic.srv.connector.ws.stub.RequestStub;
import ru.softlogic.srv.connector.ws.stub.SalesConfirmRequest;
import ru.softlogic.srv.connector.ws.stub.SalesConfirmStub;
import ru.softlogic.srv.connector.ws.stub.ServiceTypeStub;
import ru.softlogic.srv.connector.ws.stub.StatisticsRequest;
import ru.softlogic.srv.connector.ws.stub.SystemInfoRequest;
import ru.softlogic.srv.connector.ws.stub.UpdateState;
import ru.softlogic.srv.connector.ws.stub.VerifyRequest;
import ru.softlogic.srv.connector.ws.stub.advanced.AdvancedResponse;
import ru.softlogic.srv.connector.ws.stub.advanced.Data;
import ru.softlogic.srv.connector.ws.stub.advanced.InputElement;
import ru.softlogic.srv.connector.ws.stub.advanced.RequestData;

public class WSConnector
extends ServerInterface {
    private ProxyConfiguration proxy;
    private SignatureAuth auth;
    private final Logger log = Logger.getLogger((String)"net");
    private int point;
    private final AddressSelector<ServerAddress> addressSelector;
    private static final String PATH = "/ws2/BusinessService";
    private long hwdId;
    private StateWatcher stateWatcher;
    private Producer<String> swVersionProducer;
    private int timeout;
    public static final String tmp = "/u3+7QAAAAIAAAABAAAAAgANc29mdCBsb2dpYyBjYQAAARtN7GFbAAVYLjUwOQAABJYwggSSMIIDeqADAgECAgkAp8csqJnLMqYwDQYJKoZIhvcNAQEFBQAwgYwxCzAJBgNVBAYTAlJVMQ4wDAYDVQQIEwVBbHRhaTEQMA4GA1UEBxMHQmFybmF1bDETMBEGA1UEChMKU29mdCBMb2dpYzELMAkGA1UECxMCSVQxFjAUBgNVBAMTDVNvZnQgTG9naWMgQ0ExITAfBgkqhkiG9w0BCQEWEmluZm9Ac29mdC1sb2dpYy5ydTAeFw0wODA3MjMwMzEzMjlaFw0yODA3MTgwMzEzMjlaMIGMMQswCQYDVQQGEwJSVTEOMAwGA1UECBMFQWx0YWkxEDAOBgNVBAcTB0Jhcm5hdWwxEzARBgNVBAoTClNvZnQgTG9naWMxCzAJBgNVBAsTAklUMRYwFAYDVQQDEw1Tb2Z0IExvZ2ljIENBMSEwHwYJKoZIhvcNAQkBFhJpbmZvQHNvZnQtbG9naWMucnUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDRQmNLYYb5bdexVYNxvTTQxtGoD3InQWII0nyQlwrb+KY0UxQ5sCR7AfCpzuJv/0bs7ONgwfKOXsnj6qwfNSyRIaPQeZ968p1LnFHpvGVcYZnPEDG9A2KlzG4fYZnA+sHXi/shHuJLGErKPFT9Fz4u0dLEURnGlwEN7wvpOMoillS1R8B76tOqv0u3jbNuK+BV9QSDZ+lq5kN+HjqYlZjNnA3Zp/Rz9LGoyq3qEz1X8oWCFeH4mffC6lCNdB8+wwh1ajjso1Gmlqv30yxlFGkAMTMTvv4QgLVgSyNQaDIvgo3FvOD5O4fXotN4lfCRWc5mbVFzTYwZ3/0NkURcfnoXAgMBAAGjgfQwgfEwHQYDVR0OBBYEFGjzUaj8TsLWC3Q7yMACYFnOW5BAMIHBBgNVHSMEgbkwgbaAFGjzUaj8TsLWC3Q7yMACYFnOW5BAoYGSpIGPMIGMMQswCQYDVQQGEwJSVTEOMAwGA1UECBMFQWx0YWkxEDAOBgNVBAcTB0Jhcm5hdWwxEzARBgNVBAoTClNvZnQgTG9naWMxCzAJBgNVBAsTAklUMRYwFAYDVQQDEw1Tb2Z0IExvZ2ljIENBMSEwHwYJKoZIhvcNAQkBFhJpbmZvQHNvZnQtbG9naWMucnWCCQCnxyyomcsypjAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQCyrTuMvWTtrLMkiuTnpGmFeLt/O3QtJpmKLGzGyY4Cb9XoOSx+PL259cvvYCv51+47q1NjhVE/k4mLTh444h9+7P6k6pvNewNmzAXxEUhO44yi/swAiNc4h26GLz/MqOZyYmiglKVXWLcgtHBukwWcTkU7SMWV5vUiJCBvU4lMpbfuuY15x7+S1H2VQ4t8Ph5lIsxWYLn+OL9IzH5lAtgbS6YS+gNMWW8QjtMjgTVPgkOtfV8x1i2fU/X3EPeiwlhH1URVRCd9DNjaXjMGWaydKIqb8VIzQ0P/OTmdlvKz9Vx+XvK2qACphN2i+WbL4l+R2L6iKZumr3dWbquDotZGENMMz4Og0SqQQTEkEwvdY0pY1uo=";

    public WSConnector(ConnConfiguration conf, ProxyConfiguration proxy, long hdwId, int point, StateWatcher stateWatcher, Producer<String> swVersionProducer) throws ConnectorConfigurationException {
        if (conf == null) {
            throw new ConnectorConfigurationException("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
        }
        if (proxy == null) {
            throw new ConnectorConfigurationException("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f proxy \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
        }
        if (stateWatcher == null) {
            throw new ConnectorConfigurationException("StateWatcher");
        }
        if (swVersionProducer == null) {
            throw new ConnectorConfigurationException("swVersionProducer is null");
        }
        this.proxy = proxy;
        this.hwdId = hdwId;
        this.stateWatcher = stateWatcher;
        this.swVersionProducer = swVersionProducer;
        this.point = point;
        this.addressSelector = new AddressSelector();
        this.log.info((Object)("WS proxy=" + System.getProperty("http.proxyHost")));
        System.setProperty("proxySet", "false");
        System.getProperties().remove("http.proxyHost");
        System.getProperties().remove("https.proxyHost");
        System.getProperties().remove("http.proxyPort");
        System.getProperties().remove("https.proxyPort");
        this.log.info((Object)("proxy=" + proxy));
        if (proxy.isUseProxy() && proxy.getProxyHost() != null && proxy.getProxyPort() != null) {
            System.setProperty("proxySet", "true");
            System.setProperty("http.proxyHost", proxy.getProxyHost());
            System.setProperty("https.proxyHost", proxy.getProxyHost());
            System.setProperty("http.proxyPort", proxy.getProxyPort());
            System.setProperty("https.proxyPort", proxy.getProxyPort());
        }
        try {
            this.auth = new SignatureAuth(conf.getPointKey(), conf.getServerKey());
        }
        catch (BasicSecurityException ex) {
            throw new ConnectorConfigurationException(ex);
        }
        ServerAddress[] addresses = References.getServerAddresses();
        if (addresses == null || addresses.length == 0) {
            addresses = new ServerAddress[]{new ServerAddress(conf.getHost(), conf.getHttpsPort(), conf.getHttpPort())};
        }
        for (ServerAddress serverAddress : addresses) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c \u0430\u0434\u0440\u0435\u0441 : " + serverAddress));
            this.addressSelector.addAddress(serverAddress);
        }
        if (conf.getTimeout() > 10 && conf.getTimeout() < 180) {
            this.timeout = conf.getTimeout() * 1000;
            this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0442\u0430\u0439\u043c\u0430\u0443\u0442 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f : " + this.timeout));
            System.setProperty("sun.net.client.defaultConnectTimeout", Integer.toString(this.timeout));
            System.setProperty("sun.net.client.defaultReadTimeout", Integer.toString(this.timeout));
        }
    }

    private BusinessService getBusinessServiceHttp(ServerAddress serverAddress) throws ConnectorException {
        return this.getBusinessService(serverAddress, this.getScheme());
    }

    private BusinessService getBusinessService(ServerAddress serverAddress, String scheme) throws ConnectorException {
        SecurityHandler handler = new SecurityHandler(this.auth);
        BusinessServiceService serviceFactory = new BusinessServiceService(this.getClass().getResource("BusinessService.wsdl"));
        BusinessService service = serviceFactory.getBusinessServicePort();
        List list = ((BindingProvider)service).getBinding().getHandlerChain();
        list.add(handler);
        ((BindingProvider)service).getBinding().setHandlerChain(list);
        if (this.timeout > 0) {
            ((BindingProvider)service).getRequestContext().put("com.sun.xml.internal.ws.connect.timeout", this.timeout);
            ((BindingProvider)service).getRequestContext().put("com.sun.xml.internal.ws.request.timeout", this.timeout);
            ((BindingProvider)service).getRequestContext().put("com.sun.xml.ws.connect.timeout", this.timeout);
            ((BindingProvider)service).getRequestContext().put("com.sun.xml.ws.request.timeout", this.timeout);
        }
        HashMap<String, List<String>> httpHeaders = new HashMap<String, List<String>>();
        httpHeaders.put("Accept-Encoding", Collections.singletonList("gzip"));
        httpHeaders.put("Content-Encoding", Collections.singletonList("gzip"));
        if (this.proxy.isAuthProxy() && this.proxy.getProxyUser() != null && this.proxy.getProxyPassword() != null) {
            String encoded = new String(Base64.encodeBase64((byte[])(this.proxy.getProxyUser() + ":" + this.proxy.getProxyPassword()).getBytes()));
            httpHeaders.put("Proxy-Authorization", Collections.singletonList("Basic " + encoded));
        }
        ((BindingProvider)service).getRequestContext().put("javax.xml.ws.http.request.headers", httpHeaders);
        String s = scheme;
        if ("http".equals(s) && serverAddress.getHttpPort() == 0) {
            s = "https";
        }
        int port = serverAddress.getPort();
        if ("http".equals(s)) {
            port = serverAddress.getHttpPort();
        }
        if ("https".equals(s)) {
            try {
                ((BindingProvider)service).getRequestContext().put("com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory", SSLSocketFactory.getFactory());
                ((BindingProvider)service).getRequestContext().put("com.sun.xml.internal.ws.transport.https.client.hostname.verifier", SSLSocketFactory.getVerifier());
            }
            catch (BasicSecurityException ex) {
                throw new ConnectorException(ex);
            }
        }
        ((BindingProvider)service).getRequestContext().put("javax.xml.ws.service.endpoint.address", s + "://" + serverAddress.getIp() + ":" + port + PATH);
        this.log.info((Object)("URL: " + s + "://" + serverAddress.getIp() + ":" + port + PATH));
        return service;
    }

    @Override
    public boolean sendEvents(Event[] event) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            EventRequest request = new EventRequest();
            request.setEvents(event);
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            boolean result = service.events(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.notifyStatus(true);
            this.addressSelector.updateState(serverAddress, true);
            this.log.error((Object)("Web service exception, error count " + this.addressSelector.getErrorCount(serverAddress)));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.notifyStatus(true);
            this.addressSelector.updateState(serverAddress, true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendStatuses(DeviceStatus[] deviceStatus) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            DeviceStatusRequest request = new DeviceStatusRequest();
            request.setStatuses(deviceStatus);
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            boolean result = service.statusesNg(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendDeviceInfo(DeviceInfoStub[] deviceInfos) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            DeviceInfoRequest request = new DeviceInfoRequest();
            request.setDeviceInfos(deviceInfos);
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            boolean result = service.infosNg(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendMoneyCollection(MoneyCollection[] moneyCollection) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            MoneyCollectionRequest request = new MoneyCollectionRequest();
            MoneyCollectionStub[] stubs = new MoneyCollectionStub[moneyCollection.length];
            for (int i = 0; i < moneyCollection.length; ++i) {
                MoneyCollection mc = moneyCollection[i];
                HashMap<CashUnitStub, Integer> cuStubs = new HashMap<CashUnitStub, Integer>();
                for (CashUnit cu : mc.getKeeper().getCashUnits().keySet()) {
                    cuStubs.put(new CashUnitStub(cu.getNominal(), cu.getId(), cu.getType()), (Integer)moneyCollection[i].getKeeper().getCashUnits().get(cu));
                }
                stubs[i] = new MoneyCollectionStub(mc.getId(), mc.getDate(), mc.getLastDate(), mc.getDeviceClass(), mc.getDeviceNum(), mc.getBoxNum(), mc.getType(), mc.getMenuUser() == null ? null : Short.valueOf(mc.getMenuUser().getId()), cuStubs);
            }
            request.setMoneyCollections(stubs);
            BusinessService service = this.getBusinessService(serverAddress, "https");
            boolean result = service.moneyCollectionNg(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendStatistics(Statistics[] statistics) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            StatisticsRequest request = new StatisticsRequest();
            request.setStatistics(statistics);
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            boolean result = service.statistics(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendAdvStatistics(AdvStatistic[] statistics) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            AdvStatisticRequest request = new AdvStatisticRequest();
            request.setStatistics(statistics);
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            boolean result = service.advStatistic(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean process(Operation[] operations) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            OperationRequest request = new OperationRequest();
            OperationStub[] stubs = new OperationStub[operations.length];
            for (int i = 0; i < operations.length; ++i) {
                stubs[i] = this.getOperationStub(operations[i]);
            }
            request.setOperations(stubs);
            String scheme = "https";
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.operations(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public OperationState[] processWithResult(Operation[] operations) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            OperationRequest request = new OperationRequest();
            OperationStub[] stubs = new OperationStub[operations.length];
            for (int i = 0; i < operations.length; ++i) {
                stubs[i] = this.getOperationStub(operations[i]);
            }
            request.setOperations(stubs);
            String scheme = "https";
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            OperationResult result = service.operationsWithResult(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result.getResults() == null ? new OperationState[]{} : result.getResults();
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public ProcessingResult process(Operation operation) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            OperationStub request = this.getOperationStub(operation);
            String scheme = "https";
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            ProcessingResult result = service.operation(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public ActivationResult acivateCashBackCard(String pin, Sum sum, Sum maxSum, int activationNumber) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            ActivationRequest request = new ActivationRequest(pin, sum, maxSum, activationNumber);
            BusinessService service = this.getBusinessService(serverAddress, "https");
            ActivationResult result = service.activation(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public VerifyResult verify(Service s, Map<String, String> form) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            VerifyRequest request = new VerifyRequest();
            request.setForm(form);
            request.setIdService(s.getId());
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            VerifyResult result = service.verify(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public CardCover[] getCardCovers(Service s) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            CardGoodsResponse result = service.cardGoods(s.getId(), holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result.getGoods() == null ? new CardCover[]{} : result.getGoods();
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public CardOperation processCard(Operation payment, CardCover cardCover) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            CardRequest request = new CardRequest(this.getOperationStub(payment), cardCover);
            BusinessService service = this.getBusinessService(serverAddress, "https");
            CardOperation result = service.cards(request, holder);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.notifyStatus(false);
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean registerSales(SaleConfirm[] confirms) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            SalesConfirmRequest request = new SalesConfirmRequest();
            SalesConfirmStub[] stubs = new SalesConfirmStub[confirms.length];
            for (int i = 0; i < confirms.length; ++i) {
                stubs[i] = new SalesConfirmStub(this.getOperationStub(confirms[i].getOperation()), confirms[i].getCardOperation().getCid());
            }
            request.setConfirms(stubs);
            BusinessService service = this.getBusinessService(serverAddress, "https");
            boolean result = service.registerSales(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public SrvReferences getReferences() throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            MenuStub menuStub;
            int i;
            Holder<PackageHeader> holder = this.createHolder();
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            ReferencesStub result = service.references(0, holder);
            this.notifyStatus(false);
            SrvReferences ref = new SrvReferences();
            ref.setVersion(result.getVersion());
            ref.setDealer(result.getDealer());
            ref.setPoint(result.getPoint());
            ref.setServiceOptions(result.getServiceOptions());
            ref.setMenuItemStates(result.getMenuItemStates());
            ref.setBanners(result.getBanners());
            ref.setMovies(result.getMovies());
            ref.setPromos(result.getPromo());
            ref.setBonuses(result.getBonus());
            ref.setCheckAdvs(result.getCheckAdvs());
            ref.setCommands(result.getCommands());
            ref.setAuth(result.getAuth());
            ref.setUpdateOptions(result.getUpdateOptions());
            ref.setBank(result.getBank());
            ref.setPaymentSystem(result.getPaymentSystem());
            ref.setServerAddresses(result.getServerAddresses());
            ref.setServerUsers(result.getSecretMenuUsers());
            ref.setCurrencyRates(result.getCurrencyRates());
            ref.setWeather(result.getWeather());
            ref.setExchangeProfile(WSHelper.convert(result.getExchangeProfile()));
            ref.setDispenseProfile(WSHelper.convert(result.getDispenseProfile()));
            ref.setFraudControlRules(WSHelper.creatFCRS(result.getFraudControlRules()));
            ref.setGeographicAreas(WSHelper.creatGA(result.getGeographicAreas()));
            if (result.getPointOptions() != null) {
                CashUnit[] units;
                PointOptionsStub pos = result.getPointOptions();
                CashUnitStub[] stubs = result.getPointOptions().getUnits();
                if (stubs != null && stubs.length > 0) {
                    units = new CashUnit[stubs.length];
                    for (i = 0; i < stubs.length; ++i) {
                        units[i] = new CashUnit(stubs[i].getId(), stubs[i].getNominal(), stubs[i].getType());
                    }
                } else {
                    units = new CashUnit[]{};
                }
                ref.setPointOptions(new PointOptions(pos.getQueueSize(), pos.getQueueTimeout(), pos.getQueueScanTimeout(), pos.isPlaySound(), units, pos.isShowCommission(), pos.isShowOutcome(), pos.isPaperWarning(), pos.getTransportType()));
                ref.getPointOptions().setBalanceTimeout(pos.getBalanceTimeout());
                ref.getPointOptions().setUseNightMode(pos.isUseNightMode());
                ref.getPointOptions().setLanguage(pos.getLanguage());
                ref.getPointOptions().setLanguages(pos.getLanguages());
                ref.getPointOptions().setCollectionStrategy(pos.getCollectionStrategy());
                ref.getPointOptions().setCollectionStrategy2(pos.getCollectionStrategy2());
                ref.getPointOptions().setWorkWithBrokenFiscal(pos.isWorkWithBrokenFiscal());
                ref.getPointOptions().setUseFiscalDepartments(pos.isUseFiscalDepartments());
                ref.getPointOptions().setCheckRender(pos.getCheckRender());
                ref.getPointOptions().setInkassRender(pos.getInkassRender());
                ref.getPointOptions().setDisconnectTimeout(pos.getDisconnectTimeout());
                ref.getPointOptions().setConnectTimeout(pos.getConnectTimeout());
                ref.getPointOptions().setRebootTimeout(pos.getRebootTimeout());
                ref.getPointOptions().setGuiMenuTimeout(pos.getGuiMenuTimeout());
                ref.getPointOptions().setGuiProcessTimeout(pos.getGuiProcessTimeout());
                ref.getPointOptions().setMaxPackageSize(pos.getMaxPackageSize());
                ref.getPointOptions().setShowCashback(pos.isShowCashback());
                ref.getPointOptions().setCheckTouchScreen(pos.isCheckTouchScreen());
                ref.getPointOptions().setPrintZreportWhileBufferIsFull(pos.isPrintZreportWhileBufferIsFull());
                ref.getPointOptions().setPrintZreportWhileBufferIsNotSupported(pos.isPrintZreportWhileBufferIsNotSupported());
                ref.getPointOptions().setChangeCoinLimit(pos.getChangeCoinLimit());
                ref.getPointOptions().setChangeRestLimit(pos.getChangeRestLimit());
                ref.getPointOptions().setChangeRestPercent(Integer.valueOf(pos.getChangeRestPercent()));
                ref.getPointOptions().setNotConnectedMinute(pos.getNotConnectedMinute());
                ref.getPointOptions().setNotConnectedTry(pos.getNotConnectedTry());
                ref.getPointOptions().setNotPaymentRebootTimeout(pos.getNotPaymentRebootTimeout());
                ref.getPointOptions().setCashUnitProfile(WSHelper.convert(pos.getCashUnitProfile()));
                ref.getPointOptions().setLockingActions(pos.getLockingActions());
            }
            if ((menuStub = result.getMenuItems()) == null) {
                ref.setMenu(null);
            } else {
                Menu menu = new Menu();
                menu.setIclass(menuStub.getIclass());
                menu.setIface(menuStub.getIface());
                menu.setMenuDesign(menuStub.getMenuDesign());
                if (menuStub.getMenuKeys() != null) {
                    MenuKey[] mks = new MenuKey[menuStub.getMenuKeys().length];
                    for (i = 0; i < menuStub.getMenuKeys().length; ++i) {
                        mks[i] = new MenuKey();
                        mks[i].setIdMenuItem(menuStub.getMenuKeys()[i].getIdMenuItem());
                        mks[i].setIdServiceType(menuStub.getMenuKeys()[i].getIdServiceType());
                        mks[i].setName(menuStub.getMenuKeys()[i].getName());
                        mks[i].setLogo(menuStub.getMenuKeys()[i].getLogo());
                        mks[i].setScreenType(menuStub.getMenuKeys()[i].getScreenType());
                        if (menuStub.getMenuKeys()[i].getLangs() != null && !menuStub.getMenuKeys()[i].getLangs().isEmpty()) {
                            HashMap langs = new HashMap();
                            for (Map.Entry<String, MenuKeyLangStub> l : menuStub.getMenuKeys()[i].getLangs().entrySet()) {
                                MenuKeyLang menuKeyLang = new MenuKeyLang();
                                menuKeyLang.setLang(l.getValue().getLang());
                                menuKeyLang.setName(l.getValue().getName());
                                langs.put(l.getKey(), menuKeyLang);
                            }
                            mks[i].setLangs((Map)langs);
                        }
                        mks[i].setFlags(menuStub.getMenuKeys()[i].getFlags());
                    }
                    menu.setMenuKeys(mks);
                }
                menu.setScreenType(menuStub.getScreenType());
                if (menuStub.getTypes() != null) {
                    ServiceType[] st = new ServiceType[menuStub.getTypes().length];
                    i = 0;
                    for (ServiceTypeStub sts : menuStub.getTypes()) {
                        st[i] = new ServiceType();
                        this.loadChildTypes(st[i], sts);
                        ++i;
                    }
                    menu.setTypes(st);
                }
                menu.setServiceRotationInterval(menuStub.getServiceRotationInterval());
                ref.setMenu(menu);
            }
            ref.setPersonalNumbers(result.getPersonalNumbers());
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            if (ref.getBanners() != null && ref.getBanners().length > 0) {
                this.notifyBanners(ref.getBanners());
            }
            if (ref.getMovies() != null && ref.getMovies().length > 0) {
                this.notifyBanners(ref.getBanners());
            }
            if (result.getChanged() != null && result.getChanged().length > 0) {
                MenuItem[] changed = new MenuItem[result.getChanged().length];
                for (int j = 0; j < result.getChanged().length; ++j) {
                    MenuItemStub src = result.getChanged()[j];
                    changed[j] = new MenuItem();
                    changed[j].setCommission(src.getCommission());
                    changed[j].setIdMenuItem(src.getIdMenuItem());
                    changed[j].setHotkeyPosition(src.getHotkeyPosition());
                    changed[j].setFlags(src.getFlags());
                    changed[j].setSortOrder(src.getSortOrder());
                    changed[j].setService(src.getService());
                    changed[j].setHideUnactive(src.isHideUnactive());
                    changed[j].setSchedules(src.getSchedules());
                    if (src.getUnits() != null) {
                        CashUnitStub[] stubs = src.getUnits();
                        CashUnit[] units = new CashUnit[stubs.length];
                        for (int k = 0; k < stubs.length; ++k) {
                            units[k] = new CashUnit(stubs[k].getId(), stubs[k].getNominal(), stubs[k].getType());
                        }
                        changed[j].setUnits(units);
                    }
                    changed[j].setIgnoreMinMaxCommission(src.isIgnoreMinMaxCommission());
                    changed[j].setServiceMaskFilename(src.getServiceMaskFilename());
                    changed[j].setLogoAlt(src.getLogoAlt());
                    changed[j].setCashUnitProfile(WSHelper.convert(src.getCashUnitProfile()));
                }
                ref.setChanged(changed);
            }
            this.addressSelector.updateState(serverAddress, false);
            return ref;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    public void loadChildTypes(ServiceType to, ServiceTypeStub from) {
        to.setId(from.getId());
        to.setImage(from.getImage());
        to.setLangs(from.getLangs());
        to.setName(from.getName());
        to.setHotkeyPosition(from.getHotkeyPosition());
        to.setInvitation(from.getInvitation());
        to.setSortOrder(from.getSortOrder());
        to.setScreenType(from.getScreenType());
        to.setBlocked(from.getBlocked());
        to.setDesc(from.getDesc());
        to.setStyle(from.getStyle());
        to.setLabel(from.getLabel());
        to.setHidden(from.isHidden());
        MenuItem[] mItems = new MenuItem[]{};
        if (from.getMenuItems() != null) {
            mItems = new MenuItem[from.getMenuItems().length];
            for (int j = 0; j < mItems.length; ++j) {
                mItems[j] = new MenuItem();
                mItems[j].setIdMenuItem(from.getMenuItems()[j].getIdMenuItem());
                mItems[j].setCommission(from.getMenuItems()[j].getCommission());
                mItems[j].setHotkeyPosition(from.getMenuItems()[j].getHotkeyPosition());
                mItems[j].setFlags(from.getMenuItems()[j].getFlags());
                mItems[j].setSortOrder(from.getMenuItems()[j].getSortOrder());
                mItems[j].setHideUnactive(from.getMenuItems()[j].isHideUnactive());
                mItems[j].setSchedules(from.getMenuItems()[j].getSchedules());
                mItems[j].setService(from.getMenuItems()[j].getService());
                mItems[j].setServiceType(to);
                if (from.getMenuItems()[j].getUnits() != null) {
                    CashUnitStub[] stubs = from.getMenuItems()[j].getUnits();
                    CashUnit[] units = new CashUnit[stubs.length];
                    for (int k = 0; k < stubs.length; ++k) {
                        units[k] = new CashUnit(stubs[k].getId(), stubs[k].getNominal(), stubs[k].getType());
                    }
                    mItems[j].setUnits(units);
                }
                mItems[j].setIgnoreMinMaxCommission(from.getMenuItems()[j].isIgnoreMinMaxCommission());
                mItems[j].setServiceMaskFilename(from.getMenuItems()[j].getServiceMaskFilename());
                mItems[j].setLogoAlt(from.getMenuItems()[j].getLogoAlt());
                mItems[j].setCashUnitProfile(WSHelper.convert(from.getMenuItems()[j].getCashUnitProfile()));
            }
        }
        to.setMenuItems(mItems);
        ServiceType[] st = new ServiceType[]{};
        if (from.getTypes() != null && from.getTypes().length > 0) {
            st = new ServiceType[from.getTypes().length];
            int i = 0;
            for (ServiceTypeStub sts : from.getTypes()) {
                st[i] = new ServiceType();
                this.loadChildTypes(st[i], sts);
                ++i;
            }
        }
        to.setTypes(st);
    }

    @Override
    public Date ping() throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            BusinessService service = this.getBusinessService(serverAddress, "http");
            boolean result = service.ping(1, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return ((PackageHeader)holder.value).getServerDate();
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    private List<CashBoxStub> convert(Map<BoxId, List<CashBoxContent>> boxContent) {
        ArrayList<CashBoxStub> cashBoxs = new ArrayList<CashBoxStub>();
        for (Map.Entry<BoxId, List<CashBoxContent>> entry : boxContent.entrySet()) {
            BoxId boxId = entry.getKey();
            ArrayList<CashBoxContentStub> contentStub = new ArrayList<CashBoxContentStub>();
            for (CashBoxContent content : entry.getValue()) {
                CashUnit cu = content.getCashUnit();
                CashUnitStub cuStub = new CashUnitStub(cu.getNominal(), cu.getId(), cu.getType());
                contentStub.add(new CashBoxContentStub(cuStub, content.getCashUnitCount()));
            }
            CashBoxStub cashBoxStub = new CashBoxStub(boxId.getDeviceClass(), boxId.getDeviceNumber(), boxId.getBoxNumber(), contentStub);
            cashBoxs.add(cashBoxStub);
        }
        return cashBoxs;
    }

    private OperationStub getOperationStub(Operation operation) {
        OperationStub request = new OperationStub();
        request.setFeHash(operation.getFeHash());
        KeeperStub keeper = new KeeperStub();
        keeper.setSum(operation.getKeeper().getSum());
        List<CashBackCardStub> cbcStubs = keeper.getCashBackCards();
        for (CashBackCard cbc : operation.getKeeper().getCashBackCards()) {
            cbcStubs.add(new CashBackCardStub(cbc.getNominal(), cbc.getId(), cbc.getRef()));
        }
        Map<CashUnitStub, Integer> cuStubs = keeper.getCashUnits();
        Map cashUnits = operation.getKeeper().getCashUnits();
        for (Map.Entry entry : cashUnits.entrySet()) {
            CashUnit cu = (CashUnit)entry.getKey();
            cuStubs.put(new CashUnitStub(cu.getNominal(), cu.getId(), cu.getType()), (Integer)entry.getValue());
        }
        keeper.setCashBoxes(this.convert(operation.getKeeper().getCashBoxes()));
        if (operation.getChange() != null) {
            KeeperStub change = new KeeperStub();
            change.setSum(operation.getChange().getSum());
            cbcStubs = change.getCashBackCards();
            for (Object cbc : operation.getChange().getCashBackCards()) {
                cbcStubs.add(new CashBackCardStub(cbc.getNominal(), cbc.getId(), cbc.getRef()));
            }
            cuStubs = change.getCashUnits();
            Map map = operation.getChange().getCashUnits();
            for (Map.Entry entry : map.entrySet()) {
                CashUnit cu = (CashUnit)entry.getKey();
                cuStubs.put(new CashUnitStub(cu.getNominal(), cu.getId(), cu.getType()), (Integer)entry.getValue());
            }
            change.setCashBoxes(this.convert(operation.getChange().getCashBoxes()));
            request.setChange(change);
        }
        request.setCheckNumber(operation.getCheckNumber());
        request.setDate(operation.getDate());
        request.setChangeDate(operation.getChangeDate());
        if (operation.getInputElements() != null) {
            LinkedList<InputElement> ies = new LinkedList<InputElement>();
            for (ru.softlogic.input.model.InputElement ie : operation.getInputElements().values()) {
                ies.add(this.createIeStubFromIe(ie));
            }
            request.getInputElements().addAll(ies);
        }
        request.setForm(operation.getForm());
        request.setViews(operation.getViews());
        request.setTitles(operation.getTitles());
        request.setPaymentTool(operation.getPaymentTool());
        request.setCashlessData(operation.getCashlessData());
        request.setFlags(operation.getFlags());
        if (operation.getCommission() == null) {
            request.setIdCommission(1);
            this.log.error((Object)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u044f");
        } else {
            request.setIdCommission(operation.getCommission().getId());
        }
        request.setIdOperation(operation.getIdOperation());
        request.setIdService(operation.getService().getId());
        request.setKeeper(keeper);
        request.setPinCode(operation.getPinCode());
        request.setPinCodeNominal(operation.getPinCodeNominal());
        request.setSumResult(operation.getSumResult());
        return request;
    }

    @Override
    public boolean sendModemState(ModemState state) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            boolean result = service.modem(state, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendNetworkDevices(NetworkDevice[] devices) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            NetworkDeviceRequest request = new NetworkDeviceRequest();
            request.setDevices(devices);
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            boolean result = service.networks(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean commandConfirm(CommandResult[] commandResults) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            CommandResultRequest request = new CommandResultRequest();
            for (CommandResult commandResult : commandResults) {
                if (commandResult.getComment() == null) continue;
                commandResult.setComment(commandResult.getComment().replace("\r", "").replace("\n", ""));
            }
            request.setCommands(commandResults);
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            boolean result = service.commands(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean demand(Demand[] demands) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            DemandRequest request = new DemandRequest();
            request.setDemands(demands);
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            boolean result = service.demand(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendSpace(int space) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            boolean result = service.space(space, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendJamm(JammInfo[] info) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            JammRequest request = new JammRequest();
            request.setInfos(info);
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            boolean result = service.jamm(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public RequestResult request(Service service, Map<String, String> form) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            RequestStub request = new RequestStub();
            request.setForm(form);
            request.setSid(service.getId());
            BusinessService serv = this.getBusinessService(serverAddress, "https");
            RequestResult result = serv.orequest(request, holder);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.notifyStatus(false);
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public long getBalance(short idPerson) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            long result = service.balance(idPerson, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public MoneyCollection[] getCollections() throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            MoneyCollectionResponse result = service.getCollectionsNg(1, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            if (result == null || result.getMoneyCollections() == null || result.getMoneyCollections().length == 0) {
                return new MoneyCollection[0];
            }
            MoneyCollection[] res = new MoneyCollection[result.getMoneyCollections().length];
            for (int i = 0; i < res.length; ++i) {
                Keeper k = new Keeper();
                MoneyCollectionStub mcs = result.getMoneyCollections()[i];
                Map<CashUnitStub, Integer> cu = mcs.getUnits();
                for (Map.Entry<CashUnitStub, Integer> entry : cu.entrySet()) {
                    CashUnitStub cus = entry.getKey();
                    CashUnit cahsUnit = new CashUnit(cus.getId(), cus.getNominal(), cus.getType());
                    k.addCash(new BoxId(mcs.getDeviceClass().shortValue(), mcs.getDeviceNumber().shortValue(), mcs.getBoxNumber().shortValue()), cahsUnit, entry.getValue().intValue());
                }
                res[i] = new MoneyCollection(mcs.getId(), mcs.getLastDate(), mcs.getDate(), k, mcs.getDeviceClass() != null ? mcs.getDeviceClass() : (short)0, mcs.getDeviceNumber() != null ? mcs.getDeviceNumber() : (short)0, mcs.getBoxNumber() != null ? mcs.getBoxNumber() : (short)0, null, mcs.getType());
            }
            return res;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public FindOperationResult findOperation(Short point, Integer checkNumber, String date, String account, int sum) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            FindOperationRequest req = new FindOperationRequest();
            req.setPoint(point);
            req.setAccount(account);
            req.setCheck(checkNumber);
            req.setDate(date);
            req.setSum(sum);
            FindOperationResult result = service.getOperations(req, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean processGroup(GroupOperation[] operations) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PointOptions po;
            Holder<PackageHeader> holder = this.createHolder();
            GroupOperationRequest request = new GroupOperationRequest();
            GroupOperationStub[] stubs = new GroupOperationStub[operations.length];
            boolean sslFlag = false;
            for (int i = 0; i < operations.length; ++i) {
                stubs[i] = this.getGroupOperationStub(operations[i]);
                if (stubs[i].getPinCode() == null || stubs[i].getPinCode().isEmpty()) continue;
                sslFlag = true;
            }
            request.setOperations(stubs);
            String scheme = "https";
            if (!sslFlag && (po = References.getPointOptions()) != null && po.getTransportType() == TransportType.Http) {
                scheme = "http";
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.groupOperations(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    private GroupOperationStub getGroupOperationStub(GroupOperation operation) {
        GroupOperationStub request = new GroupOperationStub();
        request.setFeHash(operation.getFeHash());
        KeeperStub keeper = new KeeperStub();
        List<CashBackCardStub> cbcStubs = keeper.getCashBackCards();
        Map<CashUnitStub, Integer> cuStubs = keeper.getCashUnits();
        keeper.setSum(operation.getKeeper().getSum());
        for (Object cbc : operation.getKeeper().getCashBackCards()) {
            cbcStubs.add(new CashBackCardStub(cbc.getNominal(), cbc.getId(), cbc.getRef()));
        }
        Map cashUnits = operation.getKeeper().getCashUnits();
        for (Map.Entry entry : cashUnits.entrySet()) {
            CashUnit cu = (CashUnit)entry.getKey();
            cuStubs.put(new CashUnitStub(cu.getNominal(), cu.getId(), cu.getType()), (Integer)entry.getValue());
        }
        keeper.setCashBoxes(this.convert(operation.getKeeper().getCashBoxes()));
        if (operation.getChange() != null) {
            KeeperStub change = new KeeperStub();
            change.setSum(operation.getChange().getSum());
            cbcStubs = change.getCashBackCards();
            for (Object cbc : operation.getChange().getCashBackCards()) {
                cbcStubs.add(new CashBackCardStub(cbc.getNominal(), cbc.getId(), cbc.getRef()));
            }
            cuStubs = change.getCashUnits();
            Map map = operation.getChange().getCashUnits();
            for (Map.Entry entry : map.entrySet()) {
                CashUnit cu = (CashUnit)entry.getKey();
                cuStubs.put(new CashUnitStub(cu.getNominal(), cu.getId(), cu.getType()), (Integer)entry.getValue());
            }
            change.setCashBoxes(this.convert(operation.getChange().getCashBoxes()));
            request.setChange(change);
        }
        request.setCheckNumber(operation.getCheckNumber());
        request.setDate(operation.getDate());
        if (operation.getInputElements() != null) {
            LinkedList<InputElement> ies = new LinkedList<InputElement>();
            for (ru.softlogic.input.model.InputElement ie : operation.getInputElements().values()) {
                ies.add(this.createIeStubFromIe(ie));
            }
            request.getInputElements().addAll(ies);
        }
        request.setForm(operation.getForm());
        request.setTitles(operation.getTitles());
        request.setViews(operation.getViews());
        if (operation.getCommission() == null) {
            request.setIdCommission(1);
            this.log.error((Object)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u044f");
        } else {
            request.setIdCommission(operation.getCommission().getId());
        }
        request.setIdOperation(operation.getIdOperation());
        request.setIdService(operation.getService().getId());
        request.setKeeper(keeper);
        request.setPinCode(operation.getPinCode());
        request.setSumResult(operation.getSumResult());
        request.setPaymentTool(operation.getPaymentTool());
        if (operation.getChildOperations() != null) {
            ArrayList<ChildOperationStub> childStubs = new ArrayList<ChildOperationStub>(operation.getChildOperations().size());
            for (ChildOperation child : operation.getChildOperations()) {
                ChildOperationStub childOperationStub = new ChildOperationStub(child.getService().getId(), child.getSumOutcome(), child.getForm(), child.getCommission(), child.getIdOperation(), child.getCheckNumber());
                if (child.getInputElements() != null) {
                    LinkedList<InputElement> ies = new LinkedList<InputElement>();
                    for (ru.softlogic.input.model.InputElement ie : child.getInputElements().values()) {
                        ies.add(this.createIeStubFromIe(ie));
                    }
                    childOperationStub.getInputElements().addAll(ies);
                }
                childOperationStub.setTitles(child.getTitles());
                childOperationStub.setViews(child.getViews());
                childStubs.add(childOperationStub);
            }
            request.setChilds(childStubs);
        }
        return request;
    }

    @Override
    public boolean sendNetworkStatistics(NetworkStatistics[] statistics) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            NetworkStatisticsRequest request = new NetworkStatisticsRequest();
            request.setStatistics(statistics);
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            boolean result = service.networkStatistics(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendActivateStatus(CbcStatus[] status) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            CbcStatusRequest req = new CbcStatusRequest();
            req.setStatuses(status);
            boolean result = service.cbcStatus(req, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendUpdateState(ru.softlogic.srv.api.status.UpdateState state) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            UpdateState st = new UpdateState(state.getType(), state.getState());
            boolean result = service.updateState(st, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendEnvRiskFactors(EnvRiskFactors erf) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        try {
            Holder<PackageHeader> holder = this.createHolder();
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            boolean result = service.registrationRiskFactors(erf, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public Operation checkCopy(long idOperation, String pin) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            CheckCopyRequest ccr = new CheckCopyRequest();
            ccr.setIdOperation(idOperation);
            ccr.setPin(pin);
            OperationCopyResult result = service.checkCopy(ccr, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            if (result == null || result.getOperations() == null || result.getOperations().length == 0) {
                return null;
            }
            Operation res = new Operation();
            OperationCopy r = result.getOperations()[0];
            res.setCheckNumber(r.getCheckNumber());
            res.setCommission(r.getCommission());
            res.setIdOperation(r.getIdOperation());
            res.setPinCode(r.getPinCode());
            res.setPinCodeNominal(r.getPinCodeNominal());
            res.setService(r.getService());
            res.setSumResult(r.getSumResult());
            res.setPoint(r.getPoint());
            res.setDealer(r.getDealer());
            res.setDate(r.getDate());
            if (r.getInputElements() != null) {
                for (InputElement ieStub : r.getInputElements()) {
                    ru.softlogic.input.model.InputElement ie = this.createIeFromIeStub(ieStub);
                    res.getInputElements().put(ie.getKey(), ie);
                }
            }
            if (r.getForm() != null) {
                res.getForm().putAll(r.getForm());
            }
            if (r.getTitles() != null) {
                res.getTitles().putAll(r.getTitles());
            }
            if (r.getViews() != null) {
                res.getViews().putAll(r.getViews());
            }
            return res;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public int getPaymentsAmount(String account, int serviceId, Short pointId, int promoId, int sum, Date lastPayment) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            ClientPaymentRequest cpr = new ClientPaymentRequest();
            cpr.setAccount(account);
            cpr.setPoint(pointId == null ? (short)0 : pointId);
            cpr.setSid((short)serviceId);
            cpr.setIdPromo(promoId);
            cpr.setSum(sum);
            cpr.setLastPayment(lastPayment);
            int result = service.clientPayments(cpr, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public BonusResult registerBonus(String account, int idBonus, int sum, Date lastPayment) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            BonusRequest cpr = new BonusRequest();
            cpr.setAccount(account);
            cpr.setIdBonus(idBonus);
            cpr.setSum(sum);
            cpr.setLastPayment(lastPayment);
            BonusResult result = service.registerBonus(cpr, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public int useBonus(String account) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            int result = service.useBonus(account, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    public Response<ru.softlogic.input.model.Data> request(ru.softlogic.input.model.advanced.actions.request.RequestData data) throws ru.softlogic.input.model.advanced.actions.request.ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 advanced \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            RequestData rd = new RequestData();
            rd.setServiceId(data.getIdService());
            rd.setParams(data.getParams());
            rd.setFunction(data.getFunction());
            rd.setProviderId(data.getIdProvider());
            Holder<PackageHeader> holder = this.createHolder();
            BusinessService serv = this.getBusinessService(serverAddress, "https");
            AdvancedResponse result = serv.arequest(rd, holder);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.notifyStatus(false);
            this.addressSelector.updateState(serverAddress, false);
            ru.softlogic.input.model.Data dest = null;
            if (result != null) {
                if (result.getData() != null) {
                    dest = new ru.softlogic.input.model.Data();
                    this.fillData(dest, result.getData());
                }
            } else {
                throw new ConnectorException("Advanced response is null.");
            }
            return new Response(result.getServerError(), result.getServiceError(), (Object)dest);
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ru.softlogic.input.model.advanced.actions.request.ConnectorException((Throwable)ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ru.softlogic.input.model.advanced.actions.request.ConnectorException((Throwable)ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ru.softlogic.input.model.advanced.actions.request.ConnectorException((Throwable)ex);
        }
    }

    private void fillData(ru.softlogic.input.model.Data dest, Data source) {
        dest.setElements(new LinkedList());
        if (source.getElements() != null) {
            for (InputElement ie : source.getElements()) {
                dest.getElements().add(this.createIeFromIeStub(ie));
            }
        }
        if (source.getSum() != null) {
            dest.setSum(new TransactionSum(source.getSum().getSum()));
        }
        if (source.getData() != null) {
            NestedData nd = new NestedData();
            nd.setId(source.getData().getId());
            nd.setData(new LinkedList());
            if (source.getData().getData() != null) {
                for (Data newSource : source.getData().getData()) {
                    ru.softlogic.input.model.Data newDest = new ru.softlogic.input.model.Data();
                    this.fillData(newDest, newSource);
                    nd.getData().add(newDest);
                }
            }
            dest.setNestedData(nd);
        }
        if (source.getFeeSum() != null) {
            FeeSum feeSum = new FeeSum();
            feeSum.setFee(source.getFeeSum().getFee());
            feeSum.setFeeName(source.getFeeSum().getFeeName());
            feeSum.setFeePercent(source.getFeeSum().getFeePercent());
            dest.setFeeSum(feeSum);
        }
    }

    @Override
    public boolean sendBoxInfos(BoxInfo[] infos) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            BoxInfoRequest request = new BoxInfoRequest();
            request.setBoxInfos(infos);
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            boolean result = service.boxInfo(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendBoxAmounts(BoxAmount[] amounts) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            BoxAmountRequest request = new BoxAmountRequest();
            request.setBoxAmounts(amounts);
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            boolean result = service.boxAmount(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendBoxStatuses(BoxStatus[] statuses) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            BoxStatusRequest request = new BoxStatusRequest();
            request.setBoxStatuses(statuses);
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            boolean result = service.boxStatus(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendTransfers(CashTransfer[] transfers) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            Holder<PackageHeader> holder = this.createHolder();
            CashTransferRequest request = new CashTransferRequest();
            request.setTransfers(transfers);
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            boolean result = service.cashTransfers(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendSystemInfo(SystemInfo[] infos) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            SystemInfoRequest request = new SystemInfoRequest();
            request.setInfos(infos);
            Holder<PackageHeader> holder = this.createHolder();
            BusinessService service = this.getBusinessServiceHttp(serverAddress);
            boolean result = service.systemInfo(request, holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    private Holder<PackageHeader> createHolder() {
        Holder holder = new Holder((Object)this.createHeader());
        return holder;
    }

    private PackageHeader createHeader() {
        PackageHeader header = new PackageHeader();
        header.setPoint(this.point);
        header.setSignature("sign");
        header.setReferenceVersion(References.getVersion());
        header.setTerminalState(this.stateWatcher.getCurrentState());
        header.setHwCode(this.hwdId);
        header.setVersion(this.swVersionProducer.get());
        return header;
    }

    private String getScheme() {
        PointOptions po = References.getPointOptions();
        if (po != null && (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations)) {
            return "http";
        }
        return "https";
    }

    private ru.softlogic.input.model.InputElement createIeFromIeStub(InputElement ieStub) {
        ru.softlogic.input.model.InputElement ie = new ru.softlogic.input.model.InputElement();
        ie.setFlags(ieStub.getFlags() == null ? 0 : ieStub.getFlags());
        ie.setKey(ieStub.getKey());
        ie.setKeyTitle(ieStub.getKeyTitle());
        ie.setOriginalValue(ieStub.getOriginalValue() != null ? ieStub.getOriginalValue() : ieStub.getValue());
        ie.setValue(ieStub.getValue());
        ie.setValueTitle(ieStub.getValueTitle());
        return ie;
    }

    private InputElement createIeStubFromIe(ru.softlogic.input.model.InputElement ie) {
        InputElement ieStub = new InputElement();
        ieStub.setFlags(ie.getFlags());
        ieStub.setKey(this.clearEscapeSequences(ie.getKey()));
        ieStub.setKeyTitle(this.clearEscapeSequences(ie.getKeyTitle()));
        ieStub.setOriginalValue(this.clearEscapeSequences(ie.getOriginalValue()));
        ieStub.setValue(this.clearEscapeSequences(ie.getValue()));
        ieStub.setValueTitle(this.clearEscapeSequences(ie.getValueTitle()));
        return ieStub;
    }

    private String clearEscapeSequences(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return s.replace("\t", "").replace("\n", "").replace("\r", "");
    }
}

