/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.connector.selector;

import java.util.LinkedList;
import java.util.List;
import ru.softlogic.srv.connector.selector.AddressState;

public class AddressSelector<V> {
    private final List<AddressState<V>> addrs = new LinkedList<AddressState<V>>();

    public synchronized void addAddress(V address) {
        if (address == null) {
            return;
        }
        this.addrs.add(new AddressState<V>(address));
    }

    public synchronized void updateState(V address, boolean networkError) {
        if (address != null) {
            for (AddressState<V> state : this.addrs) {
                if (!state.getAddress().equals(address)) continue;
                state.updateState(networkError);
                break;
            }
        }
    }

    public synchronized V getAddress() {
        if (this.addrs == null || this.addrs.isEmpty()) {
            return null;
        }
        AddressState<V> onFail = null;
        for (AddressState<V> state : this.addrs) {
            if (state.getErrCount() < 5) {
                return state.getAddress();
            }
            if (onFail != null && state.getDate() >= onFail.getDate()) continue;
            onFail = state;
        }
        return onFail.getAddress();
    }

    public synchronized int getSize() {
        return this.addrs.size();
    }

    public synchronized int getErrorCount(V address) {
        if (address != null) {
            for (AddressState<V> state : this.addrs) {
                if (!state.getAddress().equals(address)) continue;
                return state.getErrCount();
            }
        }
        return 0;
    }
}

