/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.connector;

import ru.softlogic.srv.connector.ConnConfiguration;
import ru.softlogic.srv.connector.ConnectorConfigurationException;
import ru.softlogic.srv.connector.ConnectorType;
import ru.softlogic.srv.connector.Producer;
import ru.softlogic.srv.connector.ProxyConfiguration;
import ru.softlogic.srv.connector.ServerInterface;
import ru.softlogic.srv.connector.StateWatcher;
import ru.softlogic.srv.connector.test.TestConnector;
import ru.softlogic.srv.connector.ws.WSConnector;
import ru.softlogic.srv.connector.ws.WSConnectorStub;

public class ConnectorFactory {
    private ConnectorFactory() {
    }

    public static ServerInterface createConnector(ConnectorType type, ConnConfiguration config, ProxyConfiguration proxy, long hdwId, int point, StateWatcher stateWatcher, Producer<String> swVersionProducer) throws ConnectorConfigurationException {
        if (type == null) {
            return null;
        }
        switch (type) {
            case Test: {
                return new TestConnector();
            }
            case WS: {
                if (System.getProperty("test-connector", "false").equals("true")) {
                    return new WSConnectorStub(config, proxy, hdwId, point, stateWatcher, swVersionProducer);
                }
                return new WSConnector(config, proxy, hdwId, point, stateWatcher, swVersionProducer);
            }
        }
        return null;
    }
}

