/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.connector;

import java.util.HashMap;
import java.util.Map;
import ru.softlogic.srv.connector.ConnectorType;

public class ConnectorConfiguration {
    private final ConnectorType type;
    private final Map<String, String> params;
    private final String name;

    public ConnectorConfiguration(String name, ConnectorType type, Map<String, String> params) {
        if (name == null) {
            throw new IllegalArgumentException("Name should not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type should not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("Params should not be null");
        }
        this.name = name;
        this.type = type;
        this.params = params;
    }

    public ConnectorConfiguration(ConnectorConfiguration oth) {
        this.type = oth.type;
        this.params = new HashMap<String, String>(oth.params);
        this.name = oth.name;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public ConnectorType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectorConfiguration other = (ConnectorConfiguration)obj;
        return this.name != null && this.name.equals(other.name);
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 47 * hash + (this.params != null ? this.params.hashCode() : 0);
        hash = 47 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "ConnectorConfiguration{type=" + (Object)((Object)this.type) + "params=" + this.params + "name=" + this.name + '}';
    }
}

