/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.connector;

import java.util.Date;
import java.util.List;
import java.util.Map;
import ru.softlogic.cash.Sum;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.advanced.actions.request.RequestData;
import ru.softlogic.input.model.advanced.actions.request.Response;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.adv.AdvStatistic;
import ru.softlogic.reference.service.ProcessingType;
import ru.softlogic.reference.service.Service;
import ru.softlogic.srv.api.card.CardCover;
import ru.softlogic.srv.api.card.CardOperation;
import ru.softlogic.srv.api.card.SaleConfirm;
import ru.softlogic.srv.api.cbc.ActivationResult;
import ru.softlogic.srv.api.cbc.ActivationResultType;
import ru.softlogic.srv.api.cbc.CbcStatus;
import ru.softlogic.srv.api.command.CommandResult;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.iface.NetworkDevice;
import ru.softlogic.srv.api.modem.ModemState;
import ru.softlogic.srv.api.network.NetworkStatistics;
import ru.softlogic.srv.api.operation.ProcessingResult;
import ru.softlogic.srv.api.operation.ProcessingResultType;
import ru.softlogic.srv.api.oth.Demand;
import ru.softlogic.srv.api.oth.FindOperationResult;
import ru.softlogic.srv.api.oth.JammInfo;
import ru.softlogic.srv.api.oth.MoneyCollection;
import ru.softlogic.srv.api.request.RequestResult;
import ru.softlogic.srv.api.status.DeviceStatus;
import ru.softlogic.srv.api.status.UpdateState;
import ru.softlogic.srv.api.verify.VerifyResult;
import ru.softlogic.srv.cash.Statistics;
import ru.softlogic.srv.connector.ConnectorException;
import ru.softlogic.srv.connector.OnlineInterface;
import ru.softlogic.srv.connector.ServerInterface;
import ru.softlogic.srv.connector.ws.stub.BonusResult;
import ru.softlogic.srv.connector.ws.stub.BoxAmount;
import ru.softlogic.srv.connector.ws.stub.BoxInfo;
import ru.softlogic.srv.connector.ws.stub.BoxStatus;
import ru.softlogic.srv.connector.ws.stub.CashTransfer;
import ru.softlogic.srv.connector.ws.stub.DeviceInfoStub;
import ru.softlogic.srv.queue.Queue;

public class ClientInterface
implements OnlineInterface {
    private ServerInterface si;
    private Queue queue;

    public ClientInterface(ServerInterface serverInterface, Queue queue) {
        if (serverInterface == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 ServerInterface");
        }
        if (queue == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Queue");
        }
        this.si = serverInterface;
        this.queue = queue;
    }

    @Override
    public CardCover[] getCardCovers(Service service) throws ConnectorException {
        return this.si.getCardCovers(service);
    }

    @Override
    public CardOperation processCard(Operation payment, CardCover cardCover) throws ConnectorException {
        return this.si.processCard(payment, cardCover);
    }

    @Override
    public ActivationResult acivateCashBackCard(String pin, Sum sum, Sum maxSum, int activationNumber) throws ConnectorException {
        try {
            ActivationResult res = this.si.acivateCashBackCard(pin, sum, maxSum, activationNumber);
            if (res.getError() == ActivationResultType.Ok) {
                this.queue.putCbcStatus(new CbcStatus(pin, true, res.getRest(), activationNumber));
            }
            return res;
        }
        catch (ConnectorException ex) {
            this.queue.putCbcStatus(new CbcStatus(pin, false, null, activationNumber));
            throw ex;
        }
    }

    @Override
    public ProcessingResult process(Operation operation) throws ConnectorException {
        if (operation == null) {
            return null;
        }
        if (operation.getService().getProcessingType() == null || operation.getService().getProcessingType() == ProcessingType.Offline || operation.getSumResult().getOut().isEmpty() && !operation.hasFlag(1024) || (operation.getFlags() & 0x40) > 0) {
            this.queue.putOperation(operation);
            return new ProcessingResult(ProcessingResultType.Ok);
        }
        ProcessingResult pr = null;
        try {
            pr = this.si.process(operation);
        }
        catch (ConnectorException ex) {
            if (operation.getService().getProcessingType() == ProcessingType.HalfOnline) {
                this.queue.putOperation(operation);
                return new ProcessingResult(ProcessingResultType.Ok);
            }
            throw ex;
        }
        return pr;
    }

    public void sendGroupOperation(GroupOperation operation) {
        if (operation != null) {
            this.queue.putGroupOperation(operation);
        }
    }

    @Override
    public VerifyResult verify(Service service, Map<String, String> form) throws ConnectorException {
        return this.si.verify(service, form);
    }

    public RequestResult request(Service service, Map<String, String> form, boolean online) throws ConnectorException {
        if (online) {
            return this.si.request(service, form);
        }
        RequestResult rr = new RequestResult();
        rr.setError(0);
        return rr;
    }

    public void putOperation(Operation operation) {
        this.queue.putOperation(operation);
    }

    public void sendEvent(Event ... events) {
        this.queue.putEvent(events);
    }

    public void sendModemState(ModemState state) {
        this.queue.putModemState(state);
    }

    public void sendNetworkDevices(NetworkDevice[] devices) {
        this.queue.putNetworkDevices(devices);
    }

    public void sendStatus(DeviceStatus deviceStatus) {
        this.queue.putDeviceStatus(deviceStatus);
    }

    public void sendBoxInfo(BoxInfo boxInfo) {
        this.queue.putBoxInfo(boxInfo);
    }

    public void sendBoxStatus(BoxStatus boxStatus) {
        this.queue.putBoxStatus(boxStatus);
    }

    public void sendBoxAmount(BoxAmount boxAmount) {
        this.queue.putBoxAmounts(boxAmount);
    }

    public void sendMoneyCollection(MoneyCollection mc) {
        this.queue.putMoneyCollection(mc);
    }

    public void sendStatistics(Statistics statistics) {
        this.queue.putStatistics(statistics);
    }

    public void sendCardSaleConfirm(SaleConfirm confirm) {
        this.queue.putSaleConfirm(confirm);
    }

    public void send(DeviceInfoStub deviceInfo) {
        this.queue.putDeviceInfo(deviceInfo);
    }

    public void send(CommandResult commandResult) {
        this.queue.putCommandResult(commandResult);
    }

    public void putDemand(Demand demand) {
        this.queue.putDemand(demand);
    }

    public void putTransfers(List<CashTransfer> transfers) {
        this.queue.putTransfers(transfers);
    }

    public boolean sendServiceDemand(int id, short idService, String text) throws ConnectorException {
        Demand[] d = new Demand[]{new Demand(id, idService, text)};
        return this.si.demand(d);
    }

    public void sendSpace(int space) {
        this.queue.setDiskSpace(space);
    }

    public void sendJamm(JammInfo jammInfo) {
        this.queue.putJamm(jammInfo);
    }

    public void sendNetworStatistics(NetworkStatistics statistics) {
        this.queue.putNetworkStatistics(statistics);
    }

    public void sendUpdateState(UpdateState state) {
        this.queue.putUpdateState(state);
    }

    public void sendAdvStatistics(List<AdvStatistic> advStatistic) {
        this.queue.putAdvStatistics(advStatistic);
    }

    @Override
    public Date ping() throws ConnectorException {
        return this.si.ping();
    }

    @Override
    public long getBalance(short idPerson) throws ConnectorException {
        return this.si.getBalance(idPerson);
    }

    @Override
    public MoneyCollection[] getCollections() throws ConnectorException {
        return this.si.getCollections();
    }

    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public Operation checkCopy(long idOperation, String pin) throws ConnectorException {
        return this.si.checkCopy(idOperation, pin);
    }

    public Response<Data> request(RequestData data) throws ru.softlogic.input.model.advanced.actions.request.ConnectorException {
        return this.si.request(data);
    }

    @Override
    public FindOperationResult findOperation(Short point, Integer checkNumber, String date, String account, int sum) throws ConnectorException {
        return this.si.findOperation(point, checkNumber, date, account, sum);
    }

    @Override
    public int getPaymentsAmount(String account, int serviceId, Short pointId, int promoId, int sum, Date lastPayment) throws ConnectorException {
        return this.si.getPaymentsAmount(account, serviceId, pointId, promoId, sum, lastPayment);
    }

    @Override
    public BonusResult registerBonus(String account, int idBonus, int sum, Date lastPayment) throws ConnectorException {
        return this.si.registerBonus(account, idBonus, sum, lastPayment);
    }

    @Override
    public int useBonus(String account) throws ConnectorException {
        return this.si.useBonus(account);
    }
}

