/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.print;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.core.BaseScreenListener;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.hdw.prt.PrnUtils;
import fxterm.core.launcher.Launcher;
import fxterm.core.menu.GroupByLabelVisitor;
import fxterm.core.menu.MenuByServiceIdVisitor;
import fxterm.core.menu.MenuUtils;
import fxterm.core.menu.MenuVisitor;
import fxterm.core.state.StateFacade;
import fxterm.module.Environment;
import fxterm.module.Intent;
import fxterm.module.Pack;
import fxterm.module.PackUtility;
import fxterm.module.input.InitModuleHelper;
import fxterm.module.stage.print.BasePrintModule;
import fxterm.module.stage.print.ShowcasePrintModuleHelper;
import fxterm.session.Session;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.screen.CommonScreen;
import plfx.screen.Screen;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenStore;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.adv.Banner;
import ru.softlogic.reference.menu.ButtonStatus;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;
import ru.softlogic.reference.service.ServiceType;

public class ShowcasePrintModule
extends BasePrintModule {
    private static final String SCREEN_TYPE = "print";
    protected Logger log = LoggerId.PAY;
    private CommonScreen screen;
    private ScreenListener listener = new LocalScreenListener();
    private Environment env;

    public ShowcasePrintModule() {
        try {
            this.screen = ScreenStore.getCommonScreen((String)SCREEN_TYPE);
            this.screen.setListener(this.listener);
        }
        catch (ScreenCreateException ex) {
            GuiNotifier.notifyProblemOnce((String)("Print module screen create exception -> " + ex.getMessage()));
        }
    }

    protected void _print(Environment environment) {
        this.env = environment;
        this.showScreen(ShowcasePrintModuleHelper.createSD(), new LinkedHashMap<String, Object>());
    }

    public int getInactivityTimeout() {
        return 10;
    }

    public void cancel(Intent intent) {
        this.print(true);
        this.toNextModule();
    }

    public boolean canRedirect() {
        this.log.info((Object)"Request for permission to redirect from ShowcasePintModule");
        return true;
    }

    public void onBannerClicked(Banner banner) {
        if (banner != null && banner.getIdReferService() != null) {
            this.log.info((Object)("Requested redirect to service: " + banner.getIdReferService()));
            MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor(banner.getIdReferService().shortValue());
            MenuUtils.processMenu((MenuVisitor)mbsiv);
            MenuItem mi = mbsiv.getMenuItem();
            if (mi != null) {
                MenuItemState mis = MenuUtils.getState((MenuItem)mi);
                if (mis == null || mis.getButtonStatus() != ButtonStatus.Blocked && mis.getButtonStatus() != ButtonStatus.Hidden) {
                    this.log.info((Object)("Found service: " + mi.getService().getName()));
                    if (this.canRedirect()) {
                        this.log.info((Object)"Redirect allowed");
                        this.print(true);
                        Platform.runLater(() -> Launcher.open((MenuItem)mi));
                    } else {
                        this.log.info((Object)"The module is not allowed to make a redirect");
                    }
                } else {
                    this.log.info((Object)("MenuItem with id " + banner.getIdReferService() + " is not available. Skip redirect"));
                }
            } else {
                this.log.info((Object)("MenuItem with id " + banner.getIdReferService() + " not founded. Skip redirect"));
            }
        } else if (banner != null && banner.getLabel() != null) {
            this.log.info((Object)("Requested redirect to label: " + banner.getLabel()));
            GroupByLabelVisitor gblv = new GroupByLabelVisitor(banner.getLabel());
            MenuUtils.processMenu((MenuVisitor)gblv);
            ServiceType st = gblv.getServiceType();
            if (st != null) {
                if (!(st.getName().startsWith("#") || st.isHidden() || st.getBlocked().booleanValue())) {
                    this.log.info((Object)("Found group: " + st.getName()));
                    if (this.canRedirect()) {
                        this.log.info((Object)"Redirect allowed");
                        this.print(true);
                        Platform.runLater(() -> FxEnv.getMenuEngine().onGroup(st, 0));
                    } else {
                        this.log.info((Object)"The module is not allowed to make a redirect");
                    }
                } else {
                    this.log.info((Object)("Group with label " + banner.getLabel() + " is not available. Skip redirect"));
                }
            } else {
                this.log.info((Object)("Group with label " + banner.getLabel() + " not founded. Skip redirect"));
            }
        } else {
            this.log.info((Object)"Refer service or group is not set");
        }
    }

    private void showScreen(ScreenDescription sd, Map<String, Object> data) {
        this.log.info((Object)"------ Show screen: print");
        if (this.screen == null) {
            this.log.warn((Object)"Screen not create, skip show");
            this.print(true);
            this.toNextModule();
        } else {
            try {
                Session.setScreenDescription((ScreenDescription)sd);
                this.screen.init(sd, InitModuleHelper.buildScreenInit((Environment)this.env, data));
                this.log.debug((Object)"Show screen");
                FxEnv.showScreen((Screen)this.screen);
                this.log.debug((Object)"Complete");
            }
            catch (InitException ex) {
                this.log.error((Object)ex, (Throwable)ex);
                this.print(true);
                this.toNextModule();
            }
        }
    }

    private void print(boolean canPrint) {
        Pack p = this.env.getPack();
        if ((StateFacade.getState().getWarningMask() & 1) != 0) {
            this._print(false);
        } else if (p.getPaybackType() == 1 || p.getPaymentType() != 0) {
            this._print(true);
        } else {
            this._print(canPrint);
        }
    }

    private void _print(boolean canPrint) {
        if (canPrint) {
            Operation operation;
            Pack p = this.env.getPack();
            if (p.getPayments().size() > 1) {
                this.log.info((Object)("Print group operation by one check: " + p.isPrintByOne()));
                operation = PackUtility.convertGroup((Pack)p);
                this.log.info((Object)"Print group operation");
            } else {
                operation = PackUtility.convert((Pack)p);
                this.log.info((Object)"Print single operation");
            }
            NewKeeper2 currentKeeper = this.env.getCurrentKeeper();
            operation.setKeeper(PackUtility.getInKeeper((NewKeeper2)currentKeeper));
            PackUtility.setChange((Operation)operation, (NewKeeper2)currentKeeper);
            this.log.info((Object)("print module\t" + operation.getKeeper()));
            this.log.debug((Object)("\t" + operation.getSumResult()));
            Session.setItem((String)"operation", (Object)operation);
            List printerJobs = PrnUtils.createPrinterJob((Operation)operation, (boolean)p.isPrintByOne());
            printerJobs.stream().forEach(job -> FxEnv.getPrintSpooler().print(job));
        } else {
            this.log.info((Object)"Skip printing");
        }
    }

    private void toNextModule() {
        this.env.getModules().getEndingModule().end(this.env);
    }

    private class LocalScreenListener
    extends BaseScreenListener {
        private LocalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            if (ActionType.isExit((String)action)) {
                ShowcasePrintModule.this.print(false);
            } else {
                ShowcasePrintModule.this.print(true);
            }
            ShowcasePrintModule.this.toNextModule();
        }
    }
}

