/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.stage.payout;

import fxterm.core.menu.MenuByServiceIdVisitor;
import fxterm.core.menu.MenuUtils;
import fxterm.core.menu.MenuVisitor;
import fxterm.module.stage.payout.AfterPayoutModule;
import fxterm.module.stage.payout.BasePayoutModule;
import fxterm.msg.Messages;
import fxterm.session.Session;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import ru.softlogic.cash.Sum;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;

public class ShowcaseAfterPayoutModule
extends AfterPayoutModule {
    protected void processChange() {
        int ct = this.getChangeTypes(this.environment.getPack());
        String cts = String.format("%02x", ct &= 0xF);
        Sum ch = this.getChangeSize(this.environment.getPack());
        Session.setItem((String)"sum_change", (Object)ch);
        this.log.info((Object)("Process change, types: " + Messages.getChangeFlags((int)ct) + "(0x" + cts + ")"));
        int cnt = this.getChangeCounts(ct);
        this.log.debug((Object)("Change count: " + cnt));
        Service donate = Session.getServiceDonate();
        this.log.info((Object)("Donate service: " + donate));
        if (donate != null) {
            String did = null;
            switch (cnt) {
                case 0: {
                    this.changeToDonate();
                    break;
                }
                case 1: {
                    did = "module/payout/payout_2_" + String.format("%02x", ct + 32);
                    break;
                }
                case 2: {
                    did = "module/payout/payout_3_" + String.format("%02x", ct + 32);
                    break;
                }
                case 3: {
                    did = "module/payout/payout_3_" + cts;
                    break;
                }
                default: {
                    this.log.error((Object)"Too many change variants");
                    this.pinToSms();
                }
            }
            if (did != null) {
                this.log.info((Object)("Open " + did));
                Dialog.show((String)did, (DialogListener)new DonateChangeTypeListener());
            }
        } else if (cnt < 2) {
            switch (ct) {
                case 2: {
                    this.changeToSrv();
                    break;
                }
                case 4: {
                    this.changeToCash();
                    break;
                }
                case 8: {
                    this.changeToMob();
                    break;
                }
                default: {
                    this.pinToSms();
                    break;
                }
            }
        } else if (cnt == 2 || cnt == 3) {
            String did = "module/payout/payout_" + cnt + "_" + cts;
            this.log.info((Object)("Open " + did));
            Dialog.show((String)did, (DialogListener)new BasePayoutModule.ChangeTypeListener((BasePayoutModule)this));
        } else {
            this.log.error((Object)"Too many change variants");
            this.pinToSms();
        }
    }

    private void changeToDonate() {
        Service donate = Session.getServiceDonate();
        if (donate != null) {
            MenuByServiceIdVisitor visitor = new MenuByServiceIdVisitor(donate.getId());
            MenuUtils.processMenu((MenuVisitor)visitor);
            this.log.info((Object)("Set redirect item: " + visitor.getMenuItem()));
            Session.setRedirectItem((MenuItem)visitor.getMenuItem());
        }
        this.changeToSrv();
    }

    protected class DonateChangeTypeListener
    implements DialogListener {
        protected DonateChangeTypeListener() {
        }

        public void onAction(int actionId) {
            ShowcaseAfterPayoutModule.this.log.info((Object)("Selected variant: " + actionId));
            if (actionId == 1) {
                ShowcaseAfterPayoutModule.this.pinToSms();
            } else if (actionId == 8) {
                ShowcaseAfterPayoutModule.this.changeToMob();
            } else if (actionId == 4) {
                ShowcaseAfterPayoutModule.this.changeToCash();
            } else if (actionId == -1) {
                ShowcaseAfterPayoutModule.this.changeToTimeOut();
            } else if (actionId == 32) {
                ShowcaseAfterPayoutModule.this.changeToDonate();
            } else {
                ShowcaseAfterPayoutModule.this.changeToSrv();
            }
        }
    }
}

