/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.paytpl;

import fxterm.app.SystemProp;
import fxterm.core.BaseScreenListener;
import fxterm.module.Environment;
import fxterm.module.ExitIntent;
import fxterm.module.Intent;
import fxterm.module.ModuleHelper;
import fxterm.module.Payment;
import fxterm.module.PaymentTemplateState;
import fxterm.module.Restorable;
import fxterm.module.paytpl.BasePayTplModule;
import fxterm.module.paytpl.BaseSavePayTplModule;
import fxterm.module.paytpl.ShowcasePayTplModuleHelper;
import fxterm.module.paytpl.ShowcaseRestorePoint;
import fxterm.module.stage.payment.BackIntent;
import fxterm.session.Session;
import java.util.HashMap;
import java.util.Map;
import plfx.screen.ScreenListener;
import plfx.screen.pay.CommonSumScreen;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.mob.CityProfile;
import ru.softlogic.parser.mob.LocalNumberExtractor;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.services.identify.IdentifyService;
import ru.softlogic.system.util.PathUtils;

public class SavePayTplModuleImpl
extends BaseSavePayTplModule {
    private static final String FORM_INPUT_PHONE_ID = "phone.xml";
    private final CityProfile cp;
    private final LocalNumberExtractor lne = new LocalNumberExtractor(PathUtils.getFilePath((String)"/res/module/input/mobile//capacity-local.xml"));
    private ScreenDescription phoneSD;
    private Map<String, Object> data;
    private Runnable cancelListener;
    private CommonSumScreen sumScreen;
    private String cityCode;
    private ShowcaseRestorePoint restorePoint;

    public SavePayTplModuleImpl() {
        if (Session.getPoint() != null) {
            this.cityCode = Session.getPoint().getCityCode();
            log.debug((Object)("City code: " + this.cityCode));
        }
        this.cp = this.lne.getCityProfile(this.cityCode);
        log.debug((Object)("City profile: " + this.cp));
    }

    protected void _start(Environment environment, CommonSumScreen sumScreen) {
        this.env = environment;
        this.sumScreen = sumScreen;
        this.launch();
    }

    private void launch() {
        this.restorePoint = ShowcaseRestorePoint.LAUNCH;
        boolean saveTemplate = Boolean.parseBoolean((String)Session.getService().getProperties().get("keeper.template.save"));
        if (ProviderType.Mobile.equals((Object)Session.getService().getProviderType())) {
            this.restorePoint = ShowcaseRestorePoint.EXIT;
            log.info((Object)"Skip module, saving payment templates is disabled for mobile provider");
            log.info((Object)"Start payment");
            this.toNextModule();
        } else if (saveTemplate && SystemProp.getPayTplProviderId() != -1) {
            PaymentTemplateState pts = Session.getPaymentTemplateState();
            if (pts.isUsingPT() || pts.isCreatePT()) {
                this.restorePoint = ShowcaseRestorePoint.EXIT;
                ((Payment)this.env.getPack().getPayments().get(0)).getData().put("keeper.login", Session.getData().get("keeper.login"));
                log.info((Object)"Start payment");
                this.toNextModule();
            } else {
                this.data = new HashMap<String, Object>();
                if (this.env.getInitData() != null) {
                    ModuleHelper.fillStore((Map)this.env.getInitData(), this.data);
                }
                this.toShowInputPhoneScreen();
            }
        } else {
            this.restorePoint = ShowcaseRestorePoint.EXIT;
            if (!saveTemplate) {
                log.info((Object)"Skip module, saving payment templates off");
            } else if (SystemProp.getPayTplProviderId() == -1) {
                log.info((Object)"Skip module, paytpl provider id is not set");
            } else {
                log.info((Object)"Skip module, template is already in use");
            }
            log.info((Object)"Start payment");
            this.toNextModule();
        }
    }

    private void toShowInputPhoneScreen() {
        this.restorePoint = ShowcaseRestorePoint.START_SCREEN;
        log.debug((Object)" ----- toShowInputPhoneScreen");
        if (this.phoneSD == null) {
            log.debug((Object)"Try to load phoneSD");
            try {
                this.phoneSD = ShowcasePayTplModuleHelper.readScreenDesc("paytpl", FORM_INPUT_PHONE_ID, Session.getLocale(), 1);
                log.debug((Object)"phoneSD load successfully");
            }
            catch (ParseException ex) {
                log.error((Object)"Erron on load phone form", (Throwable)ex);
            }
        }
        if (this.phoneSD != null) {
            this.showScreenSafe(this.phoneSD, this.data, (ScreenListener)new InputPhoneScreenListener());
        } else {
            this.onException(new Exception("Phone form is not found"));
        }
    }

    protected void _restore(Restorable parent) {
        if (this.cancelListener != null) {
            this.cancelListener.run();
        }
        switch (this.restorePoint) {
            case EXIT: {
                if (Session.getPaymentTemplateState().isSkipInput()) {
                    this.cancel((Intent)new BackIntent((Restorable)this.env.getModules().getLoadPaymentTemplateModule()));
                    break;
                }
                this.cancel((Intent)new BackIntent(parent));
                break;
            }
            case LAUNCH: {
                this.launch();
                break;
            }
            case START_SCREEN: {
                this.toShowInputPhoneScreen();
            }
        }
    }

    private boolean verifyNumber(InputElement ie) {
        String newNumber;
        log.info((Object)"Verify input phone number");
        String currentNumber = null;
        if (ie.getOriginalValue() != null && !ie.getOriginalValue().isEmpty()) {
            currentNumber = ie.getOriginalValue();
        } else if (ie.getValue() != null && !ie.getValue().isEmpty()) {
            currentNumber = ie.getValue();
        }
        if (currentNumber == null) {
            return false;
        }
        if (currentNumber.length() > 10) {
            currentNumber = currentNumber.substring(1);
        }
        if (!currentNumber.equals(newNumber = this.cp.convertNumber(currentNumber))) {
            log.info((Object)("\u041f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0430 \u0437\u0430\u043c\u0435\u043d\u0430 \u043d\u043e\u043c\u0435\u0440\u0430 \u043d\u0430: " + newNumber));
            currentNumber = newNumber;
        }
        Short serviceId = IdentifyService.getOperator((String)currentNumber);
        log.info((Object)("\u041d\u043e\u043c\u0435\u0440 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 \u043f\u043e \u0435\u043c\u043a\u043e\u0441\u0442\u044f\u043c: " + serviceId));
        if (serviceId == -1) {
            log.info((Object)"\u0421\u0435\u0440\u0432\u0438\u0441 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u043f\u043e \u0444\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u044b\u043c \u0435\u043c\u043a\u043e\u0441\u0442\u044f\u043c, \u0441\u043c\u043e\u0442\u0440\u0438\u043c \u0433\u043e\u0440\u043e\u0434\u0441\u043a\u0438\u0435 \u043d\u043e\u043c\u0435\u0440\u0430");
            serviceId = this.cp.getOperator(currentNumber);
            if (serviceId == null) {
                log.info((Object)"\u0421\u0435\u0440\u0432\u0438\u0441 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u043f\u043e \u0433\u043e\u0440\u043e\u0434\u0441\u043a\u0438\u043c \u043d\u043e\u043c\u0435\u0440\u0430\u043c");
                return false;
            }
        }
        return true;
    }

    private void toNextModule() {
        this.env.getModules().getPaymentModule().startPayment(this.env, this.sumScreen);
    }

    private void showDialog(String id) {
        Dialog.show((String)id, actionId -> {
            log.debug((Object)("dialog result: " + actionId));
            if (actionId == 0) {
                log.info((Object)"Start payment");
                this.toNextModule();
            } else {
                this.cancelListener.run();
            }
        });
    }

    private void onException(Exception ex) {
        log.error((Object)"Throwed exception", (Throwable)ex);
        log.info((Object)"Start payment");
        this.toNextModule();
    }

    private class InputPhoneScreenListener
    extends BaseScreenListener {
        private InputPhoneScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            BasePayTplModule.log.info((Object)("Action: " + action));
            SavePayTplModuleImpl.this.cancelListener = cancelListener;
            if (ActionType.isPrev((String)action)) {
                SavePayTplModuleImpl.this.cancel((Intent)new BackIntent((Restorable)SavePayTplModuleImpl.this.env.getModules().getInputModule()));
            } else if (ActionType.isExit((String)action)) {
                SavePayTplModuleImpl.this.cancel((Intent)new ExitIntent(null, 1));
            } else if (ActionType.isNext((String)action)) {
                InputElement ie;
                BasePayTplModule.log.debug((Object)("data: " + data));
                ModuleHelper.fillStore(data, (Map)SavePayTplModuleImpl.this.data);
                Object obj = data.get("keeper.login");
                if (obj instanceof InputElement && ((ie = (InputElement)obj).getOriginalValue() != null && !ie.getOriginalValue().isEmpty() || ie.getValue() != null && !ie.getValue().isEmpty())) {
                    if (SavePayTplModuleImpl.this.verifyNumber(ie)) {
                        ((Payment)SavePayTplModuleImpl.this.env.getPack().getPayments().get(0)).getData().put("keeper.login", ie);
                    } else {
                        BasePayTplModule.log.info((Object)"\u0421\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0435\u043c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u043e\u043c\u0435\u0440 \u0438\u043b\u0438 \u043f\u0440\u043e\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0448\u0430\u0433");
                        SavePayTplModuleImpl.this.showDialog("module/paytpl/incorrect_phone");
                        return;
                    }
                }
                BasePayTplModule.log.info((Object)"Start payment");
                SavePayTplModuleImpl.this.toNextModule();
            } else {
                SavePayTplModuleImpl.this.onUnknownAction(action, data, cancelListener);
            }
        }
    }
}

