/*
 * Decompiled with CFR 0.152.
 */
package fxterm.module.paytpl;

import fxterm.app.FxEnv;
import fxterm.app.SystemProp;
import fxterm.core.BaseScreenListener;
import fxterm.core.task.Task;
import fxterm.module.Environment;
import fxterm.module.ModuleHelper;
import fxterm.module.input.InitModuleHelper;
import fxterm.module.paytpl.BaseLoadPayTplModule;
import fxterm.module.paytpl.BasePayTplModule;
import fxterm.module.paytpl.ShowcasePayTplModuleHelper;
import fxterm.module.paytpl.ShowcaseRestorePoint;
import fxterm.session.Session;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import plfx.screen.ScreenListener;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.advanced.actions.request.RequestData;
import ru.softlogic.input.model.advanced.actions.request.Response;
import ru.softlogic.input.model.field.selector.DataStore;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.table.TableDataStore;
import ru.softlogic.input.model.field.table.TableField;
import ru.softlogic.input.model.field.table.TableStore;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.input.model.screen.description.ConfirmScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.parser.ParseException;
import ru.softlogic.provider.ProviderType;

public class LoadPayTplModuleImpl
extends BaseLoadPayTplModule {
    private static final String FORM_START_ID = "start.xml";
    private static final String FORM_LOGIN_PWD_ID = "login_pwd.xml";
    private static final String FORM_TEMPLATE_ID = "template.xml";
    private static final String FORM_CONFIRM_ID = "confirm.xml";
    private static final String FORM_SUM_CHANGE_ID = "sum_change.xml";
    private static final String KEY_PAY_BEFORE = "#pay-before";
    private static final String KEY_LOGIN = "keeper.login";
    private static final String KEY_PASSWORD = "keeper.password";
    private static final String KEY_TEMPLATE = "#template";
    private static final String KEY_SUM = "#sum";
    private static final String KEY_TEMPLATES = "templates";
    private static final String GATE_FUNC_LOGIN = "login";
    private static final String GATE_FUNC_PWD_RECOVER = "pin-recover";
    private static final String ACTION_PWD_RECOVER = "pwdRecover";
    private static final String ACTION_NEW_TEMPLATE = "newTemplate";
    private static final String ACTION_CHANGE_TEMPLATE = "changeTemplate";
    private ScreenDescription questionSD;
    private ScreenDescription login_pwdSD;
    private ScreenDescription templateSD;
    private ScreenDescription confirmSD;
    private ScreenDescription sum_changeSD;
    private Map<String, Object> data;
    private Map<String, Object> templateData;
    private Map<String, Object> scData;
    private Runnable cancelListener;
    private ShowcaseRestorePoint restorePoint;

    public void _start(Environment environment) {
        log.info((Object)("Paytpl provider id: " + SystemProp.getPayTplProviderId()));
        this.env = environment;
        this.launch();
    }

    private void launch() {
        this.restorePoint = ShowcaseRestorePoint.LAUNCH;
        boolean saveTemplate = Boolean.parseBoolean((String)Session.getService().getProperties().get("keeper.template.save"));
        if (ProviderType.Mobile.equals((Object)Session.getService().getProviderType())) {
            this.restorePoint = ShowcaseRestorePoint.EXIT;
            log.info((Object)"Skip module, loading payment templates is disabled for mobile provider");
            this.toNextModule();
        } else if (saveTemplate && SystemProp.getPayTplProviderId() != -1) {
            this.data = new HashMap<String, Object>();
            if (this.env.getInitData() != null) {
                ModuleHelper.fillStore((Map)this.env.getInitData(), this.data);
            }
            this.toShowStartScreen();
        } else {
            this.restorePoint = ShowcaseRestorePoint.EXIT;
            if (SystemProp.getPayTplProviderId() == -1) {
                log.info((Object)"Skip module, paytpl provider id is not set");
            } else {
                log.info((Object)"Skip module, loading payment templates off on service");
            }
            this.toNextModule();
        }
    }

    private void toNextModule() {
        this.env.getModules().getInputModule().start(this.env);
    }

    private void toShowStartScreen() {
        this.restorePoint = ShowcaseRestorePoint.START_SCREEN;
        log.info((Object)"Show start screen");
        if (this.questionSD == null) {
            log.debug((Object)"Try to load startSD");
            try {
                this.questionSD = ShowcasePayTplModuleHelper.readScreenDesc("paytpl", FORM_START_ID, Session.getLocale(), 1);
                log.debug((Object)"startSD load successfully");
            }
            catch (ParseException ex) {
                log.error((Object)"Erron on load start form", (Throwable)ex);
            }
        }
        if (this.questionSD != null) {
            this.showScreenSafe(this.questionSD, this.data, (ScreenListener)new StartScreenListener());
        } else {
            this.onException(new Exception("Start form is not found"));
        }
    }

    private void toShowLoginScreen() {
        this.restorePoint = ShowcaseRestorePoint.LOGIN_SCREEN;
        log.info((Object)"Show authorization screen");
        if (this.login_pwdSD == null) {
            try {
                this.login_pwdSD = ShowcasePayTplModuleHelper.readScreenDesc("paytpl", FORM_LOGIN_PWD_ID, Session.getLocale(), 2);
                log.debug((Object)"login_pwdSD load successfully");
            }
            catch (ParseException ex) {
                log.error((Object)"Erron on load login_pwd form", (Throwable)ex);
            }
        }
        if (this.login_pwdSD != null) {
            this.showScreenSafe(this.login_pwdSD, this.data, (ScreenListener)new LoginPwdScreenListener());
        } else {
            this.onException(new Exception("Login_pwd form is not found"));
        }
    }

    private void toShowPaymentTemplatesScreen() {
        this.restorePoint = ShowcaseRestorePoint.TEMPLATE_SCREEN;
        log.info((Object)"Show payment templates screen");
        try {
            ScreenDescription sd = this.createTemplateSD();
            if (sd != null) {
                this.showScreenSafe(sd, this.data, (ScreenListener)new SelectTemplateScreenListener());
                return;
            }
            this.showDialog("module/paytpl/error");
        }
        catch (Exception ex) {
            this.onException(ex);
        }
    }

    private ScreenDescription createTemplateSD() throws Exception {
        if (this.templateSD == null) {
            try {
                this.templateSD = ShowcasePayTplModuleHelper.readScreenDesc("paytpl", FORM_TEMPLATE_ID, Session.getLocale(), 1);
                Object o = this.templateSD.getSequence().getFields().get(0);
                if (o instanceof SelectorField) {
                    SelectorField sf = (SelectorField)o;
                    sf.setStore((ItemsStore)new DataStore(KEY_TEMPLATES));
                } else if (o instanceof TableField) {
                    TableField tf = (TableField)o;
                    tf.setStore((TableStore)new TableDataStore(KEY_TEMPLATES));
                }
                log.debug((Object)"templateSD load successfully");
            }
            catch (ParseException ex) {
                log.error((Object)"Erron on load template form", (Throwable)ex);
            }
            if (this.templateSD == null) {
                throw new Exception("Template form is not found");
            }
        } else {
            Object o = this.templateSD.getSequence().getFields().get(0);
            if (o instanceof SelectorField) {
                ((SelectorField)o).getItems().clear();
            } else if (o instanceof TableField) {
                ((TableField)o).getTableItems().clear();
            }
        }
        return this.templateSD;
    }

    private void toShowConfirmScreen() {
        this.restorePoint = ShowcaseRestorePoint.CONFIRM_SCREEN;
        log.info((Object)"Show confirm screen");
        if (this.confirmSD == null) {
            this.confirmSD = new ConfirmScreenDescription();
            Form f = null;
            try {
                f = ShowcasePayTplModuleHelper.readForm("paytpl", FORM_CONFIRM_ID, Session.getLocale(), 1);
                log.debug((Object)"confirmSD load successfully");
            }
            catch (ParseException ex) {
                log.error((Object)"Erron on load confirm form", (Throwable)ex);
            }
            if (f != null && f.getConfirmScreen() != null && !f.getConfirmScreen().isEmpty()) {
                this.confirmSD.setType(f.getConfirmScreen());
            }
        }
        if (this.confirmSD != null) {
            this.confirmSD.setButtons(InitModuleHelper.createKeyMap());
            this.confirmSD.setTitle(Session.getService().getName());
            this.showScreenSafe(this.confirmSD, this.templateData, (ScreenListener)new ConfirmScreenListener());
        } else {
            this.onException(new Exception("Confirm form is not found"));
        }
    }

    private void toShowSumChangeScreen() {
        this.restorePoint = ShowcaseRestorePoint.SUM_CHANGE_SCREEN;
        log.info((Object)"Show sum change screen");
        if (this.sum_changeSD == null) {
            try {
                this.sum_changeSD = ShowcasePayTplModuleHelper.readScreenDesc("paytpl", FORM_SUM_CHANGE_ID, Session.getLocale(), 1);
                log.debug((Object)"sum_changeSD load successfully");
            }
            catch (ParseException ex) {
                log.error((Object)"Erron on load sum_change form", (Throwable)ex);
            }
        }
        if (this.sum_changeSD != null) {
            this.showScreenSafe(this.sum_changeSD, this.scData, (ScreenListener)new SumChangeScreenListener());
        } else {
            this.onException(new Exception("Sum_change form is not found"));
        }
    }

    protected void _restore() {
        if (this.cancelListener != null) {
            this.cancelListener.run();
        }
        Session.getPaymentTemplateState().reset();
        switch (this.restorePoint) {
            case EXIT: {
                this.back();
                break;
            }
            case LAUNCH: {
                this.launch();
                break;
            }
            case START_SCREEN: {
                this.toShowStartScreen();
                break;
            }
            case LOGIN_SCREEN: {
                this.toShowLoginScreen();
                break;
            }
            case TEMPLATE_SCREEN: {
                this.toShowPaymentTemplatesScreen();
                break;
            }
            case CONFIRM_SCREEN: {
                this.toShowConfirmScreen();
                break;
            }
            case SUM_CHANGE_SCREEN: {
                this.toShowSumChangeScreen();
            }
        }
    }

    private void getTemplate(Map<String, String> params) {
        RequestData rd = new RequestData();
        rd.setFunction(GATE_FUNC_LOGIN);
        rd.setIdProvider(Short.valueOf((short)SystemProp.getPayTplProviderId()));
        rd.setIdService(Session.getService().getId());
        rd.setParams(params);
        try {
            new Execution<Response>(() -> FxEnv.getConnector().request(rd), response -> {
                if (response.getServerError() == 0 && response.getServiceError() == 0 && response.getData() != null && ((Data)response.getData()).getNestedData() != null) {
                    this.data.put(((Data)response.getData()).getNestedData().getId(), ((Data)response.getData()).getNestedData().getData());
                    this.toShowPaymentTemplatesScreen();
                } else if (response.getServiceError() == 5) {
                    this.showDialog("module/paytpl/no_templates");
                } else {
                    this.showDialog("module/paytpl/authorization_fail");
                }
            }, ex -> this.onException((Exception)ex)).process();
        }
        catch (Exception ex2) {
            log.error((Object)"Erron on execute task", (Throwable)ex2);
            this.onException(ex2);
        }
    }

    private void pwdRecover(Map<String, String> params) {
        RequestData rd = new RequestData();
        rd.setFunction(GATE_FUNC_PWD_RECOVER);
        rd.setIdProvider(Short.valueOf((short)SystemProp.getPayTplProviderId()));
        rd.setIdService(Session.getService().getId());
        rd.setParams(params);
        try {
            new Execution<Response>(() -> FxEnv.getConnector().request(rd), response -> {
                if (response.getServerError() == 0 && response.getServiceError() == 0) {
                    this.showDialog("module/paytpl/recover_success");
                } else if (response.getServiceError() == 6) {
                    this.showDialog("module/paytpl/no_account");
                } else {
                    this.showDialog("module/paytpl/recover_fail");
                }
            }, ex -> this.onException((Exception)ex)).process();
        }
        catch (Exception ex2) {
            log.error((Object)"Erron on execute task", (Throwable)ex2);
            this.onException(ex2);
        }
    }

    private void showDialog(String id) {
        Dialog.show((String)id, actionId -> {
            log.debug((Object)("dialog result: " + actionId));
            if (actionId == 0) {
                this.toNextModule();
            } else if (this.cancelListener != null) {
                this.cancelListener.run();
            }
        });
    }

    private void onException(Exception ex) {
        log.error((Object)"Throwed exception", (Throwable)ex);
        String dialogId = ex instanceof IOException ? "module/paytpl/no_connect" : "module/paytpl/error";
        this.showDialog(dialogId);
    }

    private class Execution<T>
    extends Task {
        private final Callable<T> task;
        private final Consumer<T> resultHandler;
        private final Consumer<Exception> exeptionHandler;

        public Execution(Callable<T> task, Consumer<T> resultHandler, Consumer<Exception> exeptionHandler) {
            this.task = Objects.requireNonNull(task, "task");
            this.resultHandler = Objects.requireNonNull(resultHandler, "resultHandler");
            this.exeptionHandler = Objects.requireNonNull(exeptionHandler, "exeptionHandler");
        }

        protected String getWaitId() {
            return "wait";
        }

        protected T execute() throws Exception {
            return this.task.call();
        }

        protected void onResult(Object object) {
            this.resultHandler.accept(object);
        }

        protected void onError(Exception ex) {
            this.exeptionHandler.accept(ex);
        }
    }

    private class SumChangeScreenListener
    extends BaseScreenListener {
        private SumChangeScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            BasePayTplModule.log.info((Object)("Action: " + action));
            LoadPayTplModuleImpl.this.cancelListener = cancelListener;
            if (ActionType.isPrev((String)action)) {
                LoadPayTplModuleImpl.this.toShowConfirmScreen();
            } else if (ActionType.isExit((String)action)) {
                LoadPayTplModuleImpl.this.cancel(null);
            } else if (ActionType.isNext((String)action)) {
                BasePayTplModule.log.debug((Object)("data: " + data));
                ModuleHelper.fillStore(data, (Map)LoadPayTplModuleImpl.this.scData);
                Session.getPaymentTemplateState().setUsingPT(true);
                LoadPayTplModuleImpl.this.env.setInitData(LoadPayTplModuleImpl.this.scData);
                LoadPayTplModuleImpl.this.toNextModule();
            } else {
                LoadPayTplModuleImpl.this.onUnknownAction(action, data, cancelListener);
            }
        }
    }

    private class ConfirmScreenListener
    extends BaseScreenListener {
        private ConfirmScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            BasePayTplModule.log.info((Object)("Action: " + action));
            LoadPayTplModuleImpl.this.cancelListener = cancelListener;
            if (ActionType.isPrev((String)action)) {
                LoadPayTplModuleImpl.this.toShowPaymentTemplatesScreen();
            } else if (ActionType.isExit((String)action)) {
                LoadPayTplModuleImpl.this.cancel(null);
            } else if (ActionType.isNext((String)action)) {
                BasePayTplModule.log.debug((Object)("data: " + data));
                Session.getPaymentTemplateState().setUsingPT(true);
                Session.getPaymentTemplateState().setSkipInput(true);
                LoadPayTplModuleImpl.this.env.setInitData(LoadPayTplModuleImpl.this.templateData);
                LoadPayTplModuleImpl.this.toNextModule();
            } else if (LoadPayTplModuleImpl.ACTION_CHANGE_TEMPLATE.equalsIgnoreCase(action)) {
                LoadPayTplModuleImpl.this.scData = new LinkedHashMap(LoadPayTplModuleImpl.this.templateData);
                Object o = LoadPayTplModuleImpl.this.scData.get(LoadPayTplModuleImpl.KEY_SUM);
                if (o instanceof TransactionSum) {
                    TransactionSum ts = (TransactionSum)o;
                    String value = "" + (double)ts.getSum() * Math.pow(10.0, -ts.getFractionDigits());
                    InputElement ie = new InputElement(LoadPayTplModuleImpl.KEY_SUM, LoadPayTplModuleImpl.KEY_SUM, value);
                    LoadPayTplModuleImpl.this.scData.put(LoadPayTplModuleImpl.KEY_SUM, ie);
                }
                LoadPayTplModuleImpl.this.toShowSumChangeScreen();
            } else {
                LoadPayTplModuleImpl.this.onUnknownAction(action, data, cancelListener);
            }
        }
    }

    private class SelectTemplateScreenListener
    extends BaseScreenListener {
        private SelectTemplateScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            BasePayTplModule.log.info((Object)("Action: " + action));
            LoadPayTplModuleImpl.this.cancelListener = cancelListener;
            if (ActionType.isPrev((String)action)) {
                LoadPayTplModuleImpl.this.toShowLoginScreen();
            } else if (ActionType.isExit((String)action)) {
                LoadPayTplModuleImpl.this.cancel(null);
            } else if (ActionType.isNext((String)action)) {
                BasePayTplModule.log.debug((Object)("data: " + data));
                Object o = data.get(LoadPayTplModuleImpl.KEY_TEMPLATE);
                if (o instanceof InputElement) {
                    InputElement ie = (InputElement)o;
                    ie.addFlag(1);
                }
                LoadPayTplModuleImpl.this.templateData = data;
                LoadPayTplModuleImpl.this.toShowConfirmScreen();
            } else if (LoadPayTplModuleImpl.ACTION_NEW_TEMPLATE.equalsIgnoreCase(action)) {
                Session.getPaymentTemplateState().setCreatePT(true);
                LoadPayTplModuleImpl.this.toNextModule();
            } else {
                LoadPayTplModuleImpl.this.onUnknownAction(action, data, cancelListener);
            }
        }
    }

    private class LoginPwdScreenListener
    extends BaseScreenListener {
        private LoginPwdScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            BasePayTplModule.log.info((Object)("Action: " + action));
            LoadPayTplModuleImpl.this.cancelListener = cancelListener;
            if (ActionType.isPrev((String)action)) {
                LoadPayTplModuleImpl.this.toShowStartScreen();
            } else if (ActionType.isExit((String)action)) {
                LoadPayTplModuleImpl.this.cancel(null);
            } else if (ActionType.isNext((String)action) || LoadPayTplModuleImpl.ACTION_PWD_RECOVER.equalsIgnoreCase(action)) {
                BasePayTplModule.log.debug((Object)("data: " + data));
                ModuleHelper.fillStore(data, (Map)LoadPayTplModuleImpl.this.data);
                HashMap<String, String> params = new HashMap<String, String>();
                InputElement ie = (InputElement)data.get(LoadPayTplModuleImpl.KEY_LOGIN);
                params.put(ie.getKey(), ie.getValue());
                Session.setItem((String)"input_number", (Object)ie.getValueTitle());
                Session.setItem((String)LoadPayTplModuleImpl.KEY_LOGIN, (Object)ie);
                BasePayTplModule.log.info((Object)("Input number: " + ie.getValue()));
                if (ActionType.isNext((String)action) && (ie = (InputElement)data.get(LoadPayTplModuleImpl.KEY_PASSWORD)) != null) {
                    params.put(ie.getKey(), ie.getValue());
                }
                if (ActionType.isNext((String)action)) {
                    BasePayTplModule.log.debug((Object)"Required execute task: getTemplate");
                    LoadPayTplModuleImpl.this.getTemplate(params);
                } else {
                    BasePayTplModule.log.debug((Object)"Required execute task: pwdRecover");
                    LoadPayTplModuleImpl.this.pwdRecover(params);
                }
            } else {
                LoadPayTplModuleImpl.this.onUnknownAction(action, data, cancelListener);
            }
        }
    }

    private class StartScreenListener
    extends BaseScreenListener {
        private StartScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            BasePayTplModule.log.info((Object)("Action: " + action));
            LoadPayTplModuleImpl.this.cancelListener = cancelListener;
            if (ActionType.isPrev((String)action)) {
                LoadPayTplModuleImpl.this.back();
            } else if (ActionType.isExit((String)action)) {
                LoadPayTplModuleImpl.this.cancel(null);
            } else if (ActionType.isNext((String)action)) {
                BasePayTplModule.log.debug((Object)("data: " + data));
                ModuleHelper.fillStore(data, (Map)LoadPayTplModuleImpl.this.data);
                Object obj = data.get(LoadPayTplModuleImpl.KEY_PAY_BEFORE);
                String payBefore = null;
                if (obj instanceof InputElement) {
                    payBefore = ((InputElement)obj).getValue();
                }
                if ("1".equals(payBefore)) {
                    LoadPayTplModuleImpl.this.toShowLoginScreen();
                } else {
                    LoadPayTplModuleImpl.this.toNextModule();
                }
            } else {
                LoadPayTplModuleImpl.this.onUnknownAction(action, data, cancelListener);
            }
        }
    }
}

