/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.service.comission;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import ru.softlogic.cash.Sum;
import ru.softlogic.service.comission.FeeSum;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SumResult", namespace="http://soft-logic.ru")
public class SumResult
implements Serializable {
    static final long serialVersionUID = 7926285855233239633L;
    @XmlElement(name="out")
    private Sum out;
    @XmlElement(name="outProv")
    private Sum outProv;
    @XmlElement(name="comm")
    private Sum commission;
    @XmlElement(name="change")
    private Sum change;
    @XmlElement(name="cash")
    private Sum cash;
    @XmlElement(name="cashLess")
    private Sum cashLess;
    private transient Sum donate;
    private FeeSum providerFee;

    public SumResult() {
    }

    public SumResult(Sum cash, Sum cashLess, Sum out, Sum outProv, Sum commission, Sum change, FeeSum providerFee) {
        this(cash, cashLess, out, outProv, commission, change, new Sum(0, cash.getCurrency()), providerFee);
    }

    public SumResult(Sum cash, Sum cashLess, Sum out, Sum outProv, Sum commission, Sum change, Sum donate, FeeSum providerFee) {
        this.cash = Objects.requireNonNull(cash, "Cash is null");
        this.cashLess = Objects.requireNonNull(cashLess, "Cashless is null");
        this.out = Objects.requireNonNull(out, "Out is null");
        this.outProv = Objects.requireNonNull(outProv, "OutProv is null");
        this.commission = Objects.requireNonNull(commission, "Comission is null");
        this.change = Objects.requireNonNull(change, "Change is null");
        this.donate = Objects.requireNonNull(donate, "Donate is null");
        this.providerFee = providerFee;
    }

    public SumResult(SumResult oth) {
        this(oth, oth.donate == null ? new Sum(0, oth.cash.getCurrency()) : oth.donate);
    }

    public SumResult(SumResult oth, Sum donate) {
        this.cash = oth.cash;
        this.cashLess = oth.cashLess;
        this.out = oth.out;
        this.outProv = oth.outProv;
        this.commission = oth.commission;
        this.change = oth.change;
        this.donate = Objects.requireNonNull(donate, "Donate is null");
        this.providerFee = oth.providerFee == null ? null : new FeeSum(oth.providerFee);
    }

    public Sum getChange() {
        return this.change;
    }

    public Sum getOutProv() {
        return this.outProv;
    }

    public Sum getCommission() {
        return this.commission;
    }

    public Sum getOut() {
        return this.out;
    }

    public Sum getCash() {
        return this.cash;
    }

    public Sum getCashLess() {
        return this.cashLess;
    }

    public Sum getIncome() {
        return this.cash.add(this.cashLess);
    }

    public Sum getDonate() {
        return this.donate;
    }

    public void setDonate(Sum donate) {
        this.donate = donate;
    }

    public FeeSum getProviderFee() {
        return this.providerFee;
    }

    public void setProviderFee(FeeSum providerFee) {
        this.providerFee = providerFee;
    }

    public String toString() {
        return "SumResult{out=" + this.out + ", outProv=" + this.outProv + ", commission=" + this.commission + ", change=" + this.change + ", cash=" + this.cash + ", cashLess=" + this.cashLess + ", donate=" + this.donate + ", providerFee=" + this.providerFee + '}';
    }
}

