/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.service.comission;

import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import ru.softlogic.cash.Sum;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CommissionStep")
public class CommissionStep
implements Comparable<CommissionStep>,
Serializable {
    static final long serialVersionUID = -1441817480015978272L;
    @XmlElement(name="sum")
    private Sum sum;
    @XmlAttribute(name="percent")
    private double percentValue;
    @XmlElement(name="fixed")
    private Sum fixedValue;
    @XmlElement(name="min")
    private Sum min;
    @XmlElement(name="max")
    private Sum max;
    @XmlAttribute(name="from")
    private Date fromTime;
    @XmlAttribute(name="to")
    private Date toTime;
    @XmlAttribute(name="days")
    private Integer days;
    @XmlAttribute(name="pSource")
    private String paymentSource;

    public CommissionStep() {
    }

    public CommissionStep(Sum sum, double percentValue, Sum fixedValue) {
        this.setSum(sum);
        this.setPercentValue(percentValue);
        this.setFixedValue(fixedValue);
    }

    public Sum getFixedValue() {
        return this.fixedValue;
    }

    public void setFixedValue(Sum fixedValue) {
        this.fixedValue = fixedValue;
    }

    public double getPercentValue() {
        return this.percentValue;
    }

    public void setPercentValue(double percentValue) {
        if (percentValue < 0.0 || percentValue >= 100.0) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 % \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438");
        }
        this.percentValue = percentValue;
    }

    public Sum getSum() {
        return this.sum;
    }

    public Sum getMax() {
        return this.max;
    }

    public void setMax(Sum max) {
        this.max = max;
    }

    public Sum getMin() {
        return this.min;
    }

    public void setMin(Sum min) {
        this.min = min;
    }

    public Date getFromTime() {
        return this.fromTime;
    }

    public void setFromTime(Date fromTime) {
        this.fromTime = fromTime;
    }

    public Date getToTime() {
        return this.toTime;
    }

    public void setToTime(Date toTime) {
        this.toTime = toTime;
    }

    public Integer getDays() {
        return this.days;
    }

    public void setDays(Integer days) {
        this.days = days;
    }

    public String getPaymentSource() {
        return this.paymentSource;
    }

    public void setPaymentSource(String paymentSource) {
        this.paymentSource = paymentSource;
    }

    public void setSum(Sum sum) {
        if (sum == null) {
            throw new IllegalArgumentException("\u0421\u0443\u043c\u043c\u0430 \u0441\u0442\u0435\u043f\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u043e\u0439");
        }
        this.sum = sum;
    }

    @Override
    public int compareTo(CommissionStep commissionStep) {
        if (this.paymentSource != null && commissionStep.getPaymentSource() != null && !this.paymentSource.equals(commissionStep.getPaymentSource())) {
            return this.paymentSource.compareTo(commissionStep.getPaymentSource());
        }
        return this.sum.compareTo(commissionStep.getSum());
    }

    public String toString() {
        return "CommissionStep{sum=" + this.sum + ", percentValue=" + this.percentValue + ", fixedValue=" + this.fixedValue + ", min=" + this.min + ", max=" + this.max + ", fromTime=" + this.fromTime + ", toTime=" + this.toTime + ", days=" + this.days + ", paymentSource=" + this.paymentSource + '}';
    }
}

