/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.reference.service;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.MenuItemFilter;
import ru.softlogic.reference.service.ScreenType;
import ru.softlogic.reference.service.ServiceTypeFilter;
import ru.softlogic.reference.service.ServiceTypeLang;

public class ServiceType
implements Serializable {
    public static final short FLAG_ROTATE_CONTENT = 1;
    static final long serialVersionUID = 2570599596431724224L;
    private int id;
    private String name;
    private String image;
    private short sortOrder;
    private Map<String, ServiceTypeLang> langs;
    private MenuItem[] menuItems;
    private ServiceType[] types;
    private String invitation;
    private ScreenType screenType;
    private Short hotkeyPosition;
    private Boolean blocked;
    private String desc;
    private String style;
    private Integer label;
    private short flags;
    private boolean hidden;

    public ServiceType() {
    }

    public ServiceType(String name) {
        this.name = name;
    }

    public ServiceType(ServiceType oth) {
        this.id = oth.id;
        this.name = oth.name;
        this.image = oth.image;
        this.sortOrder = oth.sortOrder;
        this.langs = oth.langs;
        this.menuItems = oth.menuItems;
        this.types = oth.types;
        this.invitation = oth.invitation;
        this.screenType = oth.screenType;
        this.hotkeyPosition = oth.hotkeyPosition;
        this.blocked = oth.blocked;
        this.desc = oth.desc;
        this.style = oth.style;
        this.label = oth.label;
        this.flags = oth.flags;
        this.hidden = oth.hidden;
    }

    public ServiceType(ServiceType[] types) {
        this.types = types;
    }

    public ServiceType(ServiceType[] types, MenuItem[] menuItems) {
        this.types = types;
        this.menuItems = menuItems;
    }

    public int getNestedCount() {
        return (this.menuItems != null ? this.menuItems.length : 0) + (this.types != null ? this.types.length : 0);
    }

    public int getNestedCount(ServiceTypeFilter typeFilter, MenuItemFilter itemFilter) {
        return this.getMenuItems(itemFilter).size() + this.getServiceTypes(typeFilter).size();
    }

    public List<MenuItem> getMenuItems(MenuItemFilter filter) {
        LinkedList<MenuItem> res = new LinkedList<MenuItem>();
        if (this.menuItems != null) {
            for (MenuItem mi : this.menuItems) {
                if (!filter.accept(mi)) continue;
                res.add(mi);
            }
        }
        return res;
    }

    public static List<ServiceType> getServiceTypes(ServiceType[] sts, ServiceTypeFilter filter) {
        LinkedList<ServiceType> res = new LinkedList<ServiceType>();
        if (sts != null) {
            for (ServiceType st : sts) {
                if (!filter.accept(st)) continue;
                res.add(st);
            }
        }
        return res;
    }

    public List<ServiceType> getServiceTypes(ServiceTypeFilter filter) {
        return ServiceType.getServiceTypes(this.types, filter);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Map<String, ServiceTypeLang> getLangs() {
        return this.langs;
    }

    public void setLangs(Map<String, ServiceTypeLang> langs) {
        this.langs = langs;
    }

    public MenuItem[] getMenuItems() {
        return this.menuItems;
    }

    public void setMenuItems(MenuItem[] menuItems) {
        this.menuItems = menuItems;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServiceType[] getTypes() {
        return this.types;
    }

    public void setTypes(ServiceType[] types) {
        this.types = types;
    }

    public short getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(short sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getInvitation() {
        return this.invitation;
    }

    public void setInvitation(String invitation) {
        this.invitation = invitation;
    }

    public ScreenType getScreenType() {
        return this.screenType;
    }

    public void setScreenType(ScreenType screenType) {
        this.screenType = screenType;
    }

    public Short getHotkeyPosition() {
        return this.hotkeyPosition;
    }

    public void setHotkeyPosition(Short hotkeyPosition) {
        this.hotkeyPosition = hotkeyPosition;
    }

    public Boolean getBlocked() {
        return this.blocked;
    }

    public void setBlocked(Boolean blocked) {
        this.blocked = blocked;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public Integer getLabel() {
        return this.label;
    }

    public void setLabel(Integer label) {
        this.label = label;
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public boolean hasFlag(short flag) {
        return (this.flags & flag) != 0;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ServiceType) {
            ServiceType oth = (ServiceType)obj;
            return this.id == oth.id;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + this.id;
        hash = 47 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "ServiceType[id=" + this.id + ",name=" + this.name + ",sort=" + this.sortOrder + ",lang=" + this.langs + ",screen=" + this.screenType + ",label=" + this.label + ",flags=" + this.flags + ",hidden=" + this.hidden + "]";
    }
}

