/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.reference.service;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import ru.softlogic.cash.Sum;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.service.ProcessingType;
import ru.softlogic.reference.service.ServiceLang;
import ru.softlogic.reference.service.ServiceModules;
import ru.softlogic.reference.service.VerifyType;
import ru.softlogic.service.comission.Commission;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Service")
public class Service
implements Serializable {
    public static final short PAPER_NOT_REQUIRED = 0;
    public static final short PAPER_REQUIRED = 1;
    public static final short PAPER_IGNORE = 2;
    public static final short PAPER_NOT_REQUIRED_SEND_SMS = 3;
    public static final short PAPER_REQUIRED_SEND_SMS = 4;
    public static final short CHANGE_TIMEOUT = -1;
    public static final short CHANGE_PIN = 1;
    public static final short CHANGE_SERVICE = 2;
    public static final short CHANGE_CASH = 4;
    public static final short CHANGE_MOBILE = 8;
    public static final short CHANGE_SAVE_SRV = 16;
    public static final short PAY_SCHEMA_FLAG_CASH = 1;
    public static final short PAY_SCHEMA_FLAG_CBC = 2;
    public static final short PAY_SCHEMA_FLAG_BANK_CARD = 4;
    public static final long FLAG_SHOW_CONFIRM = 1L;
    public static final long FLAG_SHOW_CASHBACK = 2L;
    public static final long FLAG_PAYMENT_SCHEMA_OR = 4L;
    public static final long FLAG_DISABLE_EXIT_ON_CASH = 8L;
    public static final long FLAG_USE_FOR_CHANGE = 16L;
    public static final long FLAG_AUTO_FINISH_PAYMENT = 32L;
    public static final long FLAG_PAYMENT_SAME_DETAILS = 64L;
    public static final long FLAG_USE_IN_AD_SENDING = 128L;
    public static final long FLAG_FISCAL_SERVICE = 256L;
    public static final long FLAG_NOT_FISCAL = 512L;
    public static final long FLAG_NAVIGATE_THROUGH_KEEPER = 1024L;
    public static final long FLAG_SHOW_ONLINE_CHECK_INFO = 2048L;
    public static final long FLAG_GROUP_PAYMENT_DIVIDED_COMMISSION = 4096L;
    public static final long FLAG_DIVIDE_GROUP_PAYMENT = 8192L;
    public static final long FLAG_PRINT_SINGLE_CHECK_ON_MOB_CHANGE = 16384L;
    public static final long FLAG_PAPER_NEED = 65536L;
    public static final long FLAG_PAPER_SHOW_WARNING = 131072L;
    public static final long FLAG_PAPER_SEND_SMS = 262144L;
    public static final long FLAG_PAPER_SEND_SMS_IF_ABSENT = 524288L;
    public static final long FLAG_SHOW_SUM_IN_PROVIDER_CURRENCY = 0x100000L;
    public static final long FLAG_ZERO_AMOUNT = 0x200000L;
    public static final long FLAG_USE_SERVICE_MASK = 0x8000000L;
    static final long serialVersionUID = 1632469991915762973L;
    @XmlAttribute(name="id")
    private short id;
    @XmlAttribute(name="code")
    private short code;
    @XmlAttribute(name="barcode")
    private String barcodePrefix;
    @XmlAttribute(name="name")
    private String name;
    @XmlAttribute(name="pname")
    private String printName;
    @XmlAttribute(name="shortName")
    private String shortName;
    @XmlAttribute(name="fullName")
    private String fullName;
    @XmlAttribute(name="altName")
    protected String altName;
    @XmlElement(name="invitation")
    private String invitation;
    @XmlAttribute(name="image")
    private String image;
    @XmlElement(name="mins")
    private Sum minSum;
    @XmlElement(name="maxs")
    private Sum maxSum;
    @XmlElement(name="maxis")
    private Sum maxInputSum;
    @XmlElement(name="divs")
    private Sum divideSum;
    @XmlElement(name="multis")
    private Sum multiplicitySum;
    @XmlAttribute(name="vtype")
    private VerifyType verifyType;
    @XmlAttribute(name="ptype")
    private ProcessingType processingType;
    @XmlAttribute(name="pschemafl")
    private int paymentSchemaFlags;
    @XmlAttribute(name="provider")
    private ProviderType providerType;
    @XmlElement(name="text")
    private String printText;
    @XmlElement(name="cs")
    private List<Short> childServices;
    @XmlElement(name="prepaid")
    private int[] prepaidSteps;
    @XmlElement(name="comm")
    private Commission commission;
    @XmlElement(name="minComm")
    private Commission minComm;
    @XmlAttribute(name="gpDivComm")
    private Boolean gpDivComm;
    @XmlElement(name="warning")
    private String warning;
    @XmlAttribute(name="render")
    private String checkRender;
    @XmlElement(name="prov")
    private Dealer provider;
    @XmlElement(name="oper")
    private Dealer operator;
    @XmlAttribute(name="printCheck")
    private Boolean printCheckDialog;
    @XmlAttribute(name="changet")
    private short changeType;
    @XmlAttribute(name="style")
    private String style;
    @XmlAttribute(name="currency")
    private String currencyCode;
    @XmlAttribute(name="togetherSID")
    private String togetherServicesId;
    @XmlAttribute(name="oferta")
    private String oferta;
    @XmlAttribute(name="ntmra")
    private Integer notTakeMoneyReachesAmount;
    @XmlElement(name="modules")
    private ServiceModules modules;
    @XmlAttribute(name="icurrency")
    private String incomeCurrencyCode;
    @XmlAttribute(name="auto_process")
    private Integer autoProcessDueToInactivity;
    @XmlAttribute(name="flags")
    private long flags;
    @XmlElement(name="pSource")
    private List<String> paymentSources;
    @XmlElement(name="divsfrom")
    private Sum divideSumFrom;
    @XmlElement(name="divsto")
    private Sum divideSumTo;
    @XmlElement(name="divsround")
    private Sum divideSumRound;
    @XmlAttribute(name="serviceMaskFilename")
    private String serviceMaskFilename;
    @XmlAttribute(name="firstBillEqMins")
    private boolean firstBillEqualsMinSum;
    @XmlAttribute(name="gArea")
    private Integer idGeographicArea;
    @XmlAttribute(name="country")
    private Integer idCountry;
    private Map<String, ServiceLang> langs = new HashMap<String, ServiceLang>();
    private Map<String, String> properties = new HashMap<String, String>();

    public Service() {
    }

    public Service(Service oth) {
        this.id = oth.id;
        this.code = oth.code;
        this.barcodePrefix = oth.barcodePrefix;
        this.name = oth.name;
        this.printName = oth.printName;
        this.altName = oth.altName;
        this.invitation = oth.invitation;
        this.image = oth.image;
        this.minSum = oth.minSum;
        this.maxSum = oth.maxSum;
        this.maxInputSum = oth.maxInputSum;
        this.divideSum = oth.divideSum;
        this.multiplicitySum = oth.multiplicitySum;
        this.verifyType = oth.verifyType;
        this.processingType = oth.processingType;
        this.paymentSchemaFlags = oth.paymentSchemaFlags;
        this.providerType = oth.providerType;
        this.printText = oth.printText;
        this.childServices = oth.childServices;
        this.prepaidSteps = oth.prepaidSteps;
        this.commission = oth.commission;
        this.minComm = oth.minComm;
        this.gpDivComm = oth.gpDivComm;
        this.warning = oth.warning;
        this.checkRender = oth.checkRender;
        this.provider = oth.provider;
        this.operator = oth.operator;
        this.printCheckDialog = oth.printCheckDialog;
        this.changeType = oth.changeType;
        this.style = oth.style;
        this.currencyCode = oth.currencyCode;
        this.togetherServicesId = oth.togetherServicesId;
        this.oferta = oth.oferta;
        this.notTakeMoneyReachesAmount = oth.notTakeMoneyReachesAmount;
        this.modules = oth.modules;
        this.incomeCurrencyCode = oth.incomeCurrencyCode;
        this.flags = oth.flags;
        this.paymentSources = oth.paymentSources;
        this.langs = oth.langs;
        this.properties = oth.properties;
        this.divideSumFrom = oth.divideSumFrom;
        this.divideSumTo = oth.divideSumTo;
        this.divideSumRound = oth.divideSumRound;
        this.serviceMaskFilename = oth.serviceMaskFilename;
        this.firstBillEqualsMinSum = oth.firstBillEqualsMinSum;
        this.idGeographicArea = oth.idGeographicArea;
        this.idCountry = oth.idCountry;
        this.autoProcessDueToInactivity = oth.autoProcessDueToInactivity;
    }

    public List<Short> getChildServices() {
        return this.childServices;
    }

    public void setChildServices(List<Short> childServices) {
        this.childServices = childServices;
    }

    public short getId() {
        return this.id;
    }

    public void setId(short id) {
        this.id = id;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getInvitation() {
        return this.invitation;
    }

    public void setInvitation(String invitation) {
        this.invitation = invitation;
    }

    public Map<String, ServiceLang> getLangs() {
        return this.langs;
    }

    public void setLangs(Map<String, ServiceLang> langs) {
        this.langs = langs;
    }

    public Sum getMaxSum() {
        return this.maxSum;
    }

    public void setMaxSum(Sum maxSum) {
        this.maxSum = maxSum;
    }

    public Sum getMinSum() {
        return this.minSum;
    }

    public void setMinSum(Sum minSum) {
        this.minSum = minSum;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Short getPaperRequire() {
        return this.getPaperCondition();
    }

    public int[] getPrepaidSteps() {
        return this.prepaidSteps;
    }

    public void setPrepaidSteps(int[] prepaidSteps) {
        this.prepaidSteps = prepaidSteps;
    }

    public String getPrintName() {
        return this.printName;
    }

    public void setPrintName(String printName) {
        this.printName = printName;
    }

    public String getPrintText() {
        return this.printText;
    }

    public void setPrintText(String printText) {
        this.printText = printText;
    }

    public ProcessingType getProcessingType() {
        return this.processingType;
    }

    public void setProcessingType(ProcessingType processingType) {
        this.processingType = processingType;
    }

    public ProviderType getProviderType() {
        return this.providerType;
    }

    public void setProviderType(ProviderType providerType) {
        this.providerType = providerType;
    }

    public VerifyType getVerifyType() {
        return this.verifyType;
    }

    public void setVerifyType(VerifyType verifyType) {
        this.verifyType = verifyType;
    }

    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    public Dealer getOperator() {
        return this.operator;
    }

    public void setOperator(Dealer operator) {
        this.operator = operator;
    }

    public Dealer getProvider() {
        return this.provider;
    }

    public void setProvider(Dealer provider) {
        this.provider = provider;
    }

    public short getCode() {
        return this.code;
    }

    public void setCode(short code) {
        this.code = code;
    }

    public String getCheckRender() {
        return this.checkRender;
    }

    public void setCheckRender(String checkRender) {
        this.checkRender = checkRender;
    }

    public Sum getDivideSum() {
        return this.divideSum;
    }

    public void setDivideSum(Sum divideSum) {
        this.divideSum = divideSum;
    }

    public Commission getMaxComm() {
        return this.commission;
    }

    public void setMaxComm(Commission commission) {
        this.commission = commission;
    }

    public Commission getMinComm() {
        return this.minComm;
    }

    public void setMinComm(Commission minComm) {
        this.minComm = minComm;
    }

    public String getBarcodePrefix() {
        return this.barcodePrefix;
    }

    public void setBarcodePrefix(String barcodePrefix) {
        this.barcodePrefix = barcodePrefix;
    }

    public Sum getMultiplicitySum() {
        return this.multiplicitySum;
    }

    public void setMultiplicitySum(Sum multiplicitySum) {
        this.multiplicitySum = multiplicitySum;
    }

    public Sum getMaxInputSum() {
        return this.maxInputSum;
    }

    public void setMaxInputSum(Sum maxInputSum) {
        this.maxInputSum = maxInputSum;
    }

    public String getAltName() {
        return this.altName;
    }

    public void setAltName(String altName) {
        this.altName = altName;
    }

    public short getChangeType() {
        return this.changeType;
    }

    public void setChangeType(short changeType) {
        this.changeType = changeType;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getTogetherServicesId() {
        return this.togetherServicesId;
    }

    public void setTogetherServicesId(String togetherServicesId) {
        this.togetherServicesId = togetherServicesId;
    }

    public String getOferta() {
        return this.oferta;
    }

    public void setOferta(String oferta) {
        this.oferta = oferta;
    }

    public int getPaymentSchemaFlags() {
        return this.paymentSchemaFlags;
    }

    public void setPaymentSchemaFlags(int paymentSchemaFlags) {
        this.paymentSchemaFlags = paymentSchemaFlags;
    }

    public Integer getNotTakeMoneyReachesAmount() {
        return this.notTakeMoneyReachesAmount;
    }

    public void setNotTakeMoneyReachesAmount(Integer notTakeMoneyReachesAmount) {
        this.notTakeMoneyReachesAmount = notTakeMoneyReachesAmount;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getOutCurrency() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public ServiceModules getModules() {
        return this.modules;
    }

    public String getInCurrency() {
        return this.incomeCurrencyCode;
    }

    public void setIncomeCurrencyCode(String incomeCurrencyCode) {
        this.incomeCurrencyCode = incomeCurrencyCode;
    }

    public Boolean getGpDivComm() {
        return this.gpDivComm;
    }

    public void setGpDivComm(Boolean gpDivComm) {
        this.gpDivComm = gpDivComm;
    }

    public Boolean getPrintCheckDialog() {
        return this.printCheckDialog;
    }

    public long getFlags() {
        return this.flags;
    }

    public boolean isFlagExist(long flag) {
        return (this.flags & flag) != 0L;
    }

    public List<String> getPaymentSources() {
        return this.paymentSources;
    }

    public void setPaymentSources(List<String> paymentSources) {
        this.paymentSources = paymentSources;
    }

    public boolean isPrintSingleCheckOnMobileChange() {
        return (this.flags & 0x4000L) != 0L;
    }

    public Sum getDivideSumFrom() {
        return this.divideSumFrom;
    }

    public void setDivideSumFrom(Sum divideSumFrom) {
        this.divideSumFrom = divideSumFrom;
    }

    public Sum getDivideSumTo() {
        return this.divideSumTo;
    }

    public void setDivideSumTo(Sum divideSumTo) {
        this.divideSumTo = divideSumTo;
    }

    public Sum getDivideSumRound() {
        return this.divideSumRound;
    }

    public void setDivideSumRound(Sum divideSumRound) {
        this.divideSumRound = divideSumRound;
    }

    public short getPaperCondition() {
        if (!this.isFlagExist(65536L) && this.isFlagExist(131072L)) {
            return 0;
        }
        if (this.isFlagExist(65536L)) {
            return 1;
        }
        if (!this.isFlagExist(65536L) && !this.isFlagExist(131072L)) {
            return 2;
        }
        if (this.isFlagExist(65536L) && this.isFlagExist(262144L)) {
            return 3;
        }
        if (this.isFlagExist(524288L)) {
            return 4;
        }
        return 2;
    }

    public String getServiceMaskFilename() {
        return this.serviceMaskFilename;
    }

    public void setServiceMaskFilename(String serviceMaskFilename) {
        this.serviceMaskFilename = serviceMaskFilename;
    }

    public boolean isFirstBillEqualsMinSum() {
        return this.firstBillEqualsMinSum;
    }

    public void setFirstBillEqualsMinSum(boolean firstBillEqualsMinSum) {
        this.firstBillEqualsMinSum = firstBillEqualsMinSum;
    }

    public Integer getIdGeographicArea() {
        return this.idGeographicArea;
    }

    public void setIdGeographicArea(Integer idGeographicArea) {
        this.idGeographicArea = idGeographicArea;
    }

    public Integer getIdCountry() {
        return this.idCountry;
    }

    public void setIdCountry(Integer idCountry) {
        this.idCountry = idCountry;
    }

    public Integer getAutoProcessDueToInactivity() {
        return this.autoProcessDueToInactivity;
    }

    public void setAutoProcessDueToInactivity(Integer autoProcessDueToInactivity) {
        this.autoProcessDueToInactivity = autoProcessDueToInactivity;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Service other = (Service)obj;
        return this.id == other.id;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.id;
        return hash;
    }

    public String toString() {
        return "Service{id=" + this.id + ", code=" + this.code + ", barcodePrefix=" + this.barcodePrefix + ", name=" + this.name + ", shortName=" + this.shortName + ", fullName=" + this.fullName + ", printName=" + this.printName + ", altName=" + this.altName + ", invitation=" + this.invitation + ", image=" + this.image + ", minSum=" + this.minSum + ", maxSum=" + this.maxSum + ", maxInputSum=" + this.maxInputSum + ", divideSum=" + this.divideSum + ", multiplicitySum=" + this.multiplicitySum + ", verifyType=" + (Object)((Object)this.verifyType) + ", processingType=" + (Object)((Object)this.processingType) + ", paymentSchemaFlags=" + this.paymentSchemaFlags + ", providerType=" + (Object)((Object)this.providerType) + ", printText=" + this.printText + ", childServices=" + this.childServices + ", prepaidSteps=" + Arrays.toString(this.prepaidSteps) + ", commission=" + this.commission + ", minComm=" + this.minComm + ", gpDivComm=" + this.gpDivComm + ", warning=" + this.warning + ", checkRender=" + this.checkRender + ", provider=" + this.provider + ", operator=" + this.operator + ", printCheckDialog=" + this.printCheckDialog + ", changeType=" + this.changeType + ", style=" + this.style + ", currencyCode=" + this.currencyCode + ", togetherServicesId=" + this.togetherServicesId + ", oferta=" + this.oferta + ", notTakeMoneyReachesAmount=" + this.notTakeMoneyReachesAmount + ", modules=" + this.modules + ", auto-process=" + this.autoProcessDueToInactivity + ", incomeCurrencyCode=" + this.incomeCurrencyCode + ", flags=" + this.flags + ", paymentSources=" + this.paymentSources + ", langs=" + this.langs + ", properties=" + this.properties + ", serviceMaskFilename=" + this.serviceMaskFilename + ", firstBillEqualsMinSum=" + this.firstBillEqualsMinSum + ", idGeographicArea=" + this.idGeographicArea + ", idCountry=" + this.idCountry + '}';
    }
}

