/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.reference.menu;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Objects;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.cash.unit.CashUnitProfile;
import ru.softlogic.reference.menu.MenuItemSchedule;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.service.comission.Commission;

public class MenuItem
implements Serializable {
    static final long serialVersionUID = 2440727064982518595L;
    public static final short FLAG_SPEC_BUTTON = 1;
    public static final short FLAG_ONLINE_ON_FAIL = 2;
    public static final short FLAG_ONLINE_VERIFY = 4;
    public static final short FLAG_DISPLAY_COMMISSION_TAG = 8;
    private int idMenuItem;
    private Service service;
    private Commission commission;
    private Short hotkeyPosition;
    private short sortOrder;
    private short flags;
    private CashUnit[] units;
    private MenuItemSchedule[] schedules;
    private boolean hideUnactive;
    private boolean ignoreMinMaxCommission;
    private String serviceMaskFilename;
    private String logoAlt;
    private ServiceType serviceType;
    private CashUnitProfile cashUnitProfile;

    public MenuItem() {
    }

    public MenuItem(MenuItem oth) {
        if (oth == null) {
            return;
        }
        this.idMenuItem = oth.idMenuItem;
        this.service = oth.service != null ? new Service(oth.service) : null;
        this.commission = oth.commission != null ? new Commission(oth.commission) : null;
        this.hotkeyPosition = oth.hotkeyPosition;
        this.sortOrder = oth.sortOrder;
        this.flags = oth.flags;
        this.units = oth.units != null ? Arrays.copyOf(oth.units, oth.units.length) : null;
        this.schedules = oth.schedules != null ? Arrays.copyOf(oth.schedules, oth.units.length) : null;
        this.hideUnactive = oth.hideUnactive;
        this.ignoreMinMaxCommission = oth.ignoreMinMaxCommission;
        this.serviceMaskFilename = oth.serviceMaskFilename;
        this.logoAlt = oth.logoAlt;
        this.serviceType = oth.serviceType != null ? new ServiceType(oth.serviceType) : null;
        this.cashUnitProfile = oth.cashUnitProfile != null ? new CashUnitProfile(oth.cashUnitProfile) : null;
    }

    public void update(MenuItem oth) {
        this.idMenuItem = oth.idMenuItem;
        this.service = oth.service;
        this.commission = oth.commission;
        this.hotkeyPosition = oth.hotkeyPosition;
        this.sortOrder = oth.sortOrder;
        this.flags = oth.flags;
        this.units = oth.units;
        this.schedules = oth.schedules;
        this.hideUnactive = oth.hideUnactive;
        this.ignoreMinMaxCommission = oth.ignoreMinMaxCommission;
        this.serviceMaskFilename = oth.serviceMaskFilename;
        this.logoAlt = oth.logoAlt;
        this.serviceType = oth.serviceType;
        this.cashUnitProfile = oth.cashUnitProfile;
    }

    public int getIdMenuItem() {
        return this.idMenuItem;
    }

    public void setIdMenuItem(int idMenuItem) {
        this.idMenuItem = idMenuItem;
    }

    public boolean hasFlag(int flag) {
        return (this.flags & flag) > 0;
    }

    public Commission getCommission() {
        return this.commission;
    }

    public void setCommission(Commission commission) {
        this.commission = commission;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public CashUnit[] getUnits() {
        return this.units;
    }

    public void setUnits(CashUnit[] units) {
        this.units = units;
    }

    public short getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(short sortOrder) {
        this.sortOrder = sortOrder;
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public Short getHotkeyPosition() {
        return this.hotkeyPosition;
    }

    public void setHotkeyPosition(Short hotkeyPosition) {
        this.hotkeyPosition = hotkeyPosition;
    }

    public MenuItemSchedule[] getSchedules() {
        return this.schedules;
    }

    public void setSchedules(MenuItemSchedule[] schedules) {
        this.schedules = schedules;
    }

    public boolean isHideUnactive() {
        return this.hideUnactive;
    }

    public void setHideUnactive(boolean hideUnactive) {
        this.hideUnactive = hideUnactive;
    }

    public boolean isIgnoreMinMaxCommission() {
        return this.ignoreMinMaxCommission;
    }

    public void setIgnoreMinMaxCommission(boolean ignoreMinMaxCommission) {
        this.ignoreMinMaxCommission = ignoreMinMaxCommission;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + this.idMenuItem;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MenuItem other = (MenuItem)obj;
        if (this.idMenuItem > 0) {
            return this.idMenuItem == other.idMenuItem;
        }
        if (!Objects.equals(this.service, other.service)) {
            return false;
        }
        return Objects.equals(this.commission, other.commission);
    }

    public boolean isDisableOnSchedule() {
        if (this.schedules == null) {
            return false;
        }
        LocalDateTime now = LocalDateTime.now();
        MenuItemSchedule schedule = Arrays.asList(this.schedules).stream().filter(s -> s.getDate() != null).filter(s -> s.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().isEqual(now.toLocalDate())).findFirst().orElse(null);
        if (schedule == null) {
            schedule = Arrays.asList(this.schedules).stream().filter(s -> s.getDay() != null).filter(s -> (s.getDay() - 1 == 0 ? 7 : s.getDay() - 1) == now.toLocalDate().getDayOfWeek().getValue()).findFirst().orElse(null);
        }
        if (schedule == null) {
            return false;
        }
        LocalTime from = LocalTime.of(schedule.getFromHour(), 0);
        LocalTime to = schedule.getDuratuionHours() != null ? LocalTime.ofSecondOfDay(Math.min((schedule.getFromHour() + schedule.getDuratuionHours()) * 3600, 86399)) : LocalTime.ofSecondOfDay(Math.min(schedule.getToHour() * 3600, 86399));
        return !now.toLocalTime().isAfter(from) && now.toLocalTime().isBefore(to);
    }

    public String getServiceMaskFilename() {
        return this.serviceMaskFilename;
    }

    public void setServiceMaskFilename(String serviceMaskFilename) {
        this.serviceMaskFilename = serviceMaskFilename;
    }

    public String getLogoAlt() {
        return this.logoAlt;
    }

    public void setLogoAlt(String logoAlt) {
        this.logoAlt = logoAlt;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public CashUnitProfile getCashUnitProfile() {
        return this.cashUnitProfile;
    }

    public void setCashUnitProfile(CashUnitProfile cashUnitProfile) {
        this.cashUnitProfile = cashUnitProfile;
    }

    public String toString() {
        return "MenuItem{service=" + this.service + ", commission=" + this.commission + ", hotkeyPosition=" + this.hotkeyPosition + ", sortOrder=" + this.sortOrder + ", flags=" + this.flags + ", units=" + Arrays.toString(this.units) + ", hideUnactive=" + this.hideUnactive + ", ignoreMinMaxCommission=" + this.ignoreMinMaxCommission + ", serviceType=" + this.serviceType + ", cashUnitProfile=" + this.cashUnitProfile + '}';
    }
}

