/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.reference.exchange;

import java.io.Serializable;
import ru.softlogic.cash.unit.CashUnitProfile;

public class ExchangeRule
implements Serializable,
Comparable<ExchangeRule> {
    private static final long serialVersionUID = 1631479852239542358L;
    private final Integer id;
    private final CashUnitProfile cashUnitProfile;
    private final int acceptedSum;
    private final Integer acceptedSumMax;
    private final int prefDispensedSum;
    private final Integer minDispensedSum;
    private final Integer maxDispensedSum;
    private final boolean hot;
    private final boolean enable;

    public ExchangeRule(Integer id, int acceptedSum, Integer acceptedSumMax, int prefDispensedSum, Integer minDispensedSum, Integer maxDispensedSum, CashUnitProfile cashUnitProfile, boolean enable, boolean hot) {
        this.id = id;
        this.cashUnitProfile = cashUnitProfile;
        this.acceptedSum = acceptedSum;
        this.acceptedSumMax = acceptedSumMax;
        this.prefDispensedSum = prefDispensedSum;
        this.minDispensedSum = minDispensedSum;
        this.maxDispensedSum = maxDispensedSum;
        this.enable = enable;
        this.hot = hot;
    }

    public Integer getId() {
        return this.id;
    }

    public CashUnitProfile getCashUnitProfile() {
        return this.cashUnitProfile;
    }

    public static long getSerialVersionUID() {
        return 1631479852239542358L;
    }

    public int getAcceptedSum() {
        return this.acceptedSum;
    }

    public Integer getAcceptedSumMax() {
        return this.acceptedSumMax;
    }

    public int getPrefDispensedSum() {
        return this.prefDispensedSum;
    }

    public Integer getMinDispensedSum() {
        return this.minDispensedSum;
    }

    public Integer getMaxDispensedSum() {
        return this.maxDispensedSum;
    }

    public boolean isHot() {
        return this.hot;
    }

    public boolean isEnable() {
        return this.enable;
    }

    @Override
    public int compareTo(ExchangeRule rule) {
        if (rule.hot ^ this.hot) {
            return this.hot ? -1 : 1;
        }
        return Integer.compare(this.acceptedSum, rule.acceptedSum);
    }

    public String toString() {
        return "ExchangeRule{id=" + this.id + ", cashUnitProfile=" + this.cashUnitProfile + ", acceptedSum=" + this.acceptedSum + ", acceptedSumMax=" + this.acceptedSumMax + ", prefDispensedSum=" + this.prefDispensedSum + ", minDispensedSum=" + this.minDispensedSum + ", maxDispensedSum=" + this.maxDispensedSum + ", hot=" + this.hot + ", enable=" + this.enable + '}';
    }
}

