/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.reference.exchange;

import java.io.Serializable;
import java.util.Set;
import ru.softlogic.reference.exchange.ExchangeRule;

public class ExchangeRange
implements Serializable,
Comparable<ExchangeRange> {
    private static final long serialVersionUID = 7412399852239542358L;
    private int id;
    private double from;
    private double to;
    private boolean enable;
    private Set<ExchangeRule> rules;

    public ExchangeRange(double from, double to, Set<ExchangeRule> rules, boolean enable) {
        if (from < 0.0 || to <= 0.0 || from >= to) {
            throw new IllegalArgumentException("Restrictions range are incorrect");
        }
        if (rules == null || rules.isEmpty()) {
            throw new IllegalArgumentException("Exchange rules is not set");
        }
        this.from = from;
        this.to = to;
        this.rules = rules;
        this.enable = enable;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public double getFrom() {
        return this.from;
    }

    public void setFrom(double from) {
        this.from = from;
    }

    public double getTo() {
        return this.to;
    }

    public void setTo(double to) {
        this.to = to;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public Set<ExchangeRule> getRules() {
        return this.rules;
    }

    public boolean isContain(double value) {
        return this.from <= value && value < this.to;
    }

    public void setRules(Set<ExchangeRule> rules) {
        this.rules = rules;
    }

    public String toString() {
        return "ExchangeRange{id=" + this.id + ", from=" + this.from + ", to=" + this.to + ", enable=" + this.enable + ", rules=" + this.rules + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExchangeRange that = (ExchangeRange)o;
        if (this.id != that.id) {
            return false;
        }
        if (Double.compare(that.from, this.from) != 0) {
            return false;
        }
        if (Double.compare(that.to, this.to) != 0) {
            return false;
        }
        if (this.enable != that.enable) {
            return false;
        }
        return !(this.rules == null ? that.rules != null : !this.rules.equals(that.rules));
    }

    public int hashCode() {
        int result = this.id;
        long temp = Double.doubleToLongBits(this.from);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.to);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.enable ? 1 : 0);
        result = 31 * result + (this.rules != null ? this.rules.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(ExchangeRange range) {
        return Double.compare(this.from, range.from);
    }
}

