/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.reference.exchange;

import java.io.Serializable;
import java.util.List;
import ru.softlogic.cash.unit.CashUnitProfile;
import ru.softlogic.reference.exchange.ExchangeCurrencies;
import ru.softlogic.reference.exchange.ExchangeRange;
import ru.softlogic.reference.exchange.ExchangeSumInRule;
import ru.softlogic.reference.exchange.ExchangeSumOutRule;

public class ExchangeDirection
implements Serializable,
Comparable<ExchangeDirection> {
    public static final int HANDLER_RANGES = 0;
    public static final int HANDLER_IN_SUM = 1;
    public static final int HANDLER_OUT_SUM = 2;
    public static final int FLAG_PREFER_CASH_CHANGE = 1;
    public static final int FLAG_ALLOW_EXCHANGE_FREE_SUM = 2;
    public static final int FLAG_ENTER_SUM_REQUIRE = 4;
    public static final int FLAG_EXCHANGE_ENTIRE_AMOUNT = 8;
    private static final long serialVersionUID = 4567199852239542358L;
    private final Integer id;
    private final CashUnitProfile cashUnitProfile;
    private final boolean enable;
    private final int sortOrder;
    private final int handlerType;
    private final List<ExchangeRange> rangeRules;
    private final List<ExchangeSumInRule> inRules;
    private final List<ExchangeSumOutRule> outRules;
    private final int flags;
    private final double commission;
    private final Integer minSum;
    private final Integer maxSum;
    private final String changeCurrency;
    private final ExchangeCurrencies currencies;

    public ExchangeDirection(Integer id, ExchangeCurrencies currencies, CashUnitProfile cashUnitProfile, boolean enable, int sortOrder, int handlerType, List<ExchangeRange> rangeRules, List<ExchangeSumInRule> inRules, List<ExchangeSumOutRule> outRules, int flags, double commission, Integer minSum, Integer maxSum, String changeCurrency) {
        if (currencies == null) {
            throw new IllegalArgumentException("Currency profile is not set");
        }
        this.id = id;
        this.currencies = currencies;
        this.rangeRules = rangeRules;
        this.inRules = inRules;
        this.outRules = outRules;
        this.cashUnitProfile = cashUnitProfile;
        this.enable = enable;
        this.sortOrder = sortOrder;
        this.handlerType = handlerType;
        this.flags = flags;
        this.commission = commission;
        this.minSum = minSum;
        this.maxSum = maxSum;
        this.changeCurrency = changeCurrency;
    }

    public CashUnitProfile getCashUnitProfile() {
        return this.cashUnitProfile;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean getEnable() {
        return this.enable;
    }

    public ExchangeCurrencies getCurrencies() {
        return this.currencies;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public Integer getMinSum() {
        return this.minSum;
    }

    public Integer getMaxSum() {
        return this.maxSum;
    }

    public Integer getId() {
        return this.id;
    }

    public int getHandlerType() {
        return this.handlerType;
    }

    public int getFlags() {
        return this.flags;
    }

    public double getCommission() {
        return this.commission;
    }

    public String getChangeCurrency() {
        return this.changeCurrency;
    }

    public List<ExchangeRange> getRangeRules() {
        return this.rangeRules;
    }

    public List<ExchangeSumInRule> getInRules() {
        return this.inRules;
    }

    public List<ExchangeSumOutRule> getOutRules() {
        return this.outRules;
    }

    public boolean hasFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    @Override
    public int compareTo(ExchangeDirection direction) {
        if (this.sortOrder != direction.getSortOrder()) {
            return Integer.compare(this.sortOrder, direction.getSortOrder());
        }
        return this.currencies.getCurrencyFrom().compareTo(direction.getCurrencies().getCurrencyFrom());
    }

    public String toString() {
        return "ExchangeDirection{id=" + this.id + ", cashUnitProfile=" + this.cashUnitProfile + ", enable=" + this.enable + ", sortOrder=" + this.sortOrder + ", handlerType=" + this.handlerType + ", rangeRules=" + this.rangeRules + ", inRules=" + this.inRules + ", outRules=" + this.outRules + ", flags=" + this.flags + ", commission=" + this.commission + ", minSum=" + this.minSum + ", maxSum=" + this.maxSum + ", changeCurrency=" + this.changeCurrency + ", currencies=" + this.currencies + '}';
    }
}

