/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.reference;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Set;
import ru.softlogic.reference.ReferenceData;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.References;
import ru.softlogic.reference.ReferencesListener;

public class ReferencesIO {
    public static final String NAME = "references.pst";
    private static final Set<ReferencesListener> listeners = new HashSet<ReferencesListener>();

    public static void addListener(ReferencesListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener is not set");
        }
        listeners.add(listener);
    }

    public static synchronized void load(File path) {
        if (path == null) {
            throw new IllegalStateException("Path is not set");
        }
        if (path.exists() && path.isFile()) {
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(path));){
                Object obj = ois.readObject();
                if (obj instanceof ReferenceData) {
                    IntReferences.setData((ReferenceData)obj);
                }
            }
            catch (IOException | ClassCastException | ClassNotFoundException exception) {
                // empty catch block
            }
        }
    }

    public static synchronized void save(File path) throws ReferenceException {
        for (ReferencesListener listener : listeners) {
            listener.onReferences(IntReferences.getData());
        }
        if (path == null) {
            throw new ReferenceException("Path is not set");
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(path));){
            oos.writeObject(IntReferences.getData());
        }
        catch (Exception ex) {
            throw new ReferenceException(ex);
        }
    }

    private static class IntReferences
    extends References {
        private IntReferences() {
        }

        public static void setData(ReferenceData data) {
            References.data = data;
        }

        public static ReferenceData getData() {
            return data;
        }
    }
}

