/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.operation;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.operation.CashlessData;
import ru.softlogic.operation.TableItem;
import ru.softlogic.reference.fraud.FraudControlRule;
import ru.softlogic.reference.point.Bank;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.point.PaymentSystem;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.SumResult;

public class Operation
implements Serializable {
    static final long serialVersionUID = 5587199856230760758L;
    public static final int PAYMENT_TOOL_CASH = 0;
    public static final int PAYMENT_TOOL_CASHLESS = 1;
    public static final int FLAG_DOC_NOT_PRINTED = 1;
    public static final int FLAG_DOC_COPY = 2;
    public static final int FLAG_ONLINE_PAYMENT = 16;
    public static final int FLAG_FISCAL_PAYMENT = 32;
    public static final int FLAG_FRAUD_BLOCKING = 64;
    public static final int FLAG_SMS_AGREE = 128;
    public static final int FLAG_SAFE_SERVICE = 256;
    public static final int SEND_SMS_CHECK = 512;
    public static final int FLAG_ZERO_AMOUNT = 1024;
    public static final int FLAG_PAYMENT_FIXED_SUM = 2048;
    private int idOperation;
    private int checkNumber;
    private ServiceType serviceType;
    private Service service;
    private Commission commission;
    private Date date;
    private Date changeDate;
    private transient long time;
    private Map<String, InputElement> inputElements;
    private Map<String, String> form;
    private Map<String, String> views;
    private Map<String, String> titles;
    private Keeper keeper;
    private Keeper change;
    private SumResult sumResult;
    private String pinCode;
    private Sum pinCodeNominal;
    private TableItem[] tableItems;
    private Point point;
    private Dealer dealer;
    private PaymentSystem paymentSystem;
    private Bank bank;
    private boolean copy;
    private Locale locale;
    private int paymentTool;
    private CashlessData cashlessData;
    private int flags;
    private boolean unknownProcessResult;
    private long lastProcess;
    private String feHash;
    private FraudControlRule fraudControlRule;

    public Operation() {
        this.date = new Date();
        this.inputElements = new LinkedHashMap<String, InputElement>();
        this.form = new LinkedHashMap<String, String>();
        this.views = new LinkedHashMap<String, String>();
        this.titles = new LinkedHashMap<String, String>();
    }

    public Operation(Operation oth) {
        if (oth != null) {
            this.idOperation = oth.idOperation;
            this.checkNumber = oth.checkNumber;
            this.service = oth.service;
            this.serviceType = oth.serviceType;
            this.commission = oth.commission;
            this.date = oth.date;
            this.inputElements = new LinkedHashMap<String, InputElement>(oth.getInputElements());
            this.form = new LinkedHashMap<String, String>(oth.form);
            this.views = new LinkedHashMap<String, String>(oth.views);
            this.titles = new LinkedHashMap<String, String>(oth.titles);
            this.keeper = oth.keeper;
            this.change = oth.change;
            this.sumResult = new SumResult(oth.sumResult);
            this.pinCode = oth.pinCode;
            this.pinCodeNominal = oth.pinCodeNominal;
            this.locale = oth.locale;
            this.feHash = oth.feHash;
            this.fraudControlRule = oth.fraudControlRule;
        }
    }

    public int getCheckNumber() {
        return this.checkNumber;
    }

    public void setCheckNumber(int checkNumber) {
        this.checkNumber = checkNumber;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int getPaymentTool() {
        return this.paymentTool;
    }

    public void setPaymentTool(int paymentTool) {
        this.paymentTool = paymentTool;
    }

    public CashlessData getCashlessData() {
        return this.cashlessData;
    }

    public void setCashlessData(CashlessData cashlessData) {
        this.cashlessData = cashlessData;
    }

    public Date getDate() {
        return this.date;
    }

    public int getIdOperation() {
        return this.idOperation;
    }

    public void setIdOperation(int idOperation) {
        this.idOperation = idOperation;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public Keeper getChange() {
        return this.change;
    }

    public void setChange(Keeper change) {
        this.change = change;
    }

    public Keeper getKeeper() {
        return this.keeper;
    }

    public void setKeeper(Keeper keeper) {
        this.keeper = keeper;
    }

    public SumResult getSumResult() {
        return this.sumResult;
    }

    public void setSumResult(SumResult sumResult) {
        this.sumResult = sumResult;
    }

    public String getPinCode() {
        return this.pinCode;
    }

    public void setPinCode(String pinCode) {
        this.pinCode = pinCode;
    }

    public Commission getCommission() {
        return this.commission;
    }

    public void setCommission(Commission commission) {
        this.commission = commission;
    }

    public Map<String, String> getForm() {
        return this.form;
    }

    public Map<String, String> getViews() {
        return this.views;
    }

    public Map<String, String> getTitles() {
        return this.titles;
    }

    public void setTitles(Map<String, String> titles) {
        this.titles = titles;
    }

    public TableItem[] getTableItems() {
        return this.tableItems;
    }

    public void setTableItems(TableItem[] tableItems) {
        this.tableItems = tableItems;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public Dealer getDealer() {
        return this.dealer;
    }

    public void setDealer(Dealer dealer) {
        this.dealer = dealer;
    }

    public PaymentSystem getPaymentSystem() {
        return this.paymentSystem;
    }

    public void setPaymentSystem(PaymentSystem paymentSystem) {
        this.paymentSystem = paymentSystem;
    }

    public Point getPoint() {
        return this.point;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean hasFlag(int flag) {
        return (this.flags & flag) > 0;
    }

    public long getLastProcess() {
        return this.lastProcess;
    }

    public void setLastProcess(long lastProcess) {
        this.lastProcess = lastProcess;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Operation other = (Operation)obj;
        if (this.idOperation != other.idOperation) {
            return false;
        }
        if (this.checkNumber != other.checkNumber) {
            return false;
        }
        return this.date == other.date || this.date != null && this.date.equals(other.date);
    }

    public boolean isCopy() {
        return this.copy;
    }

    public void setCopy(boolean copy) {
        this.copy = copy;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Sum getPinCodeNominal() {
        return this.pinCodeNominal;
    }

    public void setPinCodeNominal(Sum pinCodeNominal) {
        this.pinCodeNominal = pinCodeNominal;
    }

    public boolean isUnknownProcessResult() {
        return this.unknownProcessResult;
    }

    public void setUnknownProcessResult(boolean unknownProcessResult) {
        this.unknownProcessResult = unknownProcessResult;
    }

    public Date getChangeDate() {
        return this.changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public Map<String, InputElement> getInputElements() {
        return this.inputElements;
    }

    public String getFeHash() {
        return this.feHash;
    }

    public void setFeHash(String feHash) {
        this.feHash = feHash;
    }

    public FraudControlRule getFraudControlRule() {
        return this.fraudControlRule;
    }

    public void setFraudControlRule(FraudControlRule fraudControlRule) {
        this.fraudControlRule = fraudControlRule;
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + this.idOperation;
        hash = 47 * hash + this.checkNumber;
        hash = 47 * hash + (this.date != null ? this.date.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "Operation[service=" + this.service.getName() + ", inputElements=" + this.inputElements + ", form=" + this.form + ", views=" + this.views + ", titles=" + this.titles + ", id=" + this.idOperation + ", check=" + this.checkNumber + ", pinCode=" + this.pinCode + ", pinCodeNominal=" + this.pinCodeNominal + ", date=" + this.date + ", change-date=" + this.changeDate + ", fraudControlRule=" + this.fraudControlRule + "]";
    }
}

