/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.cash.unit;

import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.IdentityMoneyUnit;

public class CashUnit
extends IdentityMoneyUnit {
    private static final long serialVersionUID = 2206386566200628873L;
    public static final int VIRTUAL = 2;
    public static final int NOTE = 3;
    public static final int COIN = 4;
    private int type;

    public CashUnit(int id, Sum nominal, int type) {
        super(id, nominal);
        if (type != 3 && type != 4 && type != 2) {
            throw new IllegalArgumentException("Type " + type + " is not supported");
        }
        this.type = type;
    }

    public CashUnit(int id, Sum nominal) {
        this(id, nominal, 3);
    }

    public int getType() {
        return this.type;
    }

    @Override
    public int compareTo(IdentityMoneyUnit o) {
        if (!this.nominal.equals(o.nominal)) {
            return this.nominal.compareTo(o.nominal);
        }
        CashUnit oth = (CashUnit)o;
        return oth.type - this.type;
    }

    @Override
    public String toString() {
        return "CashUnit[id=" + this.id + ",nominal=" + this.nominal + ",type=" + (this.type == 3 ? "note" : (this.type == 4 ? "coin" : "virtual")) + ']';
    }
}

