/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.cash;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Sum", namespace="http://soft-logic.ru")
public class Sum
implements Comparable<Sum>,
Serializable {
    static final long serialVersionUID = -8630614555296427348L;
    @XmlAttribute(name="c")
    private String currency;
    @XmlAttribute(name="s")
    private int sum;

    @Deprecated
    public Sum() {
    }

    public Sum(int value, String currency) {
        if (value < 0) {
            throw new IllegalArgumentException("Value must be equals or great zero");
        }
        if (currency == null) {
            throw new IllegalArgumentException("Currency is not set");
        }
        if (!currency.matches("[A-Z]{3}")) {
            throw new IllegalArgumentException("Currency is wrong: " + currency + "," + currency.matches("[A-Z]+"));
        }
        this.sum = value;
        this.currency = currency;
    }

    public Sum(Sum sum) {
        if (sum == null) {
            throw new NullPointerException("Sum is null");
        }
        this.sum = sum.sum;
        this.currency = sum.currency;
    }

    public int getValue() {
        return this.sum;
    }

    public String getCurrency() {
        return this.currency;
    }

    public Sum add(Sum oth) {
        this.check(oth);
        return new Sum(this.sum + oth.getValue(), this.currency);
    }

    public Sum sub(Sum oth) {
        this.check(oth);
        return new Sum(this.sum - oth.getValue(), this.currency);
    }

    public Sum mul(double multiplier) {
        return new Sum((int)Math.round((double)this.getValue() * multiplier), this.currency);
    }

    public Sum div(double divider) {
        return new Sum((int)Math.round((double)this.getValue() / divider), this.currency);
    }

    public Sum divRest(Sum divSum) {
        if (divSum == null) {
            throw new IllegalArgumentException("Other sum is null");
        }
        return new Sum(this.sum % divSum.sum, this.currency);
    }

    public boolean isEmpty() {
        return this.sum == 0;
    }

    @Override
    public int compareTo(Sum other) {
        this.check(other);
        return (int)Math.signum(this.sum - other.sum);
    }

    private void check(Sum oth) {
        if (oth == null) {
            throw new IllegalArgumentException("Other sum is null");
        }
        if (!this.currency.equals(oth.getCurrency())) {
            throw new IllegalArgumentException("Wrong currencies. Has: " + this.currency + ", oth: " + oth.currency);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sum other = (Sum)obj;
        if (this.currency == null ? other.currency != null : !this.currency.equals(other.currency)) {
            return false;
        }
        return this.sum == other.sum;
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + (this.currency != null ? this.currency.hashCode() : 0);
        hash = 47 * hash + this.sum;
        return hash;
    }

    public String toString() {
        return "Sum{" + this.sum + " " + this.currency + '}';
    }
}

