/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.cash;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ru.softlogic.cash.BoxId;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.reference.exchange.CashBoxContent;

public class Keeper
implements Serializable {
    static final long serialVersionUID = -2239565873386617678L;
    public static final BoxId VIRTUAL_BOX = new BoxId(100, 0, 0);
    private final Map<CashUnit, Integer> cashUnits;
    private final Map<BoxId, List<CashBoxContent>> cashBoxesContents;
    private final List<CashBackCard> cashBackCards;
    private Date created;

    public Keeper() {
        this.cashUnits = new HashMap<CashUnit, Integer>();
        this.cashBoxesContents = new HashMap<BoxId, List<CashBoxContent>>();
        this.cashBackCards = new LinkedList<CashBackCard>();
        this.created = new Date();
    }

    public Keeper(Keeper oth) {
        if (oth != null) {
            this.cashUnits = new HashMap<CashUnit, Integer>(oth.getCashUnits());
            this.cashBackCards = new LinkedList<CashBackCard>(oth.getCashBackCards());
            this.created = new Date(oth.getCreated().getTime());
            this.cashBoxesContents = new HashMap<BoxId, List<CashBoxContent>>(oth.getCashBoxes());
        } else {
            this.cashUnits = new HashMap<CashUnit, Integer>();
            this.cashBoxesContents = new HashMap<BoxId, List<CashBoxContent>>();
            this.cashBackCards = new LinkedList<CashBackCard>();
            this.created = new Date();
        }
    }

    public final synchronized void addPayback(Sum payback) {
        int k2;
        int m = payback.getValue();
        int k1 = m / 100000;
        if (k1 > 0) {
            this.addCash(VIRTUAL_BOX, new CashUnit(1002, new Sum(100000, payback.getCurrency()), 2), k1);
            m -= k1 * 100000;
        }
        if ((k2 = m / 100) > 0) {
            this.addCash(VIRTUAL_BOX, new CashUnit(1001, new Sum(100, payback.getCurrency()), 2), k2);
            m -= k2 * 100;
        }
        if (m > 0) {
            this.addCash(VIRTUAL_BOX, new CashUnit(1000, new Sum(1, payback.getCurrency()), 2), m);
        }
    }

    public final synchronized void addCash(BoxId boxId, CashUnit cu) {
        this.addCash(boxId, cu, 1);
    }

    public void addCash(BoxId boxId, CashUnit cu, int count) {
        Integer value = this.cashUnits.getOrDefault(cu, 0);
        this.cashUnits.put(cu, value + count);
        if (boxId != null) {
            List<CashBoxContent> boxContents = this.cashBoxesContents.get(boxId);
            if (boxContents != null) {
                boxContents.add(new CashBoxContent(cu, count));
            } else {
                ArrayList<CashBoxContent> list = new ArrayList<CashBoxContent>();
                list.add(new CashBoxContent(cu, count));
                this.cashBoxesContents.put(boxId, list);
            }
        }
    }

    public final synchronized void addCashBackCard(CashBackCard cbc) {
        this.cashBackCards.add(cbc);
    }

    public final synchronized List<CashBackCard> getCashBackCards() {
        return Collections.unmodifiableList(this.cashBackCards);
    }

    public final synchronized Map<CashUnit, Integer> getCashUnits() {
        return this.cashUnits;
    }

    public Map<BoxId, List<CashBoxContent>> getCashBoxes() {
        return this.cashBoxesContents;
    }

    public final synchronized Sum getSum() {
        int sum = 0;
        String curr = "RUB";
        if (!this.cashBoxesContents.isEmpty()) {
            for (List list : this.cashBoxesContents.values()) {
                for (CashBoxContent cashBoxContent : list) {
                    Sum nominal = cashBoxContent.getCashUnit().getNominal();
                    sum += nominal.getValue() * cashBoxContent.getCashUnitCount();
                    curr = nominal.getCurrency();
                }
            }
        } else {
            for (CashUnit cashUnit : this.cashUnits.keySet()) {
                sum += cashUnit.getNominal().getValue() * this.cashUnits.get(cashUnit);
                curr = cashUnit.getNominal().getCurrency();
            }
        }
        for (CashBackCard cashBackCard : this.cashBackCards) {
            if (cashBackCard == null) {
                throw new NullPointerException("" + this.cashBackCards);
            }
            sum += cashBackCard.getNominal().getValue();
            curr = cashBackCard.getNominal().getCurrency();
        }
        return new Sum(sum, curr);
    }

    public synchronized Sum getCashSum() {
        int sum = 0;
        String curr = "RUB";
        for (CashUnit cu : this.cashUnits.keySet()) {
            if (cu.getType() == 2) continue;
            sum += cu.getNominal().getValue() * this.cashUnits.get(cu);
            curr = cu.getNominal().getCurrency();
        }
        return new Sum(sum, curr);
    }

    public synchronized Sum getCashlessSum() {
        int sum = 0;
        String curr = "RUB";
        for (CashUnit cu : this.cashUnits.keySet()) {
            if (cu.getType() != 2) continue;
            sum += cu.getNominal().getValue() * this.cashUnits.get(cu);
            curr = cu.getNominal().getCurrency();
        }
        for (CashBackCard cbc : this.cashBackCards) {
            sum += cbc.getNominal().getValue();
            curr = cbc.getNominal().getCurrency();
        }
        return new Sum(sum, curr);
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public boolean isEmpty() {
        return this.cashUnits.isEmpty() && this.cashBackCards.isEmpty();
    }

    public String toString() {
        return "Keeper{cashUnits=" + this.cashUnits + ", cashBoxesContents=" + this.cashBoxesContents + ", cashBackCards=" + this.cashBackCards + ", created=" + this.created + '}';
    }
}

