/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keyclient;

import java.io.UnsupportedEncodingException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base64;
import ru.softlogic.keyclient.GenerateException;

public class X509Generator {
    public static EncodedKeyPair generatePrivateKey() throws GenerateException {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(1024, new SecureRandom());
            KeyPair pair = generator.genKeyPair();
            String privateKey = new String(Base64.encodeBase64((byte[])pair.getPrivate().getEncoded(), (boolean)true), "utf-8");
            String publicKey = new String(Base64.encodeBase64((byte[])pair.getPublic().getEncoded(), (boolean)true), "utf-8");
            return new EncodedKeyPair(privateKey, publicKey);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            throw new GenerateException(ex);
        }
    }

    public static class EncodedKeyPair {
        private final String privateKey;
        private final String publicKey;

        public EncodedKeyPair(String privateKey, String publicKey) {
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }
    }

    public static class X509RequestPair {
        private final String privKey;
        private final String request;

        public X509RequestPair(String privKey, String request) {
            this.privKey = privKey;
            this.request = request;
        }

        public String getPrivKey() {
            return this.privKey;
        }

        public String getRequest() {
            return this.request;
        }
    }
}

