/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keyclient;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.LinkedList;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import ru.softlogic.keyclient.KeyClientException;
import ru.softlogic.keyclient.PointKeyResult;

public class KeyClient {
    private String url;
    private Long configurationId;
    private String path;
    private CloseableHttpClient client;

    public KeyClient(String url, Long configurationId) throws KeyClientException {
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("Url not specified");
        }
        this.url = url;
        this.configurationId = configurationId;
        this.client = this.createClient(null);
    }

    public PointKeyResult sendPointKey(String login, String password, String request) throws KeyClientException {
        if (login == null || login.isEmpty()) {
            throw new IllegalArgumentException("Wrong login");
        }
        if (password == null || password.length() == 0) {
            throw new IllegalArgumentException("Wrong password");
        }
        LinkedList<BasicNameValuePair> nvps = new LinkedList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("type", "point"));
        nvps.add(new BasicNameValuePair("login", login));
        nvps.add(new BasicNameValuePair("password", password));
        nvps.add(new BasicNameValuePair("request", request));
        if (this.configurationId != null) {
            nvps.add(new BasicNameValuePair("hwcode", this.configurationId.toString()));
        }
        try {
            System.out.println("POst to " + this.url);
            HttpPost post = new HttpPost(this.url);
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "utf-8"));
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 200) {
                EntityUtils.consume((HttpEntity)response.getEntity());
                throw new KeyClientException(response.getStatusLine().toString());
            }
            Header header = response.getFirstHeader("Result-Code");
            if (header == null) {
                throw new KeyClientException("Not found header named Result-Code");
            }
            String value = header.getValue();
            if (value == null || !value.matches("^\\d+$")) {
                throw new KeyClientException("The format of the result value is invalid: " + value);
            }
            int result = Integer.parseInt(value);
            if (result != 0) {
                return new PointKeyResult(result);
            }
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            if (body == null || body.isEmpty()) {
                throw new IOException("No response body");
            }
            String[] fields = body.split("\n");
            if (fields.length != 4) {
                throw new IOException("Invalid response format: " + body);
            }
            if (fields[0].isEmpty()) {
                throw new IOException("Wrong format of the field 'server address'");
            }
            if (!fields[1].matches("^\\d+$")) {
                throw new IOException("Wrong format of the field 'http port'");
            }
            if (!fields[2].matches("^\\d+$")) {
                throw new IOException("Wrong format of the field 'https port'");
            }
            if (fields[3].isEmpty()) {
                throw new IOException("Wrong format of the field 'public server key'");
            }
            return new PointKeyResult(result, fields[0], Integer.parseInt(fields[2]), Integer.parseInt(fields[1]), fields[3]);
        }
        catch (IOException ex) {
            throw new KeyClientException(ex);
        }
    }

    private CloseableHttpClient createClient(CredentialsProvider cp) throws KeyClientException {
        try {
            SSLContext sslcontext = this.buildSSLContext();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            Registry registry = RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register("https", (Object)sslsf).build();
            BasicHttpClientConnectionManager cm = new BasicHttpClientConnectionManager((Lookup)registry);
            RequestConfig config = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).build();
            HttpClientBuilder hcb = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)cm).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(5, false)).setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier()).setDefaultRequestConfig(config).setUserAgent("Soft-logic key client/2.0.0");
            if (cp != null) {
                hcb.setDefaultCredentialsProvider(cp);
            }
            CloseableHttpClient httpclient = hcb.build();
            return httpclient;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            throw new KeyClientException("Erron on create HttpClient", ex);
        }
    }

    private SSLContext buildSSLContext() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        SSLContext sslcontext = SSLContexts.custom().setSecureRandom(new SecureRandom()).loadTrustMaterial(null, (chain, authType) -> true).build();
        return sslcontext;
    }
}

