/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ru.softlogic.keeper.db.model.MenuItem;

public class MenuItemsHolder {
    private final Map<Integer, MenuItem> items = new HashMap<Integer, MenuItem>();
    private final Map<Integer, List<MenuItem>> childs = new HashMap<Integer, List<MenuItem>>();

    public void update(Collection<MenuItem> ref) {
        this.items.clear();
        this.childs.clear();
        for (MenuItem mi : ref) {
            this.items.put(mi.getId(), mi);
            if (mi.getPid() == null) continue;
            List<MenuItem> list = this.childs.get(mi.getPid());
            if (list == null) {
                list = new ArrayList<MenuItem>();
                this.childs.put(mi.getPid(), list);
            }
            list.add(mi);
        }
        this.childs.values().stream().forEach(l -> l.sort((o1, o2) -> o1.getFullOrder().compareTo(o2.getFullOrder())));
    }

    public MenuItem getItem(Integer id) {
        return this.items.get(id);
    }

    public List<MenuItem> getChilds(Integer id) {
        return this.childs.get(id);
    }

    public MenuItem findByServiceId(Short sid) {
        MenuItem res = null;
        for (MenuItem it : this.items.values()) {
            if (it.getService() == null || !Objects.equals(it.getService().getId(), sid)) continue;
            res = it;
            break;
        }
        return res;
    }
}

