/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.softlogic.keeper.db.model.CashSourceMenu;

public class CashSourceMenuHolder {
    private final Map<Integer, CashSourceMenu> items = new HashMap<Integer, CashSourceMenu>();
    private final Map<Integer, List<CashSourceMenu>> childs = new HashMap<Integer, List<CashSourceMenu>>();
    private final Map<Integer, List<CashSourceMenu>> menuProfiles = new HashMap<Integer, List<CashSourceMenu>>();

    public void update(Collection<CashSourceMenu> ref) {
        this.items.clear();
        this.childs.clear();
        this.menuProfiles.clear();
        for (CashSourceMenu cashSourceMenu : ref) {
            List<CashSourceMenu> list;
            this.items.put(cashSourceMenu.getId(), cashSourceMenu);
            if (cashSourceMenu.getPid() != null) {
                list = this.childs.get(cashSourceMenu.getPid().getId());
                if (list == null) {
                    list = new ArrayList<CashSourceMenu>();
                    this.childs.put(cashSourceMenu.getPid().getId(), list);
                }
                list.add(cashSourceMenu);
            }
            if (cashSourceMenu.getPid() != null) continue;
            list = this.menuProfiles.get(cashSourceMenu.getCashSourceMenuProfile().getId());
            if (list == null) {
                list = new ArrayList<CashSourceMenu>();
                this.menuProfiles.put(cashSourceMenu.getCashSourceMenuProfile().getId(), list);
            }
            list.add(cashSourceMenu);
        }
        for (List list : this.childs.values()) {
            Collections.sort(list, (o1, o2) -> o1.getSortOrder().compareTo(o2.getSortOrder()));
        }
        for (List list : this.menuProfiles.values()) {
            Collections.sort(list, (o1, o2) -> o1.getSortOrder().compareTo(o2.getSortOrder()));
        }
    }

    public CashSourceMenu getItem(Integer id) {
        return this.items.get(id);
    }

    public List<CashSourceMenu> getChilds(Integer id) {
        return this.childs.get(id);
    }

    public List<CashSourceMenu> getChildsByMenuProfile(Integer id) {
        return this.menuProfiles.get(id);
    }
}

