/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper.setup;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import plfx.screen.input.keeper.Global;
import plfx.screen.input.keeper.module.KeeperDefaultModule;
import plfx.screen.input.keeper.module.KeeperMenuListener;
import plfx.screen.input.keeper.module.KeeperScreenListener;
import plfx.screen.input.keeper.utils.LoginTypeHolder;
import plfx.screen.input.keeper.utils.MessageTypeHolder;
import plfx.screen.input.keeper.utils.ReferencesHelper;
import ru.slkf.atm.AtmAPI;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.checkbox.CheckBoxField;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.selector.StaticStore;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.keeper.api.model.options.domain.DTOPrivate;
import ru.softlogic.keeper.api.model.options.domain.DTOSubscribeOne;
import ru.softlogic.keeper.api.model.pin.DTOPin;
import ru.softlogic.keeper.db.model.MessageType;
import ru.softlogic.smartkeeper.api.exception.KeeperApiException;

public class SetupModule
extends KeeperDefaultModule {
    private static final String ATTR_FAMILY = "person.family";
    private static final String ATTR_NAME = "person.name";
    private static final String ATTR_SNAME = "person.sname";
    private static final String ATTR_BIRTHDAY = "person.birthday";
    private static final String ATTR_SEX = "person.sex";
    private static final String ATTR_PASSPORT_NUMBER = "passport.number";
    private static final String ATTR_PASSPORT_ISSUER = "passport.issuer";
    private static final String ATTR_PASSPORT_DATE = "passport.date";
    private static final String ATTR_PASSPORT_ADDRESS = "passport.address";
    private static final String ATTR_EMAIL = "notify.email";
    private static final String ATTR_PHONE_FLAG = "notify.phone.flag";
    private static final String ATTR_EMAIL_FLAG = "notify.email.flag";
    private static final String ATTR_PHONE = "phone.number";
    private static final String ATTR_SECRET = "secret";
    private static final String ATTR_SMS_PIN1 = "sms.pin1";
    private static final String ATTR_SMS_PIN2 = "sms.pin2";
    private static final String ATTR_OLD_PASSWORD = "password.old";
    private static final String ATTR_NEW_PASSWORD = "password.new";
    private static final String ATTR_NEW_PASSWORD2 = "password.new2";
    private static final String ATTR_PASSWORD_TYPE = "password.type";
    private static final String ATTR_AUTH_TYPE = "auth.type";
    private String personLastName;
    private String personFirstName;
    private String personMiddleName;
    private String personBirth;
    private String personSex;
    private String passportNumber;
    private String passportIssuer;
    private String passportDate;
    private String passportAddress;
    private String emailAddress;
    private String phoneFlag;
    private String emailFlag;
    private String phoneNumber;
    private String secret;
    private String phoneSmsPin1;
    private String phoneSmsPin2;
    private String passwordOld;
    private String passwordNew;
    private String passwordNew2;
    private String passwordType;
    private String authType;
    private DTOPrivate privateData;
    private DTOPin pin;
    private ScreenDescription notifySD;
    private List<DTOSubscribeOne> subscribesSMS = new ArrayList<DTOSubscribeOne>();
    private List<DTOSubscribeOne> subscribesEMAIL = new ArrayList<DTOSubscribeOne>();
    private CheckBoxField fieldSmsFlag;
    private CheckBoxField fieldEmailFlag;
    private final DateFormat dfParser = new SimpleDateFormat("dd.MM.yyyy");
    private final DateFormat dfFormatter = new SimpleDateFormat("dd.MM.yyyy");
    private final LoginTypeHolder ltHolder;
    private final MessageTypeHolder msHolder;
    private final MessageType smsType;
    private final MessageType emailType;

    public SetupModule(AtmAPI modulelistener, Logger log) {
        super(modulelistener, log);
        this.dfParser.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.ltHolder = ReferencesHelper.getInstance().getLoginTypeHolder();
        this.msHolder = ReferencesHelper.getInstance().getMessageTypeHolder();
        this.smsType = this.msHolder.getLoginTypeByCode("SMS");
        this.emailType = this.msHolder.getLoginTypeByCode("EMAIL");
    }

    @Override
    public void onStart(boolean timeout) {
        this.setSection("setup");
        this.menu();
    }

    @Override
    public void onFinish() {
    }

    @Override
    public void onTimeOut() {
        this.log.debug((Object)"Home onTimeOut()");
        Global.getInstance().getKeeperModule().logout(true);
    }

    private void onException(Exception ex) {
        this.onException(ex, null);
    }

    private void onException(Exception ex, Consumer<Boolean> action) {
        String dialog;
        boolean f = false;
        if (ex instanceof KeeperApiException) {
            KeeperApiException e = (KeeperApiException)((Object)ex);
            dialog = "login/fail";
            this.modulelistener.addDataItem("fail_message", (Object)e.getMessage());
            this.log.debug((Object)("code: " + e.getMessageCode()));
            this.log.error((Object)("Update private error:" + e.getMessage()), (Throwable)ex);
        } else if (ex instanceof IOException) {
            dialog = "system/noconnect";
        } else {
            dialog = "system/error";
            f = true;
        }
        boolean fatal = f;
        this.modulelistener.showDialog(dialog, i -> {
            if (action != null) {
                action.accept(fatal);
            } else {
                this.menu();
            }
        });
    }

    private void menu() {
        this.showOrCreate("menu", () -> this.modulelistener.getScreen("keeper/selector/setupmenu"), () -> this.modulelistener.getScreenDescription("forms/setup/menu"), () -> new KeeperMenuListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                block3 : switch (action) {
                    case "next": {
                        InputElement item = (InputElement)data.get("menu.action");
                        SetupModule.this.log.debug((Object)("Menu item action:" + item.getValue()));
                        switch (item.getValue()) {
                            case "personalInfo": {
                                SetupModule.this.personalInfo();
                                break block3;
                            }
                            case "password": {
                                SetupModule.this.selectPasswordType();
                                break block3;
                            }
                            case "phone": {
                                SetupModule.this.phoneChange();
                                break block3;
                            }
                            case "notification": {
                                SetupModule.this.notification();
                                break block3;
                            }
                            case "authtype": {
                                SetupModule.this.authtype();
                            }
                        }
                    }
                }
            }
        });
    }

    private void selectPasswordType() {
        this.showOrCreate("type", () -> this.modulelistener.getScreen("selector"), () -> this.modulelistener.getScreenDescription("forms/setup/pwdmenu"), () -> new KeeperMenuListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                block4 : switch (action) {
                    case "prev": {
                        SetupModule.this.menu();
                        break;
                    }
                    case "next": {
                        InputElement item = (InputElement)data.get("menu.action");
                        SetupModule.this.log.debug((Object)("Menu item action:" + item.getValue()));
                        switch (item.getValue()) {
                            case "keeperPassword": {
                                SetupModule.this.passwordChange();
                                break block4;
                            }
                            case "payPassword": {
                                SetupModule.this.payPasswordChange();
                            }
                        }
                    }
                }
            }
        });
    }

    public void personalInfo() {
        this.modulelistener.execute(() -> Global.getInstance().doGetPrivate(), client -> {
            this.privateData = client;
            this.personLastName = this.privateData.getLastName();
            this.personFirstName = this.privateData.getFirstName();
            this.personMiddleName = this.privateData.getMiddleName();
            String string = this.personBirth = this.privateData.getBirthDate() != null ? this.dfFormatter.format(this.privateData.getBirthDate()) : null;
            this.personSex = this.privateData.getSex() == 1 ? "FEMALE" : (this.privateData.getSex() == 2 ? "MALE" : "NOT_DEFINED");
            this.passportNumber = this.privateData.getPassportNumber() != null && this.privateData.getPassportSerie() != null ? this.privateData.getPassportSerie() + this.privateData.getPassportNumber() : "";
            this.passportDate = this.privateData.getPassportIssueDate() != null ? this.dfFormatter.format(this.privateData.getPassportIssueDate()) : null;
            this.passportIssuer = this.privateData.getPassportIssuedBy() != null ? this.privateData.getPassportIssuedBy() : "";
            this.passportAddress = this.privateData.getRegistrationAddress() != null ? this.privateData.getRegistrationAddress() : "";
            this.inputPersonInfo();
        }, e -> this.modulelistener.showDialog("system/error", i -> Global.getInstance().getKeeperModule().getTemplateModule().templates()));
    }

    private void inputPersonInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ATTR_FAMILY, new InputElement(ATTR_FAMILY, null, this.personLastName));
        map.put(ATTR_NAME, new InputElement(ATTR_NAME, null, this.personFirstName));
        map.put(ATTR_SNAME, new InputElement(ATTR_SNAME, null, this.personMiddleName));
        if (this.personBirth != null) {
            map.put(ATTR_BIRTHDAY, new InputElement(ATTR_BIRTHDAY, null, this.personBirth));
        }
        map.put(ATTR_PASSPORT_NUMBER, new InputElement(ATTR_PASSPORT_NUMBER, null, this.passportNumber));
        if (this.passportDate != null) {
            map.put(ATTR_PASSPORT_DATE, new InputElement(ATTR_PASSPORT_DATE, null, this.passportDate));
        }
        map.put(ATTR_PASSPORT_ISSUER, new InputElement(ATTR_PASSPORT_ISSUER, null, this.passportIssuer));
        map.put(ATTR_SEX, new InputElement(ATTR_SEX, null, this.personSex));
        map.put(ATTR_PASSPORT_ADDRESS, new InputElement(ATTR_PASSPORT_ADDRESS, null, this.passportAddress));
        this.modulelistener.addDataItem("group_mode", (Object)"setupPerson");
        this.modulelistener.addDataItem("group_button_next", (Object)"save");
        this.showOrCreate("person", () -> this.modulelistener.getScreen("keeper/group4"), () -> this.modulelistener.getScreenDescription("forms/setup/person"), () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                SetupModule.this.modulelistener.removeDataItem("group_button_next");
                switch (action) {
                    case "next": {
                        SetupModule.this.personLastName = ((InputElement)data.get(SetupModule.ATTR_FAMILY)).getValue();
                        SetupModule.this.personFirstName = ((InputElement)data.get(SetupModule.ATTR_NAME)).getValue();
                        SetupModule.this.personMiddleName = ((InputElement)data.get(SetupModule.ATTR_SNAME)).getValue();
                        if (data.get(SetupModule.ATTR_BIRTHDAY) != null) {
                            SetupModule.this.personBirth = ((InputElement)data.get(SetupModule.ATTR_BIRTHDAY)).getValue();
                        }
                        SetupModule.this.passportNumber = ((InputElement)data.get(SetupModule.ATTR_PASSPORT_NUMBER)).getValue();
                        SetupModule.this.passportIssuer = ((InputElement)data.get(SetupModule.ATTR_PASSPORT_ISSUER)).getValue();
                        SetupModule.this.personSex = ((InputElement)data.get(SetupModule.ATTR_SEX)).getValue();
                        if (data.get(SetupModule.ATTR_PASSPORT_DATE) != null) {
                            SetupModule.this.passportDate = ((InputElement)data.get(SetupModule.ATTR_PASSPORT_DATE)).getValue();
                        }
                        SetupModule.this.passportAddress = ((InputElement)data.get(SetupModule.ATTR_PASSPORT_ADDRESS)).getValue();
                        SetupModule.this.updatePersonInfo();
                        break;
                    }
                    case "prev": {
                        SetupModule.this.menu();
                    }
                }
            }
        }, map);
    }

    private void updatePersonInfo() {
        this.privateData.setLastName(this.personLastName.isEmpty() ? null : this.personLastName);
        this.privateData.setFirstName(this.personFirstName.isEmpty() ? null : this.personFirstName);
        this.privateData.setMiddleName(this.personMiddleName.isEmpty() ? null : this.personMiddleName);
        Date bd = null;
        try {
            bd = this.personBirth.isEmpty() ? null : this.dfParser.parse(this.personBirth);
        }
        catch (Exception e2) {
            // empty catch block
        }
        this.log.debug((Object)("birthday:" + bd));
        this.privateData.setBirthDate(bd);
        this.privateData.setRegistrationAddress(this.passportAddress.isEmpty() ? null : this.passportAddress);
        if (this.passportNumber.isEmpty()) {
            this.privateData.setPassportSerie(null);
            this.privateData.setPassportNumber(null);
        } else {
            this.privateData.setPassportSerie(this.passportNumber.substring(0, 4));
            this.privateData.setPassportNumber(this.passportNumber.substring(4));
        }
        Date pd = null;
        try {
            pd = this.passportDate.isEmpty() ? null : this.dfParser.parse(this.passportDate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.privateData.setPassportIssueDate(pd);
        this.privateData.setPassportIssuedBy(this.passportIssuer.isEmpty() ? null : this.passportIssuer);
        switch (this.personSex) {
            case "MALE": {
                this.privateData.setSex(Short.valueOf((short)2));
                break;
            }
            case "FEMALE": {
                this.privateData.setSex(Short.valueOf((short)1));
                break;
            }
            default: {
                this.privateData.setSex(Short.valueOf((short)0));
            }
        }
        this.modulelistener.execute(() -> Global.getInstance().doUpdatePrivate(this.privateData), client -> this.modulelistener.showDialog("setup/personupdate", i -> this.menu()), e -> this.onException((Exception)e));
    }

    public void phoneChange() {
        this.inputPhone();
    }

    private void inputPhone() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.phoneNumber = "";
        this.secret = "";
        map.put(ATTR_PHONE, new InputElement(ATTR_PHONE, null, this.phoneNumber));
        map.put(ATTR_SECRET, new InputElement(ATTR_SECRET, null, this.secret));
        this.showOrCreate("phone", () -> this.modulelistener.getScreen("keeper/setup/phone"), () -> this.modulelistener.getScreenDescription("forms/setup/phone"), () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "next": {
                        SetupModule.this.phoneNumber = ((InputElement)data.get(SetupModule.ATTR_PHONE)).getValue();
                        SetupModule.this.secret = ((InputElement)data.get(SetupModule.ATTR_SECRET)).getValue();
                        SetupModule.this.sendPhoneChangeRequest();
                        break;
                    }
                    case "prev": {
                        SetupModule.this.menu();
                    }
                }
            }
        }, map);
    }

    private void sendPhoneChangeRequest() {
        this.modulelistener.execute(() -> Global.getInstance().doUpdatePhone(this.phoneNumber, this.secret), res -> this.inputPhonePin((DTOPin)res), e -> this.onException((Exception)e));
    }

    private void inputPhonePin(DTOPin res) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.pin = res;
        this.modulelistener.addDataItem("pin1_smsid", (Object)res.getMsgCode1());
        this.modulelistener.addDataItem("pin2_smsid", (Object)res.getMsgCode2());
        this.phoneSmsPin1 = "";
        this.phoneSmsPin2 = "";
        map.put(ATTR_SMS_PIN1, new InputElement(ATTR_SMS_PIN1, null, this.phoneSmsPin1));
        map.put(ATTR_SMS_PIN2, new InputElement(ATTR_SMS_PIN2, null, this.phoneSmsPin2));
        this.showOrCreate("pin", () -> this.modulelistener.getScreen("keeper/setup/phone/pin"), () -> this.modulelistener.getScreenDescription("forms/setup/phonepin"), () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "next": {
                        SetupModule.this.phoneSmsPin1 = ((InputElement)data.get(SetupModule.ATTR_SMS_PIN1)).getValue();
                        SetupModule.this.phoneSmsPin2 = ((InputElement)data.get(SetupModule.ATTR_SMS_PIN2)).getValue();
                        SetupModule.this.updatePhone();
                        break;
                    }
                    case "prev": {
                        SetupModule.this.menu();
                        break;
                    }
                    case "resendSms": {
                        SetupModule.this.sendPhoneChangeRequest();
                    }
                }
            }
        }, map);
    }

    private void updatePhone() {
        this.modulelistener.execute(() -> Global.getInstance().doConfirmPin(this.pin.getId(), this.phoneSmsPin1, this.phoneSmsPin2), res -> this.modulelistener.showDialog("setup/phonechange", i -> Global.getInstance().getKeeperModule().logout(false)), e -> this.onException((Exception)e, t -> {
            if (t.booleanValue()) {
                this.menu();
            } else {
                this.inputPhonePin(this.pin);
            }
        }));
    }

    public void notification() {
        this.phoneNumber = Global.getInstance().getClientDescription().getClient().getLogin();
        this.emailAddress = Global.getInstance().getClientDescription().getClient().getEmail();
        this.subscribesSMS.clear();
        this.subscribesEMAIL.clear();
        this.modulelistener.execute(() -> Global.getInstance().doGetSubscribes(), res -> {
            int cntSms = 0;
            int cntEmail = 0;
            if (res != null) {
                for (DTOSubscribeOne i : res.getSubscribes()) {
                    if (this.smsType != null && this.smsType.getId().shortValue() == i.getMessageType()) {
                        if (!i.isEditable()) continue;
                        this.subscribesSMS.add(i);
                        if (!i.isSelected()) continue;
                        ++cntSms;
                        continue;
                    }
                    if (this.emailType == null || this.emailType.getId().shortValue() != i.getMessageType() || !i.isEditable()) continue;
                    this.subscribesEMAIL.add(i);
                    if (!i.isSelected()) continue;
                    ++cntEmail;
                }
            }
            this.phoneFlag = cntSms > 0 ? "true" : "false";
            this.emailFlag = cntEmail > 0 ? "true" : "false";
            this.inputNotify();
        }, e -> this.onException((Exception)e, t -> this.menu()));
    }

    private void inputNotify() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ATTR_PHONE, new InputElement(ATTR_PHONE, null, this.phoneNumber));
        map.put(ATTR_EMAIL, new InputElement(ATTR_EMAIL, null, this.emailAddress));
        map.put(ATTR_PHONE_FLAG, new InputElement(ATTR_PHONE_FLAG, null, this.phoneFlag));
        map.put(ATTR_EMAIL_FLAG, new InputElement(ATTR_EMAIL_FLAG, null, this.emailFlag));
        if (this.fieldSmsFlag != null && this.smsType != null) {
            this.fieldSmsFlag.setReadOnly(this.smsType.getClientChange() == false);
        }
        if (this.fieldEmailFlag != null && this.emailType != null) {
            this.fieldEmailFlag.setReadOnly(this.emailType.getClientChange() == false);
        }
        this.showOrCreate("notify", () -> this.modulelistener.getScreen("keeper/setup/notify"), () -> {
            this.notifySD = this.modulelistener.getScreenDescription("forms/setup/notify");
            for (IdentityField f : this.notifySD.getSequence().getFields()) {
                if (f.getId().equals(ATTR_PHONE_FLAG)) {
                    this.fieldSmsFlag = (CheckBoxField)f;
                    continue;
                }
                if (!f.getId().equals(ATTR_EMAIL_FLAG)) continue;
                this.fieldEmailFlag = (CheckBoxField)f;
            }
            if (this.fieldSmsFlag != null && this.smsType != null) {
                this.fieldSmsFlag.setReadOnly(this.smsType.getClientChange() == false);
            }
            if (this.fieldEmailFlag != null && this.emailType != null) {
                this.fieldEmailFlag.setReadOnly(this.emailType.getClientChange() == false);
            }
            return this.notifySD;
        }, () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "changeNumber": {
                        SetupModule.this.phoneChange();
                        break;
                    }
                    case "next": {
                        SetupModule.this.emailAddress = ((InputElement)data.get(SetupModule.ATTR_EMAIL)).getValue();
                        SetupModule.this.phoneFlag = ((InputElement)data.get(SetupModule.ATTR_PHONE_FLAG)).getValue();
                        SetupModule.this.emailFlag = ((InputElement)data.get(SetupModule.ATTR_EMAIL_FLAG)).getValue();
                        SetupModule.this.updateNotify();
                        break;
                    }
                    case "prev": {
                        SetupModule.this.menu();
                    }
                }
            }
        }, map);
    }

    private void updateNotify() {
        if (!this.emailAddress.isEmpty() && !this.emailAddress.equals(Global.getInstance().getClientDescription().getClient().getEmail())) {
            this.modulelistener.execute(() -> Global.getInstance().doUpdateEmail(this.emailAddress), res -> this.modulelistener.showDialog("setup/emailupdate", i -> this.updateSubscribe()), e -> this.onException((Exception)e));
        } else if (this.emailAddress.isEmpty()) {
            this.updateSubscribe();
        } else {
            this.updateSubscribe();
        }
    }

    private void updateSubscribe() {
        ArrayList<DTOSubscribeOne> ss = new ArrayList<DTOSubscribeOne>(this.subscribesEMAIL.size() + this.subscribesSMS.size());
        boolean smsSel = this.phoneFlag.equals("true");
        boolean emailSel = this.emailFlag.equals("true");
        if (this.smsType != null && this.smsType.getClientChange().booleanValue()) {
            this.subscribesSMS.stream().forEach(i -> i.setSelected(smsSel));
            ss.addAll(this.subscribesSMS);
        }
        if (this.emailType != null && this.emailType.getClientChange().booleanValue()) {
            this.subscribesEMAIL.stream().forEach(i -> i.setSelected(emailSel));
            ss.addAll(this.subscribesEMAIL);
        }
        this.modulelistener.execute(() -> Global.getInstance().doUpdateSubscribe(ss), res -> this.modulelistener.showDialog("setup/notifyupdate", i -> this.menu()), e -> this.onException((Exception)e));
        this.menu();
    }

    public void passwordChange() {
        this.passwordOld = "";
        this.passwordNew = "";
        this.passwordNew2 = "";
        this.inputPassword();
    }

    private void inputPassword() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ATTR_OLD_PASSWORD, new InputElement(ATTR_OLD_PASSWORD, null, this.passwordOld));
        map.put(ATTR_NEW_PASSWORD, new InputElement(ATTR_NEW_PASSWORD, null, this.passwordNew));
        map.put(ATTR_NEW_PASSWORD2, new InputElement(ATTR_NEW_PASSWORD2, null, this.passwordNew2));
        this.showOrCreate("keeperPassword", () -> this.modulelistener.getScreen("keeper/group3"), () -> this.modulelistener.getScreenDescription("forms/setup/pwdchange"), () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "next": {
                        SetupModule.this.passwordOld = ((InputElement)data.get(SetupModule.ATTR_OLD_PASSWORD)).getValue();
                        SetupModule.this.passwordNew = ((InputElement)data.get(SetupModule.ATTR_NEW_PASSWORD)).getValue();
                        SetupModule.this.passwordNew2 = ((InputElement)data.get(SetupModule.ATTR_NEW_PASSWORD2)).getValue();
                        if (SetupModule.this.passwordNew.equals(SetupModule.this.passwordNew2)) {
                            SetupModule.this.sendPasswordChangeRequest();
                            break;
                        }
                        SetupModule.this.passwordNew = "";
                        SetupModule.this.passwordNew2 = "";
                        SetupModule.this.modulelistener.showDialog("setup/pwddiff", i -> SetupModule.this.inputPassword());
                        break;
                    }
                    case "prev": {
                        SetupModule.this.selectPasswordType();
                    }
                }
            }
        }, map);
    }

    private void sendPasswordChangeRequest() {
        this.modulelistener.execute(() -> Global.getInstance().doUpdatePassword(this.passwordOld, this.passwordNew), res -> this.inputPasswordPin((DTOPin)res), e -> this.onException((Exception)e));
    }

    private void inputPasswordPin(DTOPin res) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.pin = res;
        this.modulelistener.addDataItem("pin1_smsid", (Object)res.getMsgCode1());
        this.phoneSmsPin1 = "";
        map.put(ATTR_SMS_PIN1, new InputElement(ATTR_SMS_PIN1, null, this.phoneSmsPin1));
        this.showOrCreate("pinPassword", () -> this.modulelistener.getScreen("keeper/setup/password/pin"), () -> this.modulelistener.getScreenDescription("forms/setup/pwdpin"), () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "next": {
                        SetupModule.this.phoneSmsPin1 = ((InputElement)data.get(SetupModule.ATTR_SMS_PIN1)).getValue();
                        SetupModule.this.updatePassword();
                        break;
                    }
                    case "prev": {
                        SetupModule.this.menu();
                        break;
                    }
                    case "resendSms": {
                        SetupModule.this.sendPasswordChangeRequest();
                    }
                }
            }
        }, map);
    }

    private void updatePassword() {
        this.modulelistener.execute(() -> Global.getInstance().doConfirmPin(this.pin.getId(), this.phoneSmsPin1, null), res -> this.modulelistener.showDialog("setup/pwdchange", i -> Global.getInstance().getKeeperModule().logout(false)), e -> this.onException((Exception)e, t -> {
            if (t.booleanValue()) {
                this.menu();
            } else {
                this.inputPasswordPin(this.pin);
            }
        }));
    }

    private void payPasswordChange() {
        short type = Global.getInstance().getClientDescription().getClient().getPayPasswordType();
        this.passwordType = type == 1 ? "STATIC" : (type == 2 ? "DYNAMIC" : "NONE");
        this.passwordNew = "";
        this.passwordNew2 = "";
        this.secret = "";
        this.inputPayType();
    }

    private void inputPayType() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ATTR_PASSWORD_TYPE, new InputElement(ATTR_PASSWORD_TYPE, null, this.passwordType));
        map.put(ATTR_SECRET, new InputElement(ATTR_SECRET, null, this.secret));
        this.showOrCreate("payPasswordType", () -> this.modulelistener.getScreen("keeper/group3"), () -> this.modulelistener.getScreenDescription("forms/setup/pwdtype"), () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "next": {
                        SetupModule.this.passwordType = ((InputElement)data.get(SetupModule.ATTR_PASSWORD_TYPE)).getValue();
                        SetupModule.this.secret = ((InputElement)data.get(SetupModule.ATTR_SECRET)).getValue();
                        if (SetupModule.this.passwordType.equals("STATIC")) {
                            SetupModule.this.inputPayPassword();
                            break;
                        }
                        SetupModule.this.updatePayPassword();
                        break;
                    }
                    case "prev": {
                        SetupModule.this.selectPasswordType();
                    }
                }
            }
        }, map);
    }

    private void inputPayPassword() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ATTR_NEW_PASSWORD, new InputElement(ATTR_NEW_PASSWORD, null, this.passwordNew));
        map.put(ATTR_NEW_PASSWORD2, new InputElement(ATTR_NEW_PASSWORD2, null, this.passwordNew2));
        this.showOrCreate("payPassword", () -> this.modulelistener.getScreen("keeper/group3"), () -> this.modulelistener.getScreenDescription("forms/setup/pwdpaychange"), () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "next": {
                        SetupModule.this.passwordNew = ((InputElement)data.get(SetupModule.ATTR_NEW_PASSWORD)).getValue();
                        SetupModule.this.passwordNew2 = ((InputElement)data.get(SetupModule.ATTR_NEW_PASSWORD2)).getValue();
                        if (SetupModule.this.passwordNew.equals(SetupModule.this.passwordNew2)) {
                            SetupModule.this.updatePayPassword();
                            break;
                        }
                        SetupModule.this.passwordNew = "";
                        SetupModule.this.passwordNew2 = "";
                        SetupModule.this.modulelistener.showDialog("setup/pwddiff", i -> SetupModule.this.inputPayPassword());
                        break;
                    }
                    case "prev": {
                        SetupModule.this.inputPayType();
                    }
                }
            }
        }, map);
    }

    private void updatePayPassword() {
        short type;
        switch (this.passwordType) {
            case "STATIC": {
                type = 1;
                break;
            }
            case "DYNAMIC": {
                type = 2;
                break;
            }
            default: {
                type = 0;
            }
        }
        short typeFinal = type;
        this.modulelistener.execute(() -> Global.getInstance().doUpdatePayPassword(typeFinal, typeFinal == 1 ? this.passwordNew : null, this.secret), res -> {
            if (res.booleanValue()) {
                Global.getInstance().getClientDescription().getClient().setPayPasswordType(typeFinal);
            }
            this.modulelistener.showDialog("setup/paypwdchange", i -> this.menu());
        }, e -> this.onException((Exception)e));
    }

    private void authtype() {
        this.authType = Short.toString(Global.getInstance().getClientDescription().getClient().getLoginType().getId());
        this.inputAuthType();
    }

    private void inputAuthType() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ATTR_AUTH_TYPE, new InputElement(ATTR_AUTH_TYPE, null, this.authType));
        this.showOrCreate("aythType", () -> this.modulelistener.getScreen("keeper/group3"), () -> {
            ScreenDescription typeSD = this.modulelistener.getScreenDescription("forms/setup/authtype");
            if (!this.ltHolder.getAll().isEmpty()) {
                SelectorField sf = (SelectorField)typeSD.getSequence().getFields().get(0);
                ArrayList apiList = new ArrayList();
                this.ltHolder.getAll().stream().forEach(i -> apiList.add(new SelectorItem(i.getName(), "keeper_setup_authtype_" + i.getCode().toLowerCase().replaceAll("\\.", "_"), Short.toString(i.getId()), null, true)));
                sf.setStore((ItemsStore)new StaticStore(apiList));
            }
            return typeSD;
        }, () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "next": {
                        SetupModule.this.authType = ((InputElement)data.get(SetupModule.ATTR_AUTH_TYPE)).getValue();
                        SetupModule.this.updateAuthType();
                        break;
                    }
                    case "prev": {
                        SetupModule.this.menu();
                    }
                }
            }
        }, map);
    }

    private void updateAuthType() {
        short type = Short.parseShort(this.authType);
        this.modulelistener.execute(() -> Global.getInstance().doUpdateAuthType(type), res -> {
            if (res.booleanValue()) {
                Global.getInstance().getClientDescription().getClient().getLoginType().setId(Short.valueOf(type));
            }
            this.modulelistener.showDialog("setup/authchange", i -> this.menu());
        }, e -> this.onException((Exception)e));
    }
}

