/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper.receipt;

import java.util.Map;
import org.apache.log4j.Logger;
import plfx.screen.input.keeper.Global;
import plfx.screen.input.keeper.module.KeeperDefaultModule;
import plfx.screen.input.keeper.module.KeeperScreenListener;
import plfx.screen.input.keeper.utils.CashSourceHolder;
import plfx.screen.input.keeper.utils.ReferencesHelper;
import ru.slkf.atm.AtmAPI;
import ru.slkf.atm.AtmPaymentListener;
import ru.softlogic.keeper.db.model.CashSource;
import ru.softlogic.keeper.db.model.CashSourceMenu;

public class ReceiptModule
extends KeeperDefaultModule {
    private final CashSourceHolder csHolder = ReferencesHelper.getInstance().getCashSourceHolder();

    public ReceiptModule(AtmAPI modulelistener, Logger log) {
        super(modulelistener, log);
    }

    @Override
    public void onStart(boolean timeout) {
        this.resetData();
    }

    private void resetData() {
    }

    @Override
    public void onFinish() {
        this.resetData();
    }

    private void exit() {
        Global.getInstance().getKeeperModule().exit();
    }

    @Override
    public void onTimeOut() {
        this.exit();
    }

    private void back() {
        this.resetData();
        Global.getInstance().getKeeperModule().getMenuReceiptModule().menu();
    }

    public void receipt(Short serviceId, CashSourceMenu csm) {
        CashSource selectedCashSource = this.csHolder.getItem(csm.getCashSource().getId());
        this.log.debug((Object)("Selected:" + selectedCashSource));
        if (selectedCashSource.getCode().equals("TERMINAL")) {
            String d = Global.getInstance().getClientDescription().getClient().getLogin();
            this.modulelistener.receiptKeeper(serviceId, d, null, (AtmPaymentListener)new LocalAtmPaymentListener(this.modulelistener, this.log));
        } else {
            this.modulelistener.showDialog("system/notimplemented", i -> this.back());
        }
    }

    private void successPayment() {
        this.showOrCreate("successPayment", () -> this.modulelistener.getScreen("keeper/success/receipt"), null, () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "back": {
                        Global.getInstance().getKeeperModule().getHomeModule().onLogin(null);
                        Global.getInstance().getKeeperModule().getMenuReceiptModule().menu();
                    }
                }
            }
        });
    }

    class LocalAtmPaymentListener
    extends KeeperScreenListener
    implements AtmPaymentListener {
        public LocalAtmPaymentListener(AtmAPI modulelistener, Logger log) {
            super(modulelistener, log);
        }

        public void onBack() {
            ReceiptModule.this.log.debug((Object)"onBack()");
            ReceiptModule.this.back();
        }

        public void onExit() {
            ReceiptModule.this.log.debug((Object)"onExit()");
            this.onDefaultExit(null);
        }

        public void onPay(int sumIncome) {
            ReceiptModule.this.log.debug((Object)("onPay():" + sumIncome));
            ReceiptModule.this.successPayment();
        }

        public void onAction(String action) {
            this.onAction(action, null, () -> {});
        }

        @Override
        protected void onAction(String action, Map<String, Object> data) {
            ReceiptModule.this.log.debug((Object)("onAction():" + action));
        }
    }
}

