/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper.module;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import plfx.screen.CommonScreen;
import plfx.screen.Screen;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.input.keeper.Global;
import plfx.screen.input.keeper.module.KeeperLogicModule;
import ru.slkf.atm.AtmAPI;
import ru.softlogic.input.model.screen.description.ScreenDescription;

public abstract class KeeperDefaultModule
implements KeeperLogicModule {
    protected final AtmAPI modulelistener;
    protected final Logger log;
    private CommonScreen currentScreen;
    private final Map<String, CommonScreen> mapScreen = new HashMap<String, CommonScreen>();
    private final Map<String, ScreenDescription> mapScreenDescription = new HashMap<String, ScreenDescription>();
    private final Map<String, ScreenListener> mapScreenListener = new HashMap<String, ScreenListener>();

    public KeeperDefaultModule(AtmAPI modulelistener, Logger log) {
        this.modulelistener = modulelistener;
        this.log = log;
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean timeout) {
        this.log.debug((Object)"------------------------------------------------------------");
        this.log.debug((Object)(this.getClass().getName() + ".start()"));
        Global.getInstance().getKeeperModule().setCurrentModule(this);
        this.onStart(timeout);
    }

    public abstract void onStart(boolean var1);

    public abstract void onFinish();

    public void finish() {
        this.onFinish();
    }

    protected boolean isCurrent(String name) {
        CommonScreen scr = this.mapScreen.get(name);
        return scr != null && scr == this.currentScreen;
    }

    protected void showOrCreate(String name, Callable<CommonScreen> screen, Callable<ScreenDescription> descr, Callable<ScreenListener> listener) {
        this.showOrCreate(name, screen, descr, listener, null);
    }

    protected void showOrCreate(String name, Callable<CommonScreen> screen, Callable<ScreenDescription> descr, Callable<ScreenListener> listener, Map<String, Object> sid) {
        this.log.debug((Object)("SHOW SCREEN: " + name + ", " + this.getClass().getName()));
        this.log.debug((Object)("DATA: " + sid));
        try {
            ScreenDescription sd;
            CommonScreen scr = this.mapScreen.get(name);
            if (scr == null) {
                scr = screen.call();
                this.mapScreen.put(name, scr);
            }
            if ((sd = this.mapScreenDescription.get(name)) == null) {
                sd = descr != null ? descr.call() : new ScreenDescription();
                this.mapScreenDescription.put(name, sd);
            }
            this.modulelistener.preFillScreenDescription(sd);
            ScreenListener lis = this.mapScreenListener.get(name);
            if (lis == null) {
                lis = listener.call();
                this.mapScreenListener.put(name, lis);
            }
            ScreenInit si = this.modulelistener.getScreenInit();
            if (sid != null && !sid.isEmpty()) {
                Map d = si.getModelEnvironment().getData();
                d.putAll(sid);
            }
            this.modulelistener.setSessionScreenDescription(sd);
            scr.setListener(lis);
            scr.init(sd, si);
            this.currentScreen = scr;
            this.modulelistener.showScreen((Screen)scr);
            Global.getInstance().getKeeperModule().setCurrentModule(this);
        }
        catch (Exception e) {
            this.log.error((Object)("ERROR: " + e.getMessage()), (Throwable)e);
            if (e.getMessage() != null) {
                this.modulelistener.addDataItem("fail_message", (Object)e.getMessage());
            } else {
                this.modulelistener.addDataItem("fail_message", (Object)e.getClass().getName());
            }
            this.modulelistener.showDialog("login/fail", i -> {
                this.log.debug((Object)("dialog result: " + i));
                this.finish();
            });
        }
    }

    @Override
    public int getInactivityTimeout() {
        int r = -1;
        if (this.currentScreen != null) {
            r = 60;
        }
        this.log.trace((Object)(this.getClass().getName() + ".getInactivityTimeout():" + r));
        return r;
    }

    public void setSection(String s) {
        this.log.debug((Object)("set section:" + s));
        this.modulelistener.addDataItem("left_section", (Object)s);
    }
}

