/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper.menu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import plfx.screen.CommonScreen;
import plfx.screen.input.keeper.Global;
import plfx.screen.input.keeper.menu.SearchDataProvider;
import plfx.screen.input.keeper.module.KeeperDefaultModule;
import plfx.screen.input.keeper.module.KeeperScreenListener;
import plfx.screen.input.keeper.utils.MenuItemsHolder;
import plfx.screen.input.keeper.utils.ReferencesHelper;
import plfx.screen.input.keeper.utils.ServicesHolder;
import plfx.screen.menu.button.ActionListener;
import plfx.screen.menu.button.MenuButtonInit;
import plfx.screen.utility.search.SearchListener;
import plfx.screen.utility.search.SearchScreen;
import ru.slkf.atm.AtmAPI;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.keeper.db.model.MenuItem;
import ru.softlogic.keeper.db.model.Service;

public class MenuSearchModule
extends KeeperDefaultModule {
    private SearchScreen searchScreen;
    private final Set<MenuItem> operationsStorage;
    private List<MenuItem> operations;
    private final SearchDataProvider dataProvider;
    private short pageSize;
    private int page;
    private int maxPage;
    private final MenuItemsHolder miHolder = ReferencesHelper.getInstance().getMenuItemsHolder();
    private final ServicesHolder sHolder = ReferencesHelper.getInstance().getServicesHolder();
    private MenuItem findMenuRoot;
    private final List<MenuItem> allItems;

    public MenuSearchModule(AtmAPI modulelistener, Logger log) {
        super(modulelistener, log);
        this.operationsStorage = new TreeSet<MenuItem>((o1, o2) -> o1.getName().compareTo(o2.getName()));
        this.dataProvider = new SearchDataProvider(this.operationsStorage);
        this.allItems = new ArrayList<MenuItem>();
    }

    private void loadChilds(List<MenuItem> childs, List<MenuItem> all) {
        for (int i = 0; i < childs.size(); ++i) {
            MenuItem it = childs.get(i);
            if (it.getService() != null) {
                all.add(it);
                continue;
            }
            List<MenuItem> ch = this.miHolder.getChilds(it.getId());
            if (ch == null) continue;
            this.loadChilds(ch, all);
        }
    }

    @Override
    public void onStart(boolean timeout) {
        this.resetData();
        this.findMenuRoot = Global.getInstance().findMenuRoot("PAYMENT");
        List<MenuItem> childs = this.miHolder.getChilds(this.findMenuRoot.getId());
        this.loadChilds(childs, this.allItems);
        this.showOrCreate("search", () -> {
            CommonScreen s = this.modulelistener.getScreen("keeper/search");
            this.searchScreen = (SearchScreen)s;
            this.pageSize = (short)this.searchScreen.getButtonCount();
            this.searchScreen.setListener(new SearchListener(){

                public void onRequest(String string) {
                    MenuSearchModule.this.log.debug((Object)("onRequest:'" + string + "'"));
                    MenuSearchModule.this.search(string);
                }

                public void onExit() {
                }

                public void onBrowseNext() {
                }

                public void onBrowsePrev() {
                }
            });
            return s;
        }, () -> this.modulelistener.getScreenDescription("forms/search"), () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "searchInput": {
                        InputElement ie = (InputElement)data.get("searchString");
                        if (ie == null) break;
                        String str = ie.getValue();
                        MenuSearchModule.this.search(str);
                        break;
                    }
                    case "prevPage": {
                        Short ps;
                        if (MenuSearchModule.this.pageSize == -1 && (ps = (Short)data.get("pageSize")) != null) {
                            MenuSearchModule.this.pageSize = ps;
                        }
                        if (MenuSearchModule.this.page <= 0) break;
                        MenuSearchModule.this.list(MenuSearchModule.this.page, -1);
                        break;
                    }
                    case "nextPage": {
                        Short ps;
                        if (MenuSearchModule.this.pageSize == -1 && (ps = (Short)data.get("pageSize")) != null) {
                            MenuSearchModule.this.pageSize = ps;
                        }
                        MenuSearchModule.this.list(MenuSearchModule.this.page, 1);
                        break;
                    }
                    case "back": {
                        MenuSearchModule.this.exit();
                    }
                }
            }
        });
    }

    private void resetData() {
        this.page = 0;
        this.maxPage = 0;
        this.operationsStorage.clear();
        this.operations = null;
        this.allItems.clear();
    }

    private void exit() {
        this.resetData();
        Global.getInstance().getKeeperModule().getHomeModule().payment();
    }

    @Override
    public void onFinish() {
        this.resetData();
    }

    @Override
    public void onTimeOut() {
        this.exit();
    }

    private void search(String str) {
        int l = this.allItems.size();
        this.operationsStorage.clear();
        this.operations = null;
        this.log.debug((Object)("search:" + str));
        for (int i = 0; i < l; ++i) {
            MenuItem it = this.allItems.get(i);
            Service service = this.sHolder.getService(it.getService().getId());
            String s1 = it.getName().toUpperCase().trim().replace(" ", "");
            String s2 = str.replace(" ", "");
            int min = Math.min(s1.length(), s2.length());
            if (StringUtils.getLevenshteinDistance((CharSequence)s1.substring(0, min), (CharSequence)s2.substring(0, min)) >= 2 && !String.valueOf(service.getId()).equals(s2) && !String.valueOf(service.getCode()).equals(s2)) continue;
            this.operationsStorage.add(it);
        }
        int t = this.operationsStorage.size();
        this.page = 0;
        this.maxPage = t > 0 ? t / this.pageSize + (t % this.pageSize > 0 ? 1 : 0) - 1 : 0;
        this.list(-1, 0);
    }

    private void list(int p, int shift) {
        List ops = this.dataProvider.getData(p + shift, this.pageSize > 0 ? (short)this.pageSize : (short)15);
        if (ops != null) {
            this.page = p >= 0 ? p + shift : 0;
        } else {
            this.page = 0;
            this.maxPage = 0;
        }
        this.operations = ops;
        ArrayList<MenuButtonInit> pays = new ArrayList<MenuButtonInit>();
        if (this.operations != null) {
            HashMap titles = new HashMap();
            int i = 0;
            for (MenuItem op : this.operations) {
                Service s = ReferencesHelper.getInstance().getServicesHolder().getService(op.getService().getId());
                MenuButtonInit mbi = new MenuButtonInit(null, s.getName(), s.getImage2(), "", null, false, (ActionListener)new LocalMenuButtonActionListener(op));
                pays.add(mbi);
                HashMap<String, String> lang = new HashMap<String, String>();
                lang.put(this.modulelistener.getLocale().getLanguage(), mbi.getText());
                titles.put("mixed" + i, lang);
                ++i;
            }
            this.modulelistener.setMenuTitles(titles);
        }
        this.searchScreen.update(pays, this.page == 0, this.page == this.maxPage);
    }

    class LocalMenuButtonActionListener
    implements ActionListener {
        private final MenuItem item;

        public LocalMenuButtonActionListener(MenuItem item) {
            this.item = item;
        }

        public void onAction() {
            MenuSearchModule.this.log.debug((Object)("onAction():" + this.item.getName()));
            Global.getInstance().getKeeperModule().getPaymentModule().payment(this.item);
        }
    }
}

