/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper.menu;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import plfx.keeper.model.MapDescriptor;
import plfx.screen.ScreenInit;
import plfx.screen.TemplateCreateException;
import plfx.screen.input.keeper.Global;
import plfx.screen.input.keeper.menu.MenuPager;
import plfx.screen.input.keeper.menu.MenuPagesProvider;
import plfx.screen.input.keeper.module.KeeperDefaultModule;
import plfx.screen.input.keeper.module.KeeperMenuListener;
import plfx.screen.input.keeper.utils.CashSourceHolder;
import plfx.screen.input.keeper.utils.CashSourceMenuHolder;
import plfx.screen.input.keeper.utils.MenuItemsHolder;
import plfx.screen.input.keeper.utils.ReferencesHelper;
import plfx.screen.input.keeper.utils.ServicesHolder;
import plfx.screen.menu.MenuTemplate;
import plfx.screen.menu.button.ActionListener;
import plfx.screen.menu.button.MenuButtonInit;
import ru.slkf.atm.AtmAPI;
import ru.softlogic.input.model.ModelEnvironment;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.keeper.api.model.reference.domain.DTOPoints;
import ru.softlogic.keeper.db.model.CashSource;
import ru.softlogic.keeper.db.model.CashSourceMenu;
import ru.softlogic.keeper.db.model.MenuItem;
import ru.softlogic.keeper.db.model.ProcessingPoint;
import ru.softlogic.keeper.db.model.Service;

public class MenuReceiptModule
extends KeeperDefaultModule {
    private MenuTemplate menuMainTemplate;
    private MenuTemplate menuGroupTemplate;
    private LocalMenuPagesProvider mainMenuPagesProvider;
    private LocalMenuPagesProvider groupMenuPagesProvider;
    private MenuPager mainPager;
    private MenuPager groupPager;
    private MenuItem menuItem;
    private Service service;
    private List<CashSourceMenu> current;
    private List<CashSourceMenu> root;
    private final Stack<List<CashSourceMenu>> stack = new Stack();
    private MenuItemsHolder miHolder = ReferencesHelper.getInstance().getMenuItemsHolder();
    private ServicesHolder sHolder = ReferencesHelper.getInstance().getServicesHolder();
    private CashSourceHolder csHolder = ReferencesHelper.getInstance().getCashSourceHolder();
    private CashSourceMenuHolder csmHolder = ReferencesHelper.getInstance().getCashSourceMenuHolder();
    private DTOPoints points;

    public MenuReceiptModule(AtmAPI modulelistener, Logger log) {
        super(modulelistener, log);
        try {
            this.menuMainTemplate = modulelistener.getMenuTemplate("receipt/main");
            this.menuGroupTemplate = modulelistener.getMenuTemplate("receipt/group");
            this.mainMenuPagesProvider = new LocalMenuPagesProvider();
            this.groupMenuPagesProvider = new LocalMenuPagesProvider();
            LocalMenuTemplateListener lis = new LocalMenuTemplateListener(modulelistener, log);
            this.mainPager = new MenuPager(modulelistener, this.mainMenuPagesProvider, lis, "group", this.menuMainTemplate, this.menuMainTemplate.getGroupArea());
            this.groupPager = new MenuPager(modulelistener, this.groupMenuPagesProvider, lis, "mixed", this.menuGroupTemplate, this.menuGroupTemplate.getMixedArea());
        }
        catch (TemplateCreateException ex) {
            log.error((Object)("Error get menu template:" + ex.getMessage()), (Throwable)ex);
        }
    }

    public void setRoot(MenuItem root) {
        this.log.debug((Object)("MenuReceiptModule setRoot:" + root));
        if (root.getService() != null) {
            this.menuItem = root;
        } else {
            this.log.debug((Object)("find service into group:" + root));
            List<MenuItem> childs = this.miHolder.getChilds(root.getId());
            for (MenuItem mi : childs) {
                if (mi.getService() == null) continue;
                this.log.debug((Object)("service found:" + mi));
                this.menuItem = mi;
                break;
            }
        }
        if (this.menuItem != null) {
            this.service = this.sHolder.getService(this.menuItem.getService().getId());
            Integer get = (Integer)Global.getInstance().getClientDescription().getCashSourceMenuProfiles().get(this.menuItem.getOperationType().getId());
            this.root = this.csmHolder.getChildsByMenuProfile(get);
            this.log.debug((Object)("cashSourceMenu:" + root));
        } else {
            this.log.warn((Object)"service for receipt not found");
        }
    }

    public void setPoints(DTOPoints p) {
        MapDescriptor descr;
        this.points = p;
        Double lat = null;
        Double lon = null;
        int pointId = this.modulelistener.getPointInfo().getPointId();
        ArrayList pList = new ArrayList(this.points.getPoints().size());
        for (ProcessingPoint pp : this.points.getPoints()) {
            HashMap<String, Object> it = new HashMap<String, Object>();
            it.put("id", pp.getIdProcessing());
            it.put("name", pp.getName());
            it.put("address", pp.getAddress());
            if (pp.getIdProcessing() == pointId) {
                lat = pp.getLatitude();
                lon = pp.getLongitude();
            }
            it.put("latitude", pp.getLatitude());
            it.put("longitude", pp.getLongitude());
            pList.add(it);
        }
        HashMap<String, Serializable> d = new HashMap<String, Serializable>();
        d.put("pointsList", pList);
        if (lat != null && lon != null && (descr = Global.getInstance().getKeeperModule().getMapRegistry().getMap(lat.doubleValue(), lon.doubleValue())) != null) {
            d.put("mapDescriptor", (Serializable)descr);
        }
        d.put("terminalId", Integer.valueOf(pointId));
        ModelEnvironment me = new ModelEnvironment(d, null, 1.0, null);
        try {
            this.menuMainTemplate.init(null, new ScreenInit(me));
        }
        catch (InitException ex) {
            this.log.error((Object)("error init points list:" + (Object)((Object)ex)), (Throwable)ex);
        }
    }

    @Override
    public void onStart(boolean timeout) {
        this.stack.clear();
        this.modulelistener.addDataItem("group", (Object)this.menuItem.getName());
        this.modulelistener.addDataItem("group_mode", (Object)"menu");
        this.current = null;
        this.inside(this.root);
    }

    @Override
    public void onFinish() {
        this.clearContext();
    }

    public void menu() {
        if (this.current == this.root) {
            this.mainPager.show();
        } else {
            this.groupPager.show();
        }
    }

    private void inside(List<CashSourceMenu> item) {
        if (this.current != null) {
            this.stack.push(this.current);
        }
        this.current = item;
        if (this.current == this.root) {
            this.mainMenuPagesProvider.setCurr(this.current);
            this.mainPager.firstPage();
        } else {
            this.groupMenuPagesProvider.setCurr(this.current);
            this.groupPager.firstPage();
        }
        this.menu();
    }

    private void outside() {
        if (this.stack.isEmpty()) {
            this.exit();
        } else {
            this.current = null;
            this.inside(this.stack.pop());
        }
    }

    private void clearContext() {
        this.stack.clear();
    }

    private void exit() {
        this.clearContext();
        Global.getInstance().getKeeperModule().getHomeModule().start();
    }

    @Override
    public void onTimeOut() {
        this.exit();
    }

    @Override
    public int getInactivityTimeout() {
        return 60;
    }

    class LocalMenuPagesProvider
    implements MenuPagesProvider {
        List<CashSourceMenu> curr;

        LocalMenuPagesProvider() {
        }

        public void setCurr(List<CashSourceMenu> curr) {
            this.curr = curr;
        }

        @Override
        public List<List<MenuButtonInit>> getPages(int pageSize) {
            ArrayList<List<MenuButtonInit>> res = new ArrayList<List<MenuButtonInit>>();
            List<CashSourceMenu> childs = this.curr;
            if (childs != null) {
                int i = 1;
                ArrayList<MenuButtonInit> list = null;
                for (CashSourceMenu ch : childs) {
                    if (list == null) {
                        list = new ArrayList<MenuButtonInit>(pageSize);
                    }
                    String img = null;
                    String type = null;
                    String style = "";
                    String desc = null;
                    boolean disable = false;
                    if (ch.getCashSource() != null) {
                        CashSource cs = MenuReceiptModule.this.csHolder.getItem(ch.getCashSource().getId());
                        disable = !cs.getCode().equals("TERMINAL");
                    }
                    MenuButtonInit bi = new MenuButtonInit(type, ch.getName(), img, style, desc, disable, (ActionListener)new LocalMenuButtonActionListener(ch));
                    list.add(bi);
                    if (++i <= pageSize) continue;
                    res.add(list);
                    i = 0;
                    list = null;
                }
                if (list != null) {
                    res.add(list);
                }
            } else {
                res.add(new ArrayList());
            }
            MenuReceiptModule.this.log.debug((Object)("pages:" + res));
            return res;
        }
    }

    class LocalMenuTemplateListener
    extends KeeperMenuListener {
        public LocalMenuTemplateListener(AtmAPI modulelistener, Logger log) {
            super(modulelistener, log);
        }

        @Override
        protected void onAction(String id, Map<String, Object> data) {
            MenuReceiptModule.this.log.debug((Object)("MenuReceiptModule onAction():" + id));
            switch (id) {
                case "back": {
                    MenuReceiptModule.this.outside();
                }
            }
        }
    }

    class LocalMenuButtonActionListener
    implements ActionListener {
        private final CashSourceMenu item;

        public LocalMenuButtonActionListener(CashSourceMenu item) {
            this.item = item;
        }

        public void onAction() {
            MenuReceiptModule.this.log.debug((Object)("onAction():" + this.item.getName()));
            if (this.item.getCashSource() != null) {
                Global.getInstance().getKeeperModule().getReceiptModule().receipt(MenuReceiptModule.this.service.getId(), this.item);
            } else {
                List<CashSourceMenu> childs = MenuReceiptModule.this.csmHolder.getChilds(this.item.getId());
                MenuReceiptModule.this.log.debug((Object)("childs:" + childs));
                MenuReceiptModule.this.inside(childs);
            }
        }
    }
}

