/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper.home;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import org.apache.log4j.Logger;
import plfx.screen.ScreenListener;
import plfx.screen.input.group.InputComponent;
import plfx.screen.input.keeper.Global;
import plfx.screen.input.keeper.LazyDataProvider;
import plfx.screen.input.keeper.history.HistoryDataProvider;
import plfx.screen.input.keeper.menu.MenuPaymentModule;
import plfx.screen.input.keeper.menu.MenuReceiptModule;
import plfx.screen.input.keeper.module.KeeperDefaultModule;
import plfx.screen.input.keeper.module.KeeperScreenListener;
import plfx.screen.input.keeper.utils.MathUtils;
import plfx.screen.input.keeper.utils.ReferencesHelper;
import plfx.screen.keeper.input.popup.PopupHelper;
import ru.slkf.atm.AtmAPI;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.date.AbsoluteDateRange;
import ru.softlogic.input.model.field.date.DateField;
import ru.softlogic.input.model.field.date.DateRange;
import ru.softlogic.keeper.api.model.DTOVHistory;
import ru.softlogic.keeper.api.model.client.domain.DTOClientDescription;
import ru.softlogic.keeper.db.model.ClientAccount;
import ru.softlogic.keeper.db.model.MenuItem;
import ru.softlogic.keeper.db.model.OperationAttribute;
import ru.softlogic.keeper.db.model.Service;

public class HomeModule
extends KeeperDefaultModule {
    private LocalHomeListener homeScreenListener;
    private MenuItem rootAdd;
    private MenuItem rootPayment;
    private MenuItem rootTransfer;
    private DTOClientDescription clientDescription;
    private Set<DTOVHistory> operationsStorage;
    private HistoryDataProvider dataProvider;
    private LocalDate dateFrom;
    private LocalDate dateTo;
    private DateTimeFormatter sdf = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    public HomeModule(AtmAPI modulelistener, Logger log) {
        super(modulelistener, log);
        this.homeScreenListener = new LocalHomeListener(modulelistener, log);
        this.operationsStorage = new TreeSet<DTOVHistory>((o1, o2) -> {
            int r = o1.getOperation().getId().compareTo(o2.getOperation().getId());
            return r < 0 ? 1 : (r > 0 ? -1 : 0);
        });
        this.dataProvider = new HistoryDataProvider(this.operationsStorage, 10, false, new LazyDataProvider.ProxyDataProvider(){

            @Override
            public List getDataAfter(Long lastId, short pageSize) {
                return null;
            }

            @Override
            public List getData(int page, short pageSize) {
                ArrayList<DTOVHistory> res = null;
                Collection<DTOVHistory> doHistory = Global.getInstance().doHistory(page, pageSize, HomeModule.this.dateFrom, HomeModule.this.dateTo);
                if (doHistory != null) {
                    res = new ArrayList<DTOVHistory>();
                    res.addAll(doHistory);
                }
                return res;
            }
        });
    }

    public void onLogin(DTOClientDescription data) {
        this.clientDescription = data;
        this.rootAdd = Global.getInstance().findMenuRoot("RECEIPT");
        this.rootPayment = Global.getInstance().findMenuRoot("PAYMENT");
        this.rootTransfer = Global.getInstance().findMenuRoot("TRANSFER");
        this.log.debug((Object)("ROOT RECEIPT:" + this.rootAdd));
        this.log.debug((Object)("ROOT PAYMENT:" + this.rootPayment));
        this.log.debug((Object)("ROOT TRANSFER:" + this.rootTransfer));
        this.dateFrom = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        this.dateTo = LocalDate.now().with(TemporalAdjusters.lastDayOfMonth());
    }

    @Override
    public void onTimeOut() {
        this.log.debug((Object)"Home onTimeOut()");
        Global.getInstance().getKeeperModule().logout(true);
    }

    @Override
    public void onStart(boolean timeout) {
        this.home();
        this.log.debug((Object)"started home");
    }

    @Override
    public void onFinish() {
        this.rootAdd = null;
        this.rootPayment = null;
        this.rootTransfer = null;
        this.dataProvider.clear();
        this.dateFrom = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        this.dateTo = LocalDate.now().with(TemporalAdjusters.lastDayOfMonth());
        this.clientDescription = null;
    }

    public void home() {
        this.log.debug((Object)"home()");
        this.setSection("home");
        HashMap<String, Object> map = new HashMap<String, Object>();
        long totalAccBalance = 0L;
        HashMap<String, Object> accounts = new HashMap<String, Object>();
        ArrayList accList = new ArrayList();
        if (this.clientDescription == null) {
            try {
                this.clientDescription = Global.getInstance().doRefreshClientInfo();
            }
            catch (Exception ex) {
                this.log.error((Object)"Error refresh clietn info", (Throwable)ex);
                Global.getInstance().getKeeperModule().logout(false);
            }
        }
        for (ClientAccount a : this.clientDescription.getAccounts()) {
            HashMap<String, String> acc = new HashMap<String, String>();
            acc.put("title", a.getName());
            acc.put("number", "");
            acc.put("balance", MathUtils.formatMoney(a.getBalance() - a.getReserve()));
            accList.add(acc);
            totalAccBalance += a.getBalance() - a.getReserve();
        }
        accounts.put("list", accList);
        accounts.put("total", MathUtils.formatMoney(totalAccBalance));
        map.put("clientAccounts", accounts);
        this.dataProvider.clear();
        List ops = this.dataProvider.getData(0, (short)10);
        List operations = null;
        if (ops != null) {
            operations = ops;
        }
        SimpleDateFormat df = new SimpleDateFormat("d MMMM");
        ArrayList pays = new ArrayList();
        if (operations != null) {
            for (DTOVHistory op : operations) {
                Service s = ReferencesHelper.getInstance().getServicesHolder().getService(op.getOperation().getService().getId());
                if (s == null) continue;
                HashMap<String, Object> pay = new HashMap<String, Object>();
                pay.put("title", s.getName());
                pay.put("date", df.format(op.getOperation().getDateAdd()));
                pay.put("sum", MathUtils.formatMoney(op.getOperation().getSumOut().intValue()));
                Boolean st = null;
                if (op.getOperation().getState() == 6) {
                    st = true;
                } else if (op.getOperation().getState() == 8) {
                    st = false;
                }
                pay.put("state", st);
                pay.put("object", op);
                pays.add(pay);
            }
        }
        map.put("dateFrom", this.dateFrom);
        map.put("dateTo", this.dateTo);
        map.put("paymentsHistory", pays);
        map.put("notifyCount", 0);
        ArrayList notifies = new ArrayList();
        map.put("notifies", notifies);
        this.showOrCreate("home", () -> this.modulelistener.getScreen("keeper/home"), null, () -> this.homeScreenListener, map);
    }

    public void payment() {
        this.log.debug((Object)"payment()");
        if (this.rootPayment != null) {
            this.setSection("payment");
            MenuPaymentModule mm = Global.getInstance().getKeeperModule().getMenuPaymentModule();
            mm.setRoot(this.rootPayment);
            mm.start();
        } else {
            this.modulelistener.showDialog("system/error", i -> Global.getInstance().getKeeperModule().logout(false));
        }
    }

    public void transfer() {
        this.modulelistener.showDialog("system/notimplemented", i -> {});
    }

    public void receipt() {
        this.log.debug((Object)"receipt()");
        if (this.rootAdd != null) {
            this.setSection("receipt");
            MenuReceiptModule mm = Global.getInstance().getKeeperModule().getMenuReceiptModule();
            mm.setRoot(this.rootAdd);
            mm.start();
        } else {
            this.modulelistener.showDialog("system/error", i -> Global.getInstance().getKeeperModule().logout(false));
        }
    }

    private void repeat(DTOVHistory pay) {
        this.log.debug((Object)("pay:" + pay));
        for (OperationAttribute attr : pay.getAttributes()) {
            this.log.debug((Object)"--------------");
            this.log.debug((Object)("name:" + attr.getName()));
            this.log.debug((Object)("title:" + attr.getTitle()));
            this.log.debug((Object)("value:" + attr.getValue()));
            this.log.debug((Object)("view:" + attr.getView()));
        }
        Global.getInstance().getKeeperModule().getPaymentModule().payment(pay);
    }

    class LocalDateInputComponent
    implements InputComponent {
        Control control;
        DateField df;
        int index;

        public LocalDateInputComponent(Control control, DateField df, int index) {
            this.control = control;
            this.df = df;
            this.index = index;
        }

        public boolean isValid() {
            return true;
        }

        public void putData(Map<String, Object> map) {
            HomeModule.this.log.debug((Object)("putData:" + map));
        }

        public void getFocus() {
        }

        public void onLostFocus() {
        }

        public void setWarning(boolean bln) {
        }

        public int getIndex() {
            return this.index;
        }

        public void update(Map<String, Object> map) {
            HomeModule.this.log.debug((Object)("update:" + map));
            InputElement ie = (InputElement)map.get(this.df.getId());
            if (ie != null) {
                switch (ie.getKey()) {
                    case "dateFrom": {
                        HomeModule.this.dateFrom = LocalDate.from(HomeModule.this.sdf.parse(ie.getValue()));
                        HomeModule.this.dataProvider.clear();
                        HomeModule.this.home();
                        break;
                    }
                    case "dateTo": {
                        HomeModule.this.dateTo = LocalDate.from(HomeModule.this.sdf.parse(ie.getValue()));
                        HomeModule.this.dataProvider.clear();
                        HomeModule.this.home();
                    }
                }
            }
        }

        public Control getControl() {
            return this.control;
        }
    }

    class LocalHomeListener
    extends KeeperScreenListener
    implements ScreenListener {
        public LocalHomeListener(AtmAPI modulelistener, Logger log) {
            super(modulelistener, log);
        }

        @Override
        protected void onDefaultReceipt(Map<String, Object> data) {
            HomeModule.this.receipt();
        }

        @Override
        protected void onDefaultTransfer(Map<String, Object> data) {
            HomeModule.this.transfer();
        }

        @Override
        protected void onDefaultPayment(Map<String, Object> data) {
            HomeModule.this.payment();
        }

        @Override
        protected void onAction(String action, Map<String, Object> data) {
            switch (action) {
                case "dateTo": 
                case "dateFrom": {
                    DateField df = new DateField();
                    df.setId(action);
                    HashMap<String, InputElement> context = new HashMap<String, InputElement>();
                    if ("dateFrom".equals(action)) {
                        context.put(df.getId(), new InputElement(df.getId(), "Date", HomeModule.this.sdf.format(HomeModule.this.dateFrom), df.getFlags()));
                        df.setDateRange((DateRange)new AbsoluteDateRange(Date.from(HomeModule.this.dateFrom.minusYears(1L).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()), Date.from(HomeModule.this.dateTo.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()), Date.from(HomeModule.this.dateFrom.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant())));
                    } else {
                        context.put(df.getId(), new InputElement(df.getId(), "Date", HomeModule.this.sdf.format(HomeModule.this.dateTo), df.getFlags()));
                        df.setDateRange((DateRange)new AbsoluteDateRange(Date.from(HomeModule.this.dateFrom.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()), Date.from(HomeModule.this.dateTo.plusYears(1L).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()), Date.from(HomeModule.this.dateTo.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant())));
                    }
                    df.setFormat("dd.MM.yyyy");
                    df.setFormatTitle("dd.MM.yyyy");
                    LocalDateInputComponent component = new LocalDateInputComponent((Control)new Label(), df, 0);
                    PopupHelper.showPopup((IdentityField)df, (InputComponent)component, context, (ScreenListener)HomeModule.this.homeScreenListener, (int)0, (int)0);
                    break;
                }
                case "repeatPayment": {
                    DTOVHistory pay = (DTOVHistory)data.get("object");
                    HomeModule.this.repeat(pay);
                    break;
                }
                case "showNotify": {
                    int not = (Integer)data.get("object");
                    HomeModule.this.log.debug((Object)("Notify:" + not));
                    break;
                }
                case "accounts": {
                    HomeModule.this.modulelistener.showDialog("system/notimplemented", i -> {});
                    break;
                }
                case "notifies": {
                    HomeModule.this.modulelistener.showDialog("system/notimplemented", i -> {});
                    break;
                }
                case "paymentStats": {
                    HomeModule.this.modulelistener.showDialog("system/notimplemented", i -> {});
                    break;
                }
                case "history": {
                    Global.getInstance().getKeeperModule().getHistoryModule().start();
                }
            }
        }
    }
}

