/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import plfx.screen.input.keeper.Global;
import plfx.screen.input.keeper.utils.UserHelper;
import ru.slkf.api.KeeperApiModuleException;
import ru.slkf.api.KeeperApiSession;
import ru.slkf.api.Template;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.keeper.api.model.client.domain.DTOClientDescription;
import ru.softlogic.keeper.api.model.template.DTOTemplateInfo;
import ru.softlogic.keeper.db.model.TemplateAttribute;
import ru.softlogic.smartkeeper.api.exception.KeeperApiException;

public class SessionImpl
implements KeeperApiSession {
    private final Global g;
    private final DTOClientDescription clientDescription;

    public SessionImpl(Global g, DTOClientDescription clientDescription) {
        this.g = g;
        this.clientDescription = clientDescription;
    }

    public void logout() {
        UserHelper.getInstance().clearUserCredetials();
    }

    public List<Template> getServiceTemplates(short serviceId) throws Exception {
        Collection<DTOTemplateInfo> templates;
        LinkedList<Template> res = null;
        try {
            templates = this.g.doTemplates(this.clientDescription.getClient().getId(), Integer.valueOf(serviceId));
        }
        catch (KeeperApiException ex) {
            throw new KeeperApiModuleException(ex.getMessage());
        }
        if (templates != null && templates.size() > 0) {
            res = new LinkedList<Template>();
            for (DTOTemplateInfo ti : templates) {
                int sum = ti.getSum().getOutcome();
                ArrayList<InputElement> attrList = new ArrayList<InputElement>(ti.getAttributes().size());
                for (TemplateAttribute attr : ti.getAttributes()) {
                    InputElement ie = new InputElement();
                    ie.setKey(attr.getName());
                    ie.setKeyTitle(attr.getTitle());
                    ie.setValue(attr.getValue());
                    ie.setOriginalValue(attr.getValue());
                    ie.setValueTitle(attr.getView());
                    attrList.add(ie);
                }
                res.add(new Template(ti.getTemplate().getId().longValue(), ti.getTemplate().getName(), attrList, sum));
            }
            if (!res.isEmpty()) {
                return res;
            }
        }
        return res;
    }
}

