/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.apache.log4j.Logger;
import plfx.screen.input.keeper.Global;
import plfx.screen.input.keeper.utils.ReferencesHelper;
import ru.softlogic.smartkeeper.api.exception.KeeperApiException;

public class ReferenceUpdater
implements Runnable {
    private final ReferencesHelper rh;
    private final BooleanProperty ready = new SimpleBooleanProperty(false);
    private final Logger log;
    private final Object lock = new Object();

    public ReferenceUpdater(ReferencesHelper rh, Logger log) {
        this.rh = rh;
        this.log = log;
    }

    @Override
    public synchronized void run() {
        while (!this.rh.isInitialized() && !Thread.currentThread().isInterrupted()) {
            this.log.info((Object)"ReferenceHelper not initialized yet. Wait...");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (this.rh.isInitialized()) {
            block16: {
                this.log.info((Object)"ReferenceUpdater start update");
                try {
                    this.setReady(false);
                    boolean update = false;
                    boolean ll = this.rh.isLocalLoad();
                    if (!ll) {
                        try {
                            this.rh.loadLocal();
                        }
                        catch (Exception e) {
                            this.log.error((Object)("Local reference load error: " + e.getMessage()));
                            this.log.error((Object)"reset all references");
                            this.rh.reload();
                        }
                    } else {
                        update = true;
                    }
                    if (this.rh.getVersion() == 0L) {
                        update = true;
                    }
                    if (update) {
                        try {
                            this.log.info((Object)"download reference");
                            if (Global.getInstance().downloadReference()) {
                                this.log.info((Object)"success");
                                this.setReady(true);
                            }
                            break block16;
                        }
                        catch (KeeperApiException e) {
                            this.log.error((Object)("Reference download error: " + e.getMessage()), (Throwable)e);
                        }
                        catch (Exception e) {
                            this.log.error((Object)("Local reference IO error: " + e.getMessage()), (Throwable)e);
                            this.log.error((Object)"reset all references");
                            this.rh.reload();
                        }
                        break block16;
                    }
                    this.setReady(true);
                }
                catch (Throwable e) {
                    this.log.error((Object)e, e);
                }
            }
            this.log.info((Object)"ReferenceUpdater finish update");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReady(boolean v) {
        Object object = this.lock;
        synchronized (object) {
            this.ready.set(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isReady() {
        boolean v;
        Object object = this.lock;
        synchronized (object) {
            v = this.ready.get();
        }
        return v;
    }

    public BooleanProperty getReadyProperty() {
        return this.ready;
    }
}

