/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper;

import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import plfx.screen.input.keeper.KeeperModuleImpl;
import plfx.screen.input.keeper.LoginPinImpl;
import plfx.screen.input.keeper.SessionImpl;
import plfx.screen.input.keeper.utils.ReferencesHelper;
import plfx.screen.input.keeper.utils.UserHelper;
import ru.slkf.api.KeeperApiLoginPin;
import ru.slkf.api.KeeperApiLoginResult;
import ru.slkf.api.KeeperApiSession;
import ru.slkf.atm.AtmAPI;
import ru.softlogic.keeper.api.model.DTOHistory;
import ru.softlogic.keeper.api.model.DTOHistoryChange;
import ru.softlogic.keeper.api.model.DTOPager;
import ru.softlogic.keeper.api.model.DTOResponse;
import ru.softlogic.keeper.api.model.DTOResult;
import ru.softlogic.keeper.api.model.DTOSum;
import ru.softlogic.keeper.api.model.DTOVHistory;
import ru.softlogic.keeper.api.model.autopayment.DTOAutoPayment;
import ru.softlogic.keeper.api.model.autopayment.DTOAutoPaymentInfo;
import ru.softlogic.keeper.api.model.autopayment.DTOAutoPaymentResponse;
import ru.softlogic.keeper.api.model.autopayment.DTOAutoPaymentsResponse;
import ru.softlogic.keeper.api.model.client.DTOInfoResponse;
import ru.softlogic.keeper.api.model.client.DTOLogin;
import ru.softlogic.keeper.api.model.client.DTOLoginConfirm;
import ru.softlogic.keeper.api.model.client.DTOLoginResponse;
import ru.softlogic.keeper.api.model.client.DTORecoveryInfo;
import ru.softlogic.keeper.api.model.client.DTORecoveryResponse;
import ru.softlogic.keeper.api.model.client.DTORegistration;
import ru.softlogic.keeper.api.model.client.DTORegistrationInfo;
import ru.softlogic.keeper.api.model.client.DTORegistrationResponse;
import ru.softlogic.keeper.api.model.client.DTOSRecovery;
import ru.softlogic.keeper.api.model.client.DTOSecureLoginResponse;
import ru.softlogic.keeper.api.model.client.domain.DTOClientDescription;
import ru.softlogic.keeper.api.model.client.domain.DTOLoginPin;
import ru.softlogic.keeper.api.model.client.domain.DTOSecureLogin;
import ru.softlogic.keeper.api.model.commission.CommissionCalculator;
import ru.softlogic.keeper.api.model.commission.CommissionInfo;
import ru.softlogic.keeper.api.model.commission.SumResult;
import ru.softlogic.keeper.api.model.operation.DTOHistoryChangeResponse;
import ru.softlogic.keeper.api.model.operation.DTOHistoryPagerResponse;
import ru.softlogic.keeper.api.model.operation.DTOOperationInformation;
import ru.softlogic.keeper.api.model.operation.DTOPayment;
import ru.softlogic.keeper.api.model.operation.DTOPaymentResponse;
import ru.softlogic.keeper.api.model.options.DTOChangeNumberResponse;
import ru.softlogic.keeper.api.model.options.DTOChangePasswordResponse;
import ru.softlogic.keeper.api.model.options.DTOPrivateResponse;
import ru.softlogic.keeper.api.model.options.DTOSaveSubscribeResponse;
import ru.softlogic.keeper.api.model.options.DTOSubscribeResponse;
import ru.softlogic.keeper.api.model.options.domain.DTOChangeLoginType;
import ru.softlogic.keeper.api.model.options.domain.DTOChangeNumber;
import ru.softlogic.keeper.api.model.options.domain.DTOChangePassword;
import ru.softlogic.keeper.api.model.options.domain.DTOChangePayPasswordSecure;
import ru.softlogic.keeper.api.model.options.domain.DTOChangeSecretKey;
import ru.softlogic.keeper.api.model.options.domain.DTOEmailChange;
import ru.softlogic.keeper.api.model.options.domain.DTOPrivate;
import ru.softlogic.keeper.api.model.options.domain.DTOSubscribe;
import ru.softlogic.keeper.api.model.options.domain.DTOSubscribeOne;
import ru.softlogic.keeper.api.model.options.domain.DTOSubscribeOneSave;
import ru.softlogic.keeper.api.model.options.domain.DTOSubscribeSave;
import ru.softlogic.keeper.api.model.pin.DTOPin;
import ru.softlogic.keeper.api.model.pin.DTOPinConfirm;
import ru.softlogic.keeper.api.model.reference.DTOPointsResponse;
import ru.softlogic.keeper.api.model.reference.DTOReferenceResponse;
import ru.softlogic.keeper.api.model.reference.domain.DTOPoints;
import ru.softlogic.keeper.api.model.reference.domain.DTOReference;
import ru.softlogic.keeper.api.model.template.DTOBlankTemplate;
import ru.softlogic.keeper.api.model.template.DTOTemplate;
import ru.softlogic.keeper.api.model.template.DTOTemplateInfo;
import ru.softlogic.keeper.api.model.template.DTOTemplateResponse;
import ru.softlogic.keeper.api.model.template.DTOTemplatesResponse;
import ru.softlogic.keeper.db.model.ClientAccount;
import ru.softlogic.keeper.db.model.Commission;
import ru.softlogic.keeper.db.model.MenuItem;
import ru.softlogic.keeper.db.model.OperationType;
import ru.softlogic.keeper.db.model.OperationTypeMenuRoot;
import ru.softlogic.smartkeeper.api.KeeperApi;
import ru.softlogic.smartkeeper.api.KeeperApiBuilder;
import ru.softlogic.smartkeeper.api.RequestHeadersHelper;
import ru.softlogic.smartkeeper.api.exception.KeeperApiException;
import ru.softlogic.smartkeeper.api.utils.HashUtils;

public class Global {
    private KeeperApi api;
    private final Logger log = Logger.getLogger((String)"keeper");
    private static Global instance;
    private AtmAPI terminalListener;
    private KeeperModuleImpl keeperModule;
    private DTOReference references = ReferencesHelper.getInstance().getReferences();
    private DTOClientDescription clientDescription;
    private File imgPath;
    private Object DateTimeFormat;

    public static Global getInstance() {
        if (instance == null) {
            instance = new Global();
        }
        return instance;
    }

    private Global() {
        KeeperApiBuilder apiBuilder = new KeeperApiBuilder((RequestHeadersHelper)new LocalRequestHeadersHelper(), "http://192.168.0.28:8080");
        apiBuilder.log();
        this.api = apiBuilder.build();
        this.log.info((Object)"Global()");
    }

    public void setKeeperBaseUrl(String url) {
        this.log.info((Object)("Global.setKeeperBaseUrl():" + url));
        KeeperApiBuilder apiBuilder = new KeeperApiBuilder((RequestHeadersHelper)new LocalRequestHeadersHelper(), url);
        apiBuilder.log();
        this.api = apiBuilder.build();
    }

    private boolean processResponse(DTOResult result) throws KeeperApiException {
        if (result.getCode() == 200) {
            return true;
        }
        this.log.error((Object)("Result code:" + result.getCode()));
        this.log.error((Object)("Result msgCode:" + result.getMsgCode()));
        this.log.error((Object)("Result message:" + result.getMsg()));
        switch (result.getCode()) {
            case 400: 
            case 401: 
            case 422: {
                throw new KeeperApiException(result);
            }
        }
        return false;
    }

    public boolean downloadReference() throws KeeperApiException, IOException {
        DTOReferenceResponse resp = this.api.getReferences(true, false);
        if (this.processResponse(resp.getResult())) {
            ReferencesHelper.getInstance().updateReferences((DTOReference)resp.getData());
            return true;
        }
        return false;
    }

    public DTOOperationInformation doPayment(DTOPayment pay) throws IOException, KeeperApiException {
        try {
            DTOOperationInformation createPayment = null;
            DTOPaymentResponse resp = this.api.createPayment(this.clientDescription.getClient().getId().longValue(), pay);
            if (this.processResponse(resp.getResult())) {
                createPayment = (DTOOperationInformation)resp.getData();
            }
            return createPayment;
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex, ex);
            throw ex;
        }
    }

    public boolean isExist(String login) throws Exception {
        try {
            DTOResponse resp = this.api.isClientExists(login);
            if (this.processResponse(resp.getResult())) {
                return true;
            }
        }
        catch (KeeperApiException ex) {
            this.log.error((Object)ex);
        }
        catch (IOException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return false;
    }

    public boolean setSecret(String secret) throws Exception {
        try {
            DTOResponse resp = this.api.saveSecretWord(this.clientDescription.getClient().getId().longValue(), new DTOChangeSecretKey(secret));
            if (this.processResponse(resp.getResult())) {
                return true;
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return false;
    }

    public KeeperApiLoginResult login(String login, String password) throws Exception {
        try {
            String passHash = HashUtils.createMd5Hash((String)password);
            DTOLogin logRes = new DTOLogin(login, passHash);
            DTOSecureLoginResponse resp = this.api.secureLogin(logRes);
            if (this.processResponse(resp.getResult())) {
                DTOSecureLogin secureRes = (DTOSecureLogin)resp.getData();
                if (secureRes.getDtoClientDescription() != null) {
                    UserHelper.getInstance().setUserCredetials(login, passHash);
                    return new KeeperApiLoginResult((KeeperApiSession)new SessionImpl(this, secureRes.getDtoClientDescription()), null);
                }
                return new KeeperApiLoginResult(null, (KeeperApiLoginPin)new LoginPinImpl(this, login, passHash, secureRes.getDtoPin()));
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return null;
    }

    public KeeperApiSession loginPin(DTOLoginPin loginPin, String pin) throws Exception {
        try {
            String pinHash = HashUtils.createMd5Hash((String)pin);
            DTOLoginConfirm confirm = new DTOLoginConfirm(loginPin.getClient(), pinHash);
            DTOLoginResponse resp = this.api.confirmLogin(loginPin.getId(), confirm);
            if (this.processResponse(resp.getResult())) {
                return new SessionImpl(this, (DTOClientDescription)resp.getData());
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return null;
    }

    public DTOSecureLogin doLogin(String login, String password) throws Exception {
        UserHelper userHelper = UserHelper.getInstance();
        try {
            String passHash = HashUtils.createMd5Hash((String)password);
            DTOLogin logRes = new DTOLogin(login, passHash);
            DTOSecureLoginResponse resp = this.api.secureLogin(logRes);
            if (this.processResponse(resp.getResult())) {
                DTOSecureLogin secureRes = (DTOSecureLogin)resp.getData();
                if (secureRes.getDtoClientDescription() != null) {
                    this.clientDescription = secureRes.getDtoClientDescription();
                    userHelper.setUserCredetials(login, passHash);
                }
                return secureRes;
            }
        }
        catch (IOException | KeeperApiException ex) {
            userHelper.clearUserCredetials();
            this.log.error((Object)ex);
            throw ex;
        }
        return null;
    }

    public DTOClientDescription doRefreshClientInfo() throws Exception {
        try {
            DTOInfoResponse resp = this.api.getClientInfo(this.clientDescription.getClient().getId().longValue(), false);
            if (this.processResponse(resp.getResult())) {
                this.clientDescription = (DTOClientDescription)resp.getData();
                return this.clientDescription;
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return null;
    }

    public DTOClientDescription doLoginPin(DTOLoginPin loginPin, String login, String password, String pin) throws Exception {
        UserHelper userHelper = UserHelper.getInstance();
        try {
            String pinHash = HashUtils.createMd5Hash((String)pin);
            DTOLoginConfirm confirm = new DTOLoginConfirm(loginPin.getClient(), pinHash);
            DTOLoginResponse resp = this.api.confirmLogin(loginPin.getId(), confirm);
            if (this.processResponse(resp.getResult())) {
                this.clientDescription = (DTOClientDescription)resp.getData();
                String passHash = HashUtils.createMd5Hash((String)password);
                userHelper.setUserCredetials(login, passHash);
                return this.clientDescription;
            }
        }
        catch (IOException | KeeperApiException ex) {
            userHelper.clearUserCredetials();
            this.log.error((Object)ex);
            throw ex;
        }
        return null;
    }

    public DTORegistrationInfo doRegister(String login) throws Exception {
        UserHelper userHelper = UserHelper.getInstance();
        try {
            UserHelper.getInstance().clearUserCredetials();
            DTORegistration dtor = new DTORegistration(login);
            DTORegistrationResponse resp = this.api.createAccount(dtor);
            if (this.processResponse(resp.getResult())) {
                DTORegistrationInfo reg = (DTORegistrationInfo)resp.getData();
                return reg;
            }
        }
        catch (IOException | KeeperApiException ex) {
            userHelper.clearUserCredetials();
            this.log.error((Object)ex);
            throw ex;
        }
        return null;
    }

    public Boolean doRegisterPin(DTORegistrationInfo regPin, String pin) throws Exception {
        UserHelper userHelper = UserHelper.getInstance();
        try {
            String pinHash = HashUtils.createMd5Hash((String)pin);
            DTOPinConfirm confirm = new DTOPinConfirm(pinHash);
            DTOResponse resp = this.api.confirmRegister(regPin.getActionPinAccept().longValue(), confirm);
            if (this.processResponse(resp.getResult())) {
                return true;
            }
        }
        catch (IOException | KeeperApiException ex) {
            userHelper.clearUserCredetials();
            this.log.error((Object)ex);
            throw ex;
        }
        return null;
    }

    public String doRecover(String login, String secret) throws Exception {
        UserHelper userHelper = UserHelper.getInstance();
        try {
            UserHelper.getInstance().clearUserCredetials();
            String passHash = HashUtils.createMd5Hash((String)secret);
            DTOSRecovery dtor = new DTOSRecovery(login, passHash);
            DTORecoveryResponse resp = this.api.recoverPasswordSecure(dtor);
            if (this.processResponse(resp.getResult())) {
                DTORecoveryInfo reg = (DTORecoveryInfo)resp.getData();
                return reg.getCode();
            }
        }
        catch (IOException | KeeperApiException ex) {
            userHelper.clearUserCredetials();
            this.log.error((Object)ex);
            throw ex;
        }
        return null;
    }

    public DTOPoints doGetPoints() throws Exception {
        try {
            DTOPointsResponse resp = this.api.getProcessingPoints(Boolean.valueOf(false), null, null, Integer.valueOf(this.terminalListener.getPointInfo().getPointId()));
            if (this.processResponse(resp.getResult())) {
                DTOPoints points = (DTOPoints)resp.getData();
                return points;
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return null;
    }

    public DTOPrivate doGetPrivate() throws Exception {
        try {
            DTOPrivateResponse resp = this.api.getPrivate(this.clientDescription.getClient().getId().longValue());
            if (this.processResponse(resp.getResult())) {
                return (DTOPrivate)resp.getData();
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return null;
    }

    public DTOPrivate doUpdatePrivate(DTOPrivate pr) throws Exception {
        try {
            DTOPrivateResponse resp = this.api.saveProfile(this.clientDescription.getClient().getId().longValue(), pr);
            if (this.processResponse(resp.getResult())) {
                return (DTOPrivate)resp.getData();
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return null;
    }

    public boolean doUpdateEmail(String email) throws Exception {
        try {
            DTOResponse resp = this.api.createRequestEmailChange(this.clientDescription.getClient().getId().longValue(), new DTOEmailChange(email));
            if (this.processResponse(resp.getResult())) {
                return true;
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return false;
    }

    public DTOPin doUpdatePhone(String phone, String secret) throws Exception {
        try {
            String secretHash = HashUtils.createMd5Hash((String)secret);
            DTOChangeNumberResponse resp = this.api.changeNumber(this.clientDescription.getClient().getId().longValue(), new DTOChangeNumber(phone, secretHash));
            if (this.processResponse(resp.getResult())) {
                return (DTOPin)resp.getData();
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return null;
    }

    public DTOPin doUpdatePassword(String oldPassword, String newPassword) throws Exception {
        try {
            String oldHash = HashUtils.createMd5Hash((String)oldPassword);
            String newHash = HashUtils.createMd5Hash((String)newPassword);
            DTOChangePasswordResponse resp = this.api.changePassword(this.clientDescription.getClient().getId().longValue(), new DTOChangePassword(oldHash, newHash));
            if (this.processResponse(resp.getResult())) {
                return (DTOPin)resp.getData();
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return null;
    }

    public boolean doUpdatePayPassword(short type, String password, String secret) throws Exception {
        try {
            String passwordHash = password == null ? null : HashUtils.createMd5Hash((String)password);
            String secretHash = HashUtils.createMd5Hash((String)secret);
            DTOResponse resp = this.api.changePayPassword(this.clientDescription.getClient().getId().longValue(), new DTOChangePayPasswordSecure(Short.valueOf(type), passwordHash, secretHash));
            if (this.processResponse(resp.getResult())) {
                return true;
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return false;
    }

    public Boolean doConfirmPin(long pinId, String pin1, String pin2) throws Exception {
        try {
            DTOPinConfirm confirm;
            String pin1Hash = HashUtils.createMd5Hash((String)pin1);
            if (pin2 != null) {
                String pin2Hash = HashUtils.createMd5Hash((String)pin2);
                confirm = new DTOPinConfirm(pin1Hash, pin2Hash);
            } else {
                confirm = new DTOPinConfirm(pin1Hash);
            }
            DTOResponse resp = this.api.confirmPinOperation(this.clientDescription.getClient().getId().longValue(), pinId, confirm);
            if (this.processResponse(resp.getResult())) {
                return true;
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return null;
    }

    public Boolean doUpdateAuthType(short type) throws Exception {
        try {
            DTOResponse resp = this.api.changeLoginType(this.clientDescription.getClient().getId().longValue(), new DTOChangeLoginType(Short.valueOf(type)));
            if (this.processResponse(resp.getResult())) {
                return true;
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return null;
    }

    public DTOSubscribe doGetSubscribes() throws Exception {
        try {
            DTOSubscribeResponse resp = this.api.getNotify(this.clientDescription.getClient().getId().longValue());
            if (this.processResponse(resp.getResult())) {
                return (DTOSubscribe)resp.getData();
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return null;
    }

    public Boolean doUpdateSubscribe(List<DTOSubscribeOne> slist) throws Exception {
        try {
            DTOSubscribeOneSave sub = new DTOSubscribeOneSave();
            ArrayList opt = new ArrayList(slist.size());
            slist.stream().forEach(i -> opt.add(new DTOSubscribeOneSave(i.getMessageType(), i.getEventType(), i.isSelected())));
            DTOSubscribeSave ss = new DTOSubscribeSave(opt);
            DTOSaveSubscribeResponse resp = this.api.saveSubscribes(this.clientDescription.getClient().getId().longValue(), ss);
            if (this.processResponse(resp.getResult())) {
                return true;
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex);
            throw ex;
        }
        return null;
    }

    public DTOReference getReferences() {
        return this.references;
    }

    public DTOClientDescription getClientDescription() {
        return this.clientDescription;
    }

    public void setImgPath(File imgPath) {
        this.imgPath = imgPath;
    }

    public File getImgPath() {
        return this.imgPath;
    }

    public AtmAPI getTerminalListener() {
        return this.terminalListener;
    }

    public void setTerminalListener(AtmAPI terminalListener) {
        this.terminalListener = terminalListener;
    }

    public KeeperModuleImpl getKeeperModule() {
        return this.keeperModule;
    }

    public void setKeeperModule(KeeperModuleImpl keeperModule) {
        this.keeperModule = keeperModule;
    }

    public void logout() {
        this.clientDescription = null;
        UserHelper userHelper = UserHelper.getInstance();
        userHelper.clearUserCredetials();
    }

    public Collection<DTOVHistory> doHistoryLast(Long lastId, short pageSize) {
        try {
            DTOHistoryChange dtoHistoryChange = new DTOHistoryChange();
            dtoHistoryChange.setLastId(lastId);
            dtoHistoryChange.setLimit(pageSize);
            DTOHistoryChangeResponse resp = this.api.getOperations(this.clientDescription.getClient().getId().longValue(), dtoHistoryChange);
            if (this.processResponse(resp.getResult())) {
                return (Collection)resp.getData();
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex, ex);
        }
        return null;
    }

    public Collection<DTOVHistory> doHistory(int page, short pageSize, LocalDate fromDate, LocalDate toDate) {
        try {
            Date endDate;
            Date startDate;
            DTOHistory dtoHistory = new DTOHistory();
            dtoHistory.setPage(page + 1);
            dtoHistory.setPageSize(pageSize);
            if (fromDate == null) {
                Calendar cal1 = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                cal1.set(2000, 0, 1);
                startDate = cal1.getTime();
            } else {
                startDate = Date.from(fromDate.atStartOfDay().atZone(ZoneId.of("GMT")).toInstant());
            }
            if (toDate == null) {
                Calendar cal2 = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                cal2.add(5, 1);
                endDate = cal2.getTime();
            } else {
                endDate = Date.from(toDate.plusDays(1L).atStartOfDay().atZone(ZoneId.of("GMT")).toInstant());
            }
            this.log.debug((Object)("startDate:" + startDate));
            this.log.debug((Object)("endDate:" + endDate));
            dtoHistory.setStartDate(startDate);
            dtoHistory.setEndDate(endDate);
            DTOHistoryPagerResponse resp = this.api.getOperationsPager(this.clientDescription.getClient().getId().longValue(), dtoHistory);
            if (this.processResponse(resp.getResult())) {
                DTOPager res = (DTOPager)resp.getData();
                return res.getValues();
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex, ex);
        }
        return null;
    }

    public Collection<DTOTemplateInfo> doTemplates() throws Exception {
        try {
            DTOTemplatesResponse resp = this.api.getTemplates(this.clientDescription.getClient().getId().longValue(), null, null);
            if (this.processResponse(resp.getResult())) {
                Collection res = (Collection)resp.getData();
                return res;
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex, ex);
            throw ex;
        }
        return null;
    }

    public Collection<DTOTemplateInfo> doTemplates(long \u0441lientId, Integer serviceId) throws Exception {
        try {
            DTOTemplatesResponse resp = this.api.getTemplates(\u0441lientId, null, serviceId);
            if (this.processResponse(resp.getResult())) {
                Collection res = (Collection)resp.getData();
                return res;
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex, ex);
            throw ex;
        }
        return null;
    }

    public Collection<DTOAutoPaymentInfo> doAutoPayments() {
        try {
            DTOAutoPaymentsResponse resp = this.api.getAutoPayments(this.clientDescription.getClient().getId().longValue());
            if (this.processResponse(resp.getResult())) {
                Collection res = (Collection)resp.getData();
                return res;
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex, ex);
        }
        return null;
    }

    public boolean createTemplate(Long operationId, String tplName) throws Exception {
        try {
            DTOTemplateResponse resp = this.api.createTemplateByOperation(this.clientDescription.getClient().getId().longValue(), operationId.longValue(), new DTOBlankTemplate(tplName));
            if (this.processResponse(resp.getResult())) {
                return true;
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex, ex);
            throw ex;
        }
        return false;
    }

    public DTOTemplateInfo editTemplate(Long tplId, DTOTemplate tpl) throws Exception {
        try {
            DTOTemplateResponse resp = this.api.editTemplate(this.clientDescription.getClient().getId().longValue(), tplId.longValue(), tpl);
            if (this.processResponse(resp.getResult())) {
                return (DTOTemplateInfo)resp.getData();
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex, ex);
            throw ex;
        }
        return null;
    }

    public DTOTemplateInfo addTemplate(DTOTemplate tpl) throws Exception {
        try {
            DTOTemplateResponse resp = this.api.createTemplate(this.clientDescription.getClient().getId().longValue(), tpl);
            if (this.processResponse(resp.getResult())) {
                return (DTOTemplateInfo)resp.getData();
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex, ex);
            throw ex;
        }
        return null;
    }

    public boolean removeTemplate(Long tplId) throws Exception {
        try {
            DTOResponse resp = this.api.removeTemplate(this.clientDescription.getClient().getId().longValue(), tplId.longValue());
            if (this.processResponse(resp.getResult())) {
                return true;
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex, ex);
            throw ex;
        }
        return false;
    }

    public DTOAutoPaymentInfo editAutopay(Long apayId, DTOAutoPayment apay) throws Exception {
        try {
            DTOAutoPaymentResponse resp = this.api.editAutoPayment(this.clientDescription.getClient().getId().longValue(), apayId.longValue(), apay);
            if (this.processResponse(resp.getResult())) {
                return (DTOAutoPaymentInfo)resp.getData();
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex, ex);
            throw ex;
        }
        return null;
    }

    public DTOAutoPaymentInfo addAutopay(DTOAutoPayment apay) throws Exception {
        try {
            DTOAutoPaymentResponse resp = this.api.createAutoPayment(this.clientDescription.getClient().getId().longValue(), apay);
            if (this.processResponse(resp.getResult())) {
                return (DTOAutoPaymentInfo)resp.getData();
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex, ex);
            throw ex;
        }
        return null;
    }

    public boolean removeAutopay(Long apayId) throws Exception {
        try {
            DTOResponse resp = this.api.removeAutoPayment(this.clientDescription.getClient().getId().longValue(), apayId.longValue());
            if (this.processResponse(resp.getResult())) {
                return true;
            }
        }
        catch (IOException | KeeperApiException ex) {
            this.log.error((Object)ex, ex);
            throw ex;
        }
        return false;
    }

    public MenuItem findMenuRoot(String code) {
        this.log.debug((Object)("findMenuRoot:" + code));
        Collection operationTypes = this.references.getOperationTypes();
        OperationType paymentType = null;
        for (OperationType ot : operationTypes) {
            if (!ot.getCode().equals(code)) continue;
            paymentType = ot;
            break;
        }
        if (paymentType != null && this.clientDescription != null) {
            this.log.debug((Object)("paymentType:" + paymentType));
            Collection menuRoot = this.clientDescription.getMenuRoot();
            this.log.debug((Object)("menuRoot:" + menuRoot));
            for (OperationTypeMenuRoot ot : menuRoot) {
                if (!ot.getOperationType().getId().equals(paymentType.getId())) continue;
                this.log.debug((Object)("FOUND!:" + ot));
                this.log.debug((Object)("MenuItem:" + ot.getMenuItem()));
                MenuItem mi = ReferencesHelper.getInstance().getMenuItemsHolder().getItem(ot.getMenuItem());
                this.log.debug((Object)("MenuItem from references:" + mi));
                return mi;
            }
        }
        return null;
    }

    private Set<Commission> filterCommissions(CommissionInfo commissionInfo, Set<Commission> commissions, short processingPaymentSource) {
        TreeSet<Commission> filtered = new TreeSet<Commission>();
        if (commissions != null) {
            short idProcessingCashSource = commissionInfo.getCommissionProfile().getUsePaymentSources() != null && commissionInfo.getCommissionProfile().getUsePaymentSources() != false ? processingPaymentSource : (short)0;
            for (Commission commission : commissions) {
                if (commission.getProcessingPaymentSource() == null || commission.getProcessingPaymentSource().getId() != idProcessingCashSource) continue;
                filtered.add(commission);
            }
        }
        return filtered;
    }

    public SumResult calcCommission(DTOSum sum, CommissionInfo commissionInfo, CommissionInfo minCommissionInfo, CommissionInfo maxCommissionInfo, short processingPaymentSourceId) {
        CommissionCalculator commissionCalculator = new CommissionCalculator();
        CommissionInfo commInfo = commissionInfo;
        if (commInfo != null && commInfo.getSteps() != null) {
            Set commissions = commInfo.getSteps();
            commInfo = new CommissionInfo(commInfo.getCommissionProfile(), this.filterCommissions(commInfo, commissions, processingPaymentSourceId));
        }
        if (sum.getOutcome() > 0) {
            int sumOut = sum.getOutcome();
            int sumIncome = commissionCalculator.calculateIncome(sumOut, commInfo, minCommissionInfo, maxCommissionInfo, null, processingPaymentSourceId);
            int sumComm = sumIncome - sumOut;
            return new SumResult(sumOut, sumComm, 0);
        }
        SumResult r = commissionCalculator.calculate(sum.getIncome(), commInfo, minCommissionInfo, maxCommissionInfo, null, processingPaymentSourceId);
        return r;
    }

    class LocalRequestHeadersHelper
    implements RequestHeadersHelper {
        public LocalRequestHeadersHelper() {
            Global.this.log.debug((Object)"LocalRequestHeadersHelper()");
        }

        public String getClientLogin() {
            String login = UserHelper.getInstance().getClientLogin();
            if (login != null) {
                return login;
            }
            return "";
        }

        public String getClientPassword() {
            String pwd = UserHelper.getInstance().getClientPasswordHash();
            if (pwd != null) {
                return pwd;
            }
            return "";
        }

        public String getUUID() {
            return "306db2cc-7c90-4a8b-8050-1e6a73b6532c";
        }

        public long getReferenceVersion() {
            return ReferencesHelper.getInstance().getVersion();
        }

        public String getApiUser() {
            return "poPANh8Rlo3Xdsf3";
        }

        public String getApiPassword() {
            return "316291527cbcdeca56ca2dd9d160faff";
        }

        public String getApiVersion() {
            return "1.0.10.0";
        }

        public String getClientVersion() {
            return "2.7.2";
        }

        public RequestHeadersHelper.InterfaceType getInterfaceType() {
            return RequestHeadersHelper.InterfaceType.TERMINAL;
        }

        public String getSecretKey() {
            return "B+DwxM=$8!Csf38\\rWL2aK{wD?am/P(Z";
        }

        public String getLocale() {
            return Locale.getDefault().toString();
        }

        public void onUpdateReferenceRequired() {
            Global.this.log.info((Object)"----------------------");
            Global.this.log.info((Object)"onUpdateReferenceRequired()");
            Global.this.keeperModule.getReferenceUpdater().run();
            Global.this.log.info((Object)"----------------------");
        }

        public void onClientAccountsUpdated(Collection<ClientAccount> clientAccounts) {
        }

        public void logRequest(String logInfo) {
            Global.this.log.trace((Object)"REQUEST:");
            Global.this.log.trace((Object)logInfo);
        }
    }
}

