/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.smartkeeper.api.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import ru.softlogic.keeper.api.model.jackson.ApiAnnotationIntrospector;

public class ObjectMapperFactory {
    private static volatile ObjectMapper instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectMapper getInstance() {
        if (instance != null) return instance;
        Class<ObjectMapperFactory> clazz = ObjectMapperFactory.class;
        synchronized (ObjectMapperFactory.class) {
            if (instance != null) return instance;
            instance = new ObjectMapper();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z", Locale.US);
            dateFormat.setLenient(false);
            instance.setDateFormat((DateFormat)dateFormat);
            instance.disable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
            instance.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            instance.disable(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS);
            instance.disable(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
            instance.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            instance.disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
            instance.setAnnotationIntrospector((AnnotationIntrospector)new ApiAnnotationIntrospector());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

