/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.smartkeeper.api.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import ru.softlogic.smartkeeper.api.dto.JsonEntity;
import ru.softlogic.smartkeeper.api.jackson.ObjectMapperFactory;

public class JsonEntityDeserializer
extends JsonDeserializer<JsonEntity> {
    public JsonEntity deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper objectMapper = ObjectMapperFactory.getInstance();
        TreeNode formNode = objectMapper.readTree(jp);
        JsonEntity jsonEntityDto = new JsonEntity();
        if (formNode != null) {
            TreeNode clientLocaleidNode;
            TreeNode clientLocale;
            TreeNode generation;
            TreeNode deleted;
            TreeNode fileReferenceSubPart;
            TextNode codeNode;
            TreeNode idNode = formNode.get("id");
            if (idNode != null) {
                jsonEntityDto.setId(Integer.valueOf(idNode.toString()));
            }
            if ((codeNode = (TextNode)formNode.get("code")) != null) {
                jsonEntityDto.setCode(codeNode.textValue());
            }
            if ((fileReferenceSubPart = formNode.get("fileReferenceSubPart")) != null) {
                jsonEntityDto.setJson(fileReferenceSubPart.toString());
            }
            if ((deleted = formNode.get("deleted")) != null) {
                jsonEntityDto.setDeleted(Boolean.valueOf(deleted.toString()));
            }
            if ((generation = formNode.get("generation")) != null) {
                jsonEntityDto.setGeneration(Integer.valueOf(generation.toString()));
            }
            if ((clientLocale = formNode.get("clientLocale")) != null && (clientLocaleidNode = clientLocale.get("id")) != null) {
                jsonEntityDto.setClientLocale(Integer.valueOf(clientLocaleidNode.toString()));
            }
        }
        return jsonEntityDto;
    }
}

