/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.smartkeeper.api.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import ru.softlogic.keeper.api.model.reference.domain.FileReferenceSubPartWrapper;
import ru.softlogic.keeper.db.model.common.Deletable;
import ru.softlogic.keeper.db.model.common.PrimaryKey;
import ru.softlogic.smartkeeper.api.jackson.JsonEntityDeserializer;

@Table(name="jsonentity")
@JsonDeserialize(using=JsonEntityDeserializer.class)
public class JsonEntity
extends PrimaryKey
implements Deletable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    private int id;
    @Column(name="code")
    private String code;
    @Column(name="json")
    private String json;
    @Column(name="entity_type")
    private String entityType;
    @Column(name="generation")
    private int generation;
    private boolean deleted;
    @Column(name="client_locale")
    private Integer clientLocale;

    public JsonEntity(FileReferenceSubPartWrapper fileReferenceSubPartWrapper, String entityType) {
        this.id = fileReferenceSubPartWrapper.getId();
        this.code = fileReferenceSubPartWrapper.getCode();
        this.entityType = entityType;
        this.generation = fileReferenceSubPartWrapper.getGeneration();
        this.clientLocale = fileReferenceSubPartWrapper.getClientLocale() != null ? fileReferenceSubPartWrapper.getClientLocale().getId() : null;
        this.deleted = fileReferenceSubPartWrapper.isDeleted();
    }

    public JsonEntity() {
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    public Integer getClientLocale() {
        return this.clientLocale;
    }

    public void setClientLocale(Integer clientLocale) {
        this.clientLocale = clientLocale;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    @Override
    public Number getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public static enum ENTITY_TYPE_ENUM {
        FORM_TYPE,
        SCENARIO_TYPE;

    }
}

