/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.smartkeeper.api;

import java.security.KeyStore;
import retrofit.ErrorHandler;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import ru.softlogic.smartkeeper.api.KeeperApi;
import ru.softlogic.smartkeeper.api.KeeperUrlConnectionClient;
import ru.softlogic.smartkeeper.api.RequestHeadersHelper;
import ru.softlogic.smartkeeper.api.exception.KeeperErrorHandler;
import ru.softlogic.smartkeeper.api.jackson.JacksonConverter;
import ru.softlogic.smartkeeper.api.jackson.ObjectMapperFactory;

public class KeeperApiBuilder {
    private final RequestHeadersHelper requestHeadersHelper;
    private final String baseUrl;
    private boolean verifyHostname = true;
    private int connectionTimeout = 30000;
    private int socketTimeout = 30000;
    private boolean isLogNeeded = false;
    private KeyStore keyStore = null;

    public KeeperApiBuilder connectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public KeeperApiBuilder socketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public KeeperApiBuilder log() {
        this.isLogNeeded = true;
        return this;
    }

    public KeeperApiBuilder keyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public KeeperApiBuilder disableVerifyHostName() {
        this.verifyHostname = false;
        return this;
    }

    public KeeperApiBuilder(RequestHeadersHelper requestHeadersHelper, String baseUrl) {
        if (requestHeadersHelper == null) {
            throw new IllegalArgumentException("requestHeadersHelper can't be null");
        }
        if (baseUrl == null) {
            throw new IllegalArgumentException("baseUrl can't be null");
        }
        this.requestHeadersHelper = requestHeadersHelper;
        this.baseUrl = baseUrl;
    }

    protected RestAdapter buildRestAdapter() {
        return new RestAdapter.Builder().setEndpoint(this.baseUrl + "/keeper-api").setClient((Client)new KeeperUrlConnectionClient(this.baseUrl, this.requestHeadersHelper, this.isLogNeeded, this.connectionTimeout, this.socketTimeout, this.keyStore, this.verifyHostname)).setConverter((Converter)new JacksonConverter(ObjectMapperFactory.getInstance())).setErrorHandler((ErrorHandler)new KeeperErrorHandler()).build();
    }

    public KeeperApi build() {
        RestAdapter restAdapter = this.buildRestAdapter();
        return (KeeperApi)restAdapter.create(KeeperApi.class);
    }
}

